set(concept_executables_list
  ClassTest_test
  Colorizer_test
  Exception_Base_test
  FuzzyStringComparator_test
  #GlobalExceptionHandler_test
  StreamHandler_test
  VersionInfo_test
  LogConfigHandler_test
  LogStream_test
  Multithreading_test
  UniqueIdGenerator_test
  UniqueIdIndexer_test
  UniqueIdInterface_test
)
set(qc_executables_list
  Contaminants_test
  DBSuitability_test
  FragmentMassError_test
  FWHM_test
  MissedCleavages_test
  Ms2IdentificationRate_test
  Ms2SpectrumStats_test
  MQEvidenceExporter_test
  MQMsmsExporter_test
  MzCalibration_test
  PeptideMass_test
  PSMExplainedIonCurrent_test
  QCBase_test
  RTAlignment_test
  TIC_test
)

set(datastructures_executables_list
  Adduct_test
  #BinaryTreeNode_test
  CalibrationData_test
  ClusteringGrid_test
  CVMappingRule_test
  CVMappingTerm_test
  CVMappings_test
  CVReference_test
  ChargePair_test
  Compomer_test
  ConvexHull2D_test
  DBoundingBox_test
  DIntervalBase_test
  DPosition_test
  DRange_test
  DataValue_test
  DateTime_test
  Date_test
  DefaultParamHandler_test
  DistanceMatrix_test
  FASTAContainer_test
  FlagSet_test
  GridBasedCluster_test
  GridBasedClustering_test
  GridFeature_test
  HashGrid_test
  ListUtils_test
  ListUtilsIO_test
  LPWrapper_test
  MassExplainer_test
  MatchedIterator_test
  Matrix_test
  OPXLDataStructs_test
  Param_test
  ParamValue_test
  QTCluster_test
  RangeManager_test
  StringListUtils_test
  StringUtils_test
  String_test
  #ToolDescription_test
)

set(metadata_executables_list
  AcquisitionInfo_test
  Acquisition_test
  AnnotatedMSRun_test
  CVTermList_test
  CVTermListInterface_test
  CVTerm_test
  ChromatogramSettings_test
  ContactPerson_test
  DataArrays_test
  DataProcessing_test
  DocumentIdentifier_test
  ExperimentalDesign_test
  ExperimentalSettings_test
  Gradient_test
  HPLC_test
  IdentificationData_test
  IdentificationDataConverter_test
  InstrumentSettings_test
  Instrument_test
  IonDetector_test
  IonSource_test
  MassAnalyzer_test
  MetaInfoDescription_test
  MetaInfoInterface_test
  MetaInfoInterfaceUtils_test
  MetaInfoRegistry_test
  MetaInfo_test
  PeptideEvidence_test
  PeptideHit_test
  PeptideIdentification_test
  PeptideIdentificationList_test
  Precursor_test
  Product_test
  ProteinHit_test
  ProteinIdentification_test
  Sample_test
  ScanWindow_test
  Software_test
  SourceFile_test
  SpectrumLookup_test
  SpectrumMetaDataLookup_test
  SpectrumSettings_test
  )

set(system_executables_list
  ExternalProcess_test
  File_test
  FileWatcher_test
  JavaInfo_test
  PythonInfo_test
  StopWatch_test
  SysInfo_test
)

set(kernel_executables_list
  AreaIterator_test
  BaseFeature_test
  ChromatogramPeak_test
  ChromatogramTools_test
  ConsensusFeature_test
  ConsensusMap_test
  ConversionHelper_test
  ConstRefVector_test
  DimMapper_test
  DPeak_test
  FeatureMap_test
  Feature_test
  MassTrace_test
  Mobilogram_test
  MobilityPeak1D_test
  MobilityPeak2D_test
  MRMFeature_test
  MRMTransitionGroup_test
  MSChromatogram_test
  MSExperiment_test
  OnDiscMSExperiment_test
  MSSpectrum_test
  Peak1D_test
  Peak2D_test
  PeakIndex_test
  RangeUtils_test
  RichPeak2D_test
  StandardTypes_test
  SpectrumHelper_test
)

set(format_executables_list
  AbsoluteQuantitationStandardsFile_test
  Base64_test
  MSNumpressCoder_test
  Bzip2Ifstream_test
  Bzip2InputStream_test
  ChromeleonFile_test
  CVMappingFile_test
  CompressedInputSource_test
  ConsensusXMLFile_test
  ControlledVocabulary_test
  CsvFile_test
  DTA2DFile_test
  DTAFile_test
  EDTAFile_test
  ExperimentalDesignFile_test
  FASTAFile_test
  FeatureFileOptions_test
  FeatureXMLFile_test
  FileHandler_test
  FileTypes_test
  GzipIfstream_test
  GzipInputStream_test
  IBSpectraFile_test
  IdXMLFile_test
  IndentedStream_test
  IndexedMzMLDecoder_test
  IndexedMzMLFile_test
  IndexedMzMLFileLoader_test
  InspectInfile_test
  InspectOutfile_test
  KroenikFile_test
  MRMFeatureQCFile_test
  MS2File_test
  MSPFile_test
  MSPGenericFile_test
  MascotGenericFile_test
  MascotRemoteQuery_test
  MascotXMLFile_test
  #MSDataWritingConsumer_test
  MRMFeaturePickerFile_test
  MsInspectFile_test
  MzDataFile_test
  MzIdentMLFile_test
  MzDataValidator_test
  MzIdentMLValidator_test
  MzMLFile_test
  MzMLSpectrumDecoder_test
  MzMLSqliteHandler_test
  MzMLSqliteSwathHandler_test
  MzMLValidator_test
  MzTab_test
  MzTabFile_test
  MzTabM_test
  MzTabMFile_test
  MzXMLFile_test
  NoopMSDataConsumer_test
  TraMLValidator_test
  OMSFile_test
  OMSSACSVFile_test
  OMSSAXMLFile_test
  OSWFile_test
  PTMXMLFile_test
  ParamCTDFile_test
  ParamJSONFile_test
  ParamXMLFile_test
  PeakFileOptions_test
  PeakTypeEstimator_test
  PepNovoInfile_test
  PepNovoOutfile_test
  PepXMLFileMascot_test
  PepXMLFile_test
  PercolatorInfile_test
  PercolatorOutfile_test
  ProtXMLFile_test
  SVOutStream_test
  SemanticValidator_test
  SequestInfile_test
  SequestOutfile_test
  SpecArrayFile_test
  SqMassFile_test
  SwathMapMassCorrection_test
  SwathFile_test
  SwathFileConsumer_test
  SwathWindowLoader_test
  TextFile_test
  ToolDescriptionFile_test
  TraMLFile_test
  TransformationXMLFile_test
  UnimodXMLFile_test
  XMassFile_test
  XMLFile_test
  XMLHandler_test
  XMLValidator_test
  XQuestResultXMLFile_test
  XTandemInfile_test
  XTandemXMLFile_test
  ZlibCompression_test
  # DATAACCESS
  MSDataCachedConsumer_test
  MSDataTransformingConsumer_test
  MSDataChainingConsumer_test
  MSDataStoringConsumer_test
  MSDataAggregatingConsumer_test
  SpectrumAccessQuadMZTransforming_test
  SpectrumAccessSqMass_test
  SiriusFragmentAnnotation_test
)

if(WITH_HDF5)
  list(APPEND format_executables_list HDF5_test)
endif()
if(WITH_PARQUET)
  list(APPEND format_executables_list Arrow_test QuantmsIO_test)
endif()

set(math_executables_list
  BasicStatistics_test
  BilinearInterpolation_test
  BSpline2d_test
  CubicSpline2d_test
  EmgGradientDescent_test
  GammaDistributionFitter_test
  GaussFitter_test
  GumbelDistributionFitter_test
  GridSearch_test
  CrossValidation_test
  Histogram_test
  LinearInterpolation_test
  LinearRegression_test
  MathFunctions_test
  #MSNumpress_test
  NNLS_test
  NonNegativeLeastSquaresSolver_test
  PosteriorErrorProbabilityModel_test
  QuadraticRegression_test
  RANSAC_test
  RANSACModel_test
  RANSACModelLinear_test
  RANSACModelQuadratic_test
  ROCCurve_test
  StatisticFunctions_test
)

set(filtering_executables_list
  DataFilters_test
  Deisotoper_test
  ElutionPeakDetection_test
  FeatureFindingMetabo_test
  FeatureOverlapFilter_test
  FastLowessSmoothing_test
  GaussFilter_test
  GaussFilterAlgorithm_test
  IDFilter_test
  InternalCalibration_test
  LinearResampler_test
  LinearResamplerAlign_test
  LowessSmoothing_test
  MassTraceDetection_test
  MorphologicalFilter_test
  MultiplexClustering_test
  MultiplexDeltaMasses_test
  MultiplexDeltaMassesGenerator_test
  MultiplexFilteredMSExperiment_test
  MultiplexFilteredPeak_test
  MultiplexFiltering_test
  MultiplexFilteringCentroided_test
  MultiplexFilteringProfile_test
  MultiplexIsotopicPeakPattern_test
  MultiplexSatelliteCentroided_test
  MultiplexSatelliteProfile_test
  MZTrafoModel_test
  NLargest_test
  Normalizer_test
  PrecursorCorrection_test
  SplineInterpolatedPeaks_test
  SplinePackage_test
  SavitzkyGolayFilter_test
  RankScaler_test
  SignalToNoiseEstimatorMeanIterative_test
  SignalToNoiseEstimatorMedian_test
  SignalToNoiseEstimatorMedianRapid_test
  SignalToNoiseEstimator_test
  SqrtScaler_test
  ThresholdMower_test
  WindowMower_test
  SpectraMerger_test
)

set(comparison_executables_list
  AverageLinkage_test
  BinnedSharedPeakCount_test
  BinnedSpectralContrastAngle_test
  BinnedSpectrumCompareFunctor_test
  BinnedSpectrum_test
  BinnedSumAgreeingIntensities_test
  ClusterAnalyzer_test
  ClusterFunctor_test
  ClusterHierarchical_test
  CompleteLinkage_test
  EuclideanSimilarity_test
  PeakAlignment_test
  PeakSpectrumCompareFunctor_test
  SingleLinkage_test
  SpectraSTSimilarityScore_test
  SpectrumAlignmentScore_test
  SpectrumAlignment_test
  SpectrumCheapDPCorr_test
  SpectrumPrecursorComparator_test
  SteinScottImproveScore_test
  ZhangSimilarityScore_test
)

set(chemistry_executables_list
  AAIndex_test
  AASequence_test
  CoarseIsotopeDistribution_test
  CrossLinksDB_test
  DecoyGenerator_test
  DigestionEnzymeProtein_test
  ElementDB_test
  Element_test
  EmpiricalFormula_test
  EnzymaticDigestion_test
  FineIsotopeDistribution_test
  IMSAlphabetParser_test
  IMSAlphabetTextParser_test
  IMSAlphabet_test
  IMSElement_test
  IMSIsotopeDistribution_test
  IntegerMassDecomposer_test
  IsoSpec_test
  IsotopeDistribution_test
  MassDecomposer_test
  ModificationDefinition_test
  ModificationDefinitionsSet_test
  ModificationsDB_test
  ModifiedNASequenceGenerator_test
  NASequence_test
  NucleicAcidSpectrumGenerator_test
  ProteaseDB_test
  ProteaseDigestion_test
  RNaseDigestion_test
  RealMassDecomposer_test
  ResidueDB_test
  ResidueModification_test
  Residue_test
  RibonucleotideDB_test
  Ribonucleotide_test
  SimpleTSGXLMS_test
  SpectrumAnnotator_test
  Tagger_test
  TheoreticalSpectrumGeneratorXLMS_test
  TheoreticalSpectrumGenerator_test
  Weights_test
)


set(analysis_executables_list
  AbsoluteQuantitation_test
  AbsoluteQuantitationMethod_test
  AbsoluteQuantitationMethodFile_test
  AbsoluteQuantitationStandards_test
  AccurateMassSearchEngine_test
  AhoCorasickAmbiguous_test
  AScore_test
  BaseGroupFinder_test
  BaseSuperimposer_test
  BasicProteinInferenceAlgorithm_test
  BayesianProteinInferenceAlgorithm_test
  ClusterProxyKD_test
  ConfidenceScoring_test
  ConsensusIDAlgorithmAverage_test
  ConsensusIDAlgorithmBest_test
  ConsensusIDAlgorithmPEPIons_test
  ConsensusIDAlgorithmPEPMatrix_test
  ConsensusIDAlgorithmRanks_test
  ConsensusIDAlgorithmWorst_test
  ConsensusMapNormalizerAlgorithmThreshold_test
  ConsensusMapNormalizerAlgorithmMedian_test
  ConsensusMapNormalizerAlgorithmQuantile_test
  ConsensusMapMergerAlgorithm_test
  #DataAccessHelper_test
  DeconvolvedSpectrum_test
  FalseDiscoveryRate_test
  FeatureDeconvolution_test
  FeatureDistance_test
  FeatureGroupingAlgorithmKD_test
  FeatureGroupingAlgorithmLabeled_test
  FeatureGroupingAlgorithmQT_test
  FeatureGroupingAlgorithmUnlabeled_test
  FeatureGroupingAlgorithm_test
  FeatureHandle_test
  FIAMSDataProcessor_test
  #FIAMSScheduler_test sometimes failing
  FLASHDeconvAlgorithm_test
  FLASHDeconvHelperStructs_test
  FragmentIndex_test
  IDBoostGraph_test
  IDMapper_test
  IDMergerAlgorithm_test
  IDRipper_test
  IDScoreSwitcherAlgorithm_test
  ILPDCWrapper_test
  IsotopeLabelingMDVs_test
  IncludeExcludeTarget_test
  IsobaricChannelExtractor_test
  IsobaricIsotopeCorrector_test
  IsobaricNormalizer_test
  IsobaricQuantitationMethod_test
  IsobaricQuantifier_test
  IsobaricQuantifierStatistics_test
  ItraqConstants_test
  ItraqFourPlexQuantitationMethod_test
  ItraqEightPlexQuantitationMethod_test
  TMTSixPlexQuantitationMethod_test
  TMTTenPlexQuantitationMethod_test
  TMTElevenPlexQuantitationMethod_test
  TMTSixteenPlexQuantitationMethod_test
  TMTEighteenPlexQuantitationMethod_test
  KDTreeFeatureMaps_test
  KDTreeFeatureNode_test
  LabeledPairFinder_test
  TargetedExperiment_test
  TargetedExperimentHelper_test
  MRMFeaturePicker_test
  MRMMapping_test
  MRMScoring_test
  MapAlignmentAlgorithmIdentification_test
  MapAlignmentAlgorithmKD_test
  MapAlignmentAlgorithmPoseClustering_test
  MapAlignmentAlgorithmTreeGuided_test
  MapAlignmentEvaluationAlgorithmPrecision_test
  MapAlignmentEvaluationAlgorithmRecall_test
  MapAlignmentEvaluationAlgorithm_test
  MapAlignmentTransformer_test
  MassDecompositionAlgorithm_test
  MassDecomposition_test
  MassFeatureTrace_test
  MetaboliteFeatureDeconvolution_test
  MetaboliteSpectralMatching_test
  ModifiedPeptideGenerator_test
  NeedlemanWunsch_test
  NeighborSeq_test
  PeptideIndexing_test
  PeptideAndProteinQuant_test
  PeptideProteinResolution_test
  PeakGroup_test
  PScore_test
  HyperScore_test
  MorpheusScore_test
  OpenPepXLAlgorithm_test
  OPXLHelper_test
  OPXLSpectrumProcessingAlgorithms_test
  PoseClusteringAffineSuperimposer_test
  PoseClusteringShiftSuperimposer_test
  PrecursorPurity_test
  QTClusterFinder_test
  ReactionMonitoringTransition_test
  NuXLModificationsGenerator_test
  NuXLParameterParsing_test
  SimpleSearchEngineAlgorithm_test
  SimpleSVM_test
  StablePairFinder_test
  PercolatorFeatureSetHelper_test
  TransformationDescription_test
  TransformationModel_test
  TransformationModelBSpline_test
  TransformationModelLowess_test
  TransformationModelInterpolated_test
  TransformationModelLinear_test
  XFDRAlgorithm_test
  XQuestScores_test
)

set(applications_executables_list
  INIUpdater_test
  #MapAlignerBase_test
  SearchEngineBase_test
  TOPPBase_test
  ToolHandler_test
  ParameterInformation_test
  ConsoleUtils_test
)

set(transformations_executables_list
  BaseModel_test
  BiGaussFitter1D_test
  BiGaussModel_test
  EGHTraceFitter_test
  ElutionModelFitter_test
  EmgFitter1D_test
  EmgModel_test
  ExtendedIsotopeFitter1D_test
  ExtendedIsotopeModel_test  
  FeatureFinderAlgorithmPickedHelperStructs_test
  FeatureFinderAlgorithmPicked_test
  FeatureFinderIdentificationAlgorithm_test
  FeatureFinderMultiplexAlgorithm_test
  Fitter1D_test
  GaussFitter1D_test
  GaussModel_test
  GaussTraceFitter_test
  IDConflictResolverAlgorithm_test
  InterpolationModel_test
  IsotopeFitter1D_test
  IsotopeModel_test
  LevMarqFitter1D_test
  MaxLikeliFitter1D_test
  ModelDescription_test
  PeakPickerHiRes_test
  PeakPickerIterative_test
  PeakWidthEstimator_test
  SeedListGenerator_test
  TraceFitter_test
)

if(NOT DISABLE_OPENSWATH)
set(transformations_executables_list
  ${transformations_executables_list}
  EmgScoring_test
)
endif(NOT DISABLE_OPENSWATH)

set(ionmobility_executables_list
  FAIMSHelper_test
  IMDataConverter_test
  IMTypes_test
)

if(NOT DISABLE_OPENSWATH)
  set(swath_executables_list
    MRMAssay_test
    MRMDecoy_test
    MRMIonSeries_test
    MRMRTNormalizer_test
    TransitionTSVFile_test
    TransitionPQPFile_test
    ChromatogramExtractor_test
    ChromatogramExtractorAlgorithm_test
    OpenSwathHelper_test
    OpenSwathScoring_test
    OpenSwathScores_test
    PeakIntegrator_test
    PeakPickerChromatogram_test
    PeakPickerMobilogram_test
    MRMTransitionGroupPicker_test
    DIAHelper_test
    DIAScoring_test
    DIAPrescoring_test
    OpenSwathMRMFeatureAccessOpenMS_test
    SpectrumAddition_test
    TargetedSpectraExtractor_test
    OpenSwathSpectrumAccessOpenMS_test
    OpenSwathDataAccessHelper_test
    MasstraceCorrelator_test
    MRMBatchFeatureSelector_test
    MRMFeatureScoring_test
    MRMFeatureSelector_test
    MRMFeatureFinderScoring_test
    MRMFeatureFilter_test
    MRMFeatureQC_test
    SpectrumHelpers_test
    StatsHelpers_test
    SwathQC_test
    IonMobilityScoring_test
    CachedMzML_test
    CachedMzMLHandler_test
  )
endif(NOT DISABLE_OPENSWATH)

set(Boost_dependent_tests
  DIAHelper_test
  EmgModel_test
  FASTAContainer_test
  LogConfigHandler_test
  LogStream_test
  MRMDecoy_test
  MRMFeatureFinderScoring_test
  MRMTransitionGroupPicker_test
  OpenSwathDataAccessHelper_test
  OpenSwathHelper_test
  OpenSwathMRMFeatureAccessOpenMS_test
  OpenSwathSpectrumAccessOpenMS_test
  PeakPickerChromatogram_test
  PeakPickerMobilogram_test
  SpectrumLookup_test
  SpectrumMetaDataLookup_test
  StatisticFunctions_test
  String_test
  TransitionTSVFile_test
  TransitionPQPFile_test
)

### collect test executables
set(TEST_executables
    ${concept_executables_list}
    ${system_executables_list}
    ${datastructures_executables_list}
    ${kernel_executables_list}
    ${metadata_executables_list}
    ${format_executables_list}
    ${math_executables_list}
    ${filtering_executables_list}
    ${comparison_executables_list}
    ${chemistry_executables_list}
    ${analysis_executables_list}
    ${applications_executables_list}
    ${transformations_executables_list}
    ${ionmobility_executables_list}
    ${swath_executables_list}
    ${qc_executables_list}
)
