OpenMS
=======

[![License (3-Clause BSD)](https://img.shields.io/badge/License-BSD%203--Clause-blue.svg?logo=data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz4NCjwhLS0gR2VuZXJhdG9yOiBBZG9iZSBJbGx1c3RyYXRvciAyNC4xLjEsIFNWRyBFeHBvcnQgUGx1Zy1JbiAuIFNWRyBWZXJzaW9uOiA2LjAwIEJ1aWxkIDApICAtLT4NCjxzdmcgdmVyc2lvbj0iMS4xIiBpZD0iTGF5ZXJfMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayIgeD0iMHB4IiB5PSIwcHgiDQoJIHZpZXdCb3g9IjAgMCA1MTIgNTEyIiBzdHlsZT0iZW5hYmxlLWJhY2tncm91bmQ6bmV3IDAgMCA1MTIgNTEyOyIgeG1sOnNwYWNlPSJwcmVzZXJ2ZSI+DQo8Zz4NCgk8cGF0aCBkPSJNMCwyNjcuMkMyLjQsMTI2LjksMTAwLjYsMjcuMSwyMjAuOCwxMUMzNjQuMS04LjIsNDg0LjcsODkuMyw1MDcuOSwyMTguNmMyMiwxMjIuNy00NS40LDIzNy41LTE1Ni41LDI4Mi45DQoJCWMtOS42LDMuOS0xNC45LDEuOC0xOC42LTcuOWMtMTguNC00Ny44LTM2LjgtOTUuNy01NS4xLTE0My41Yy0zLjItOC40LTEtMTMuNiw3LjItMTcuNGMyNS0xMS40LDQwLjYtMzAuNCw0NC43LTU3LjYNCgkJYzMuMS0yMC4yLTIuMy00MC44LTE0LjktNTYuOWMtMTIuNi0xNi4xLTMxLjQtMjYuMi01MS44LTI4Yy00MC4zLTMuNS03NC4xLDI0LjUtODAsNjEuNmMtNS40LDM0LjEsMTEuNSw2NS44LDQzLjMsODAuMg0KCQljOS45LDQuNSwxMS45LDguOSw4LjEsMTljLTE4LjUsNDguMS0zNyw5Ni4zLTU1LjQsMTQ0LjVjLTIuNyw3LjEtOC42LDkuNi0xNiw2LjdjLTU0LjMtMjEtMTA0LjctNjMtMTM1LjEtMTIyLjkNCgkJQzIsMzI4LjYsMS43LDI4OC44LDAsMjY3LjJMMCwyNjcuMnogTTIxLjYsMjY1LjJDMjIsMjcyLDIyLjIsMjgwLDIyLjksMjg4YzYuNSw3NC4zLDUxLjIsMTQ4LjIsMTM1LjMsMTg5LjENCgkJYzMuMywxLjUsNC41LDAuOCw1LjgtMi40YzE1LjQtNDAuNCwzMC45LTgwLjgsNDYuNS0xMjEuMWMxLjMtMy40LDAuNi01LTIuNS02LjljLTMyLjYtMjAuNi00OC44LTUwLjEtNDcuMS04OC44DQoJCWMxLTIyLjMsOS42LTQxLjgsMjQuNi01OC4xYzMxLTMzLjgsNzkuNS00MS4xLDExOS4zLTE4LjJjMzIuOSwxOSw1MS4yLDU1LjcsNDYuNyw5My4zYy0zLjcsMzEuNi0xOS45LDU1LjctNDcuMiw3Mi4xDQoJCWMtMi44LDEuNy0zLjYsMy0yLjQsNi4yYzE1LjcsNDAuNSwzMS4zLDgxLDQ2LjcsMTIxLjVjMS4yLDMuMiwyLjUsMy45LDUuOCwyLjRjMzYuNy0xNy4xLDY3LjMtNDEuNiw5MS03NC4zDQoJCUM0ODEuMiwzNTMsNDk2LDI5Ny41LDQ4OSwyMzYuNUM0NzQuOCwxMTUuMSwzNjUuNywxNC43LDIyNS4xLDMyQzExNS42LDQ1LjQsMjMuNSwxMzcuOCwyMS42LDI2NS4yTDIxLjYsMjY1LjJ6Ii8+DQo8L2c+DQo8L3N2Zz4NCg==&style=flat-square)](http://opensource.org/licenses/BSD-3-Clause)
[![Project Stats](https://www.openhub.net/p/open-ms/widgets/project_thin_badge.gif)](https://www.openhub.net/p/open-ms)
[![Discord Shield](https://img.shields.io/discord/832282841836159006?style=flat-square&message=Discord&color=5865F2&logo=Discord&logoColor=FFFFFF&label=Discord)](https://discord.gg/4TAGhqJ7s5)
[![Gitter](https://img.shields.io/static/v1?style=flat-square&message=on%20Gitter&color=ED1965&logo=Gitter&logoColor=FFFFFF&label=Chat)](https://gitter.im/OpenMS/OpenMS?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge)
[![Install with bioconda](https://img.shields.io/conda/v/bioconda/pyopenms?color=44A833&logo=Anaconda&style=flat-square&label=Install%20with%20bioconda)](http://bioconda.github.io/recipes/openms-meta/README.html)
[![Install with conda](https://img.shields.io/conda/v/openms/pyopenms?color=44A833&label=Install%20with%20conda%3A%3Aopenms&logo=Anaconda&style=flat-square)](https://anaconda.org/openms)
[![Documentation](https://img.shields.io/static/v1?style=flat-square&message=ReadTheDocs&color=2C4AA8&logo=ReadTheDocs&logoColor=FFFFFF&label=Documentation)](https://openms.readthedocs.io)
[![API docs](https://img.shields.io/static/v1?style=flat-square&message=Doxygen&color=2C4AA8&logo=ReadTheDocs&logoColor=FFFFFF&label=API%20docs)](https://abibuilder.cs.uni-tuebingen.de/archive/openms/Documentation/release/latest/html/index.html)
[![Gitpod Ready-to-Code](https://img.shields.io/badge/Gitpod-Ready--to--Code-blue?style=flat-square&logo=gitpod)](https://gitpod.io/#https://github.com/OpenMS/OpenMS) 

[OpenMS](http://www.openms.org/)
is an open-source software C++ library for LC-MS data management and
analyses. It offers an infrastructure for rapid development of mass
spectrometry related software. OpenMS is free software available under the
three clause BSD license and runs under Windows, macOS, and Linux.

It comes with a vast variety of pre-built and ready-to-use tools for proteomics
and metabolomics data analysis (TOPPTools) as well as powerful 1D, 2D and 3D
visualization (TOPPView).

OpenMS offers analyses for various quantitation protocols, including label-free
quantitation, SILAC, iTRAQ, TMT, SRM, SWATH, etc.

It provides built-in algorithms for de-novo identification and database search,
as well as adapters to other state-of-the art tools like X!Tandem, Mascot,
Comet, etc. It supports easy integration of OpenMS built tools into workflow
engines like KNIME, Galaxy, WS-Pgrade, and TOPPAS via the TOPPtools concept and
a unified parameter handling via a 'common tool description' (CTD) scheme.

With pyOpenMS, OpenMS offers Python bindings to a large part of the OpenMS API
to enable rapid algorithm development. OpenMS supports the Proteomics Standard
Initiative (PSI) formats for MS data. The main contributors of OpenMS are
currently the Eberhard-Karls-Universität in Tübingen, the Freie Universität
Berlin, and the ETH Zürich.

Features
--------
- Core C++ library under three-clause BSD licence using modern C++17
- Python bindings to the C++ API through pyOpenMS
- Major community file formats supported (mzML, mzXML, mzIdentXML, pepXML etc)
- Over 150+ individual analysis tools (TOPP Tools), covering most MS and LC-MS data processing and mining tasks
- Powerful 1D, 2D and 3D visualization tools (TOPPView)
- Support for most MS identification and quantification workflows (targeted, DIA, label-free, isobaric and stable isotope)
- Support for all major platforms (Windows [XP, 7, 8, 10], macOS and Linux)

Documentation
-------------

Users and developers should start by reading the [OpenMS documentation](https://openms.readthedocs.io/en/latest). OpenMS
API reference documentation and advanced developer doxygen documentation can be browsed [here](https://abibuilder.cs.uni-tuebingen.de/archive/openms/Documentation/release/latest/html/index.html).

openms.readthedocs.io documentation aims at being an entry point for users and developers alike. It is trying to be mostly version-independent and therefore
only consists of one main branch. We may introduce tags for older releases in the future.

The OpenMS API reference has several endpoints:

1. [`nightly`](https://abibuilder.cs.uni-tuebingen.de/archive/openms/Documentation/nightly/html/index.html): OpenMS API reference and advanced developer documentation of nightly releases.
2. [`release/latest`](https://abibuilder.cs.uni-tuebingen.de/archive/openms/Documentation/release/latest/html/index.html) : OpenMS API reference and advanced developer documentation of latest stable release.
3. [`release/${version}`](https://abibuilder.cs.uni-tuebingen.de/archive/openms/Documentation/release/latest/html/index.html) : OpenMS API reference and advanced developer documentation of an older version.

Documentation for the Python bindings pyOpenMS can be found on the [pyOpenMS online documentation](https://pyopenms.readthedocs.io).

Citation
--------
Please cite:

Rost HL, Sachsenberg T, Aiche S, Bielow C et al. OpenMS: a flexible open-source software platform for mass spectrometry data analysis. Nat Meth. 2016; 13, 9: 741-748. doi:10.1038/nmeth.3959.

The file [AUTHORS](AUTHORS) contains a list of all authors who worked on OpenMS.

Licence
-------
OpenMS is released under the [three clause BSD licence](LICENSE).
