var coding_conventions =
[
    [ "Formatting and style", "coding_conventions.html#formatting_and_style", [
      [ "Indentation", "coding_conventions.html#indentation", null ],
      [ "Spaces", "coding_conventions.html#spaces", null ],
      [ "Line endings", "coding_conventions.html#line_endings", null ],
      [ "Bracket placements", "coding_conventions.html#bracket_placements", null ]
    ] ],
    [ "Naming conventions", "coding_conventions.html#naming_conventions", [
      [ "Reserved words", "coding_conventions.html#reserved_words", null ],
      [ "File names", "coding_conventions.html#file_names", null ],
      [ "Underscores", "coding_conventions.html#underscores", null ],
      [ "Classes/Types/Namespaces", "coding_conventions.html#classes_types_namespaces", null ],
      [ "Method names", "coding_conventions.html#method_names", null ],
      [ "Variable names", "coding_conventions.html#variable_names", null ],
      [ "Enum and preprocessor constants", "coding_conventions.html#enum_and_preprocessor_constants", null ],
      [ "Parameters", "coding_conventions.html#parameters", null ],
      [ "File extensions", "coding_conventions.html#file_extensions", null ]
    ] ],
    [ "Classes", "coding_conventions.html#classes", [
      [ "Class requirements", "coding_conventions.html#class_requirements", null ],
      [ "Example class files", "coding_conventions.html#example_class_files", null ]
    ] ],
    [ "General rules", "coding_conventions.html#general_rules", [
      [ "Primitive types", "coding_conventions.html#primitive_types", null ],
      [ "Namespaces", "coding_conventions.html#namespaces", null ],
      [ "Accessors to members", "coding_conventions.html#accessors_to_members", null ],
      [ "Use of the STL", "coding_conventions.html#use_of_the_stl", null ]
    ] ],
    [ "Exceptions", "coding_conventions.html#exceptions", [
      [ "Exception handling", "coding_conventions.html#exception_handling", null ],
      [ "Throw exceptions", "coding_conventions.html#throw_exceptions", null ],
      [ "Catch exceptions", "coding_conventions.html#catch_exceptions", null ],
      [ "Specify exceptions", "coding_conventions.html#specify_exceptions", null ],
      [ "Exception classes", "coding_conventions.html#exception_classes", null ]
    ] ],
    [ "How to expose classes and methods to python", "coding_conventions.html#how_to_expose_classes_and_methods_to_python", null ],
    [ "Documentation", "coding_conventions.html#documentation", [
      [ "UML diagrams", "coding_conventions.html#uml_diagrams", null ],
      [ "Doxygen", "coding_conventions.html#doxygen", null ],
      [ "Add comments to code", "coding_conventions.html#add_comments_to_code", null ],
      [ "Examples", "coding_conventions.html#examples", null ]
    ] ],
    [ "Testing", "coding_conventions.html#testing", null ],
    [ "Revision control", "coding_conventions.html#revision_control", null ],
    [ "How To Write Tests", "how_to_write_tests.html", [
      [ "TOPP tests", "how_to_write_tests.html#topp_tests", null ],
      [ "Class or unit tests", "how_to_write_tests.html#class_or_unit_tests", [
        [ "Supplementary files", "how_to_write_tests.html#supplementary_files", null ],
        [ "Macros to start, finish and evaluate tests", "how_to_write_tests.html#macros_to_start_finish_and_evaluate_tests", null ],
        [ "Temporary files", "how_to_write_tests.html#temporary_files", null ],
        [ "Creating barebone tests", "how_to_write_tests.html#creating_barebone_tests", null ],
        [ "Building tests", "how_to_write_tests.html#building_tests", null ],
        [ "Running tests", "how_to_write_tests.html#running_tests", null ],
        [ "Numerical inaccuracy", "how_to_write_tests.html#numerical_inaccuracy", null ]
      ] ]
    ] ]
];