// --------------------------------------------------------------------------
//                   OpenMS -- Open-Source Mass Spectrometry
// --------------------------------------------------------------------------
// Copyright The OpenMS Team -- Eberhard Karls University Tuebingen,
// ETH Zurich, and Freie Universitaet Berlin 2002-2022.
//
// This software is released under a three-clause BSD license:
//  * Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  * Neither the name of any author or any participating institution
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
// For a full list of authors, refer to the file AUTHORS.
// --------------------------------------------------------------------------
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL ANY OF THE AUTHORS OR THE CONTRIBUTING
// INSTITUTIONS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
// OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
// WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
// OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
// ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// --------------------------------------------------------------------------
// $Maintainer: Hendrik Weisser $
// $Authors: Hendrik Weisser $
// --------------------------------------------------------------------------

#include <OpenMS/FORMAT/OMSFile.h>
#include <OpenMS/FORMAT/OMSFileLoad.h>
#include <OpenMS/FORMAT/OMSFileStore.h>
#include <QCoreApplication>

using namespace std;

using ID = OpenMS::IdentificationData;

namespace OpenMS
{
  void OMSFile::store(const String& filename, const IdentificationData& id_data)
  {
    OpenMS::Internal::OMSFileStore helper(filename, log_type_);
    helper.store(id_data);
  }

  void OMSFile::store(const String& filename, const FeatureMap& features)
  {
    OpenMS::Internal::OMSFileStore helper(filename, log_type_);
    helper.store(features);
  }

  void OMSFile::load(const String& filename, IdentificationData& id_data)
  {
    /*if (!QCoreApplication::instance())
    {
      char argv[1] = "";
      int argc = 0;
      QCoreApplication a(argc, reinterpret_cast<char**>(&argv));
      std::cout << QCoreApplication::libraryPaths().join(" ").toStdString() << std::endl;
    }*/
    OpenMS::Internal::OMSFileLoad helper(filename, log_type_);
    helper.load(id_data);
  }

  void OMSFile::load(const String& filename, FeatureMap& features)
  {
    OpenMS::Internal::OMSFileLoad helper(filename, log_type_);
    helper.load(features);
  }
}
