from MetaInfoInterface cimport *
from IonSource cimport *
from ScanWindow cimport *

cdef extern from "<OpenMS/METADATA/InstrumentSettings.h>" namespace "OpenMS":

    cdef cppclass InstrumentSettings(MetaInfoInterface):
        # wrap-inherits:
        #   MetaInfoInterface

        InstrumentSettings() except + nogil  # wrap-doc:Description of the settings a MS Instrument was run with
        InstrumentSettings(InstrumentSettings &) except + nogil 

        Polarity getPolarity()     except + nogil  # wrap-doc:Returns the polarity
        void setPolarity(Polarity)  except + nogil  # wrap-doc:Sets the polarity

        ScanMode getScanMode() except + nogil  # wrap-doc:Returns the scan mode
        void setScanMode(ScanMode scan_mode) except + nogil  # wrap-doc:Sets the scan mode
        bool getZoomScan() except + nogil  # wrap-doc:Returns if this scan is a zoom (enhanced resolution) scan
        void setZoomScan(bool zoom_scan) except + nogil  # wrap-doc:Sets if this scan is a zoom (enhanced resolution) scan
        libcpp_vector[ ScanWindow ]  getScanWindows() except + nogil  # wrap-doc:Returns the m/z scan windows
        void setScanWindows(libcpp_vector[ ScanWindow ] scan_windows) except + nogil  # wrap-doc:Sets the m/z scan windows

        @staticmethod
        libcpp_vector[String] getAllNamesOfScanMode() except + nogil  # wrap-doc:Returns all scan mode names known to OpenMS

cdef extern from "<OpenMS/METADATA/InstrumentSettings.h>" namespace "OpenMS::InstrumentSettings":

    # scan mode
    cdef enum ScanMode:
      # wrap-attach:
      #    InstrumentSettings
      UNKNOWN,                #< Unknown scan method
      MASSSPECTRUM,           #< general spectrum type
      MS1SPECTRUM,            #< full scan mass spectrum, is a "mass spectrum" @n Synonyms: 'full spectrum', 'Q1 spectrum', 'Q3 spectrum', 'Single-Stage Mass Spectrometry'
      MSNSPECTRUM,            #< MS2+ mass spectrum, is a "mass spectrum"
      SIM,                    #< Selected ion monitoring scan @n Synonyms: 'Multiple ion monitoring scan', 'SIM scan', 'MIM scan'
      SRM,                    #< Selected reaction monitoring scan @n Synonyms: 'Multiple reaction monitoring scan', 'SRM scan', 'MRM scan'
      CRM,                    #< Consecutive reaction monitoring scan @n Synonyms: 'CRM scan'
      CNG,                    #< Constant neutral gain scan @n Synonyms: 'CNG scan'
      CNL,                    #< Constant neutral loss scan @n Synonyms: 'CNG scan'
      PRECURSOR,              #< Precursor ion scan
      EMC,                    #< Enhanced multiply charged scan
      TDF,                    #< Time-delayed fragmentation scan
      EMR,                    #< Electromagnetic radiation scan @n Synonyms: 'EMR spectrum'
      EMISSION,               #< Emission scan
      ABSORPTION,             #< Absorption scan
      SIZE_OF_SCANMODE
