### the directory name
set(directory source/APPLICATIONS/TOPP)

### list all filenames of the directory here
set(TOPP_executables
AccurateMassSearch
AssayGeneratorMetabo
AssayGeneratorMetaboSirius
BaselineFilter
FeatureFinderLFQ
ClusterMassTraces
ClusterMassTracesByPrecursor
CometAdapter
ConsensusID
ConsensusMapNormalizer
CVInspector
DatabaseFilter
DatabaseSuitability
DecoyDatabase
Decharger
DeMeanderize
Digestor
DigestorMotif
DTAExtractor
EICExtractor
Epifany
ExternalCalibration
FalseDiscoveryRate
FeatureFinderCentroided
FeatureFinderIdentification
FeatureFinderMetabo
FeatureFinderMetaboIdent
FeatureFinderMultiplex
FeatureLinkerLabeled
FeatureLinkerUnlabeled
FeatureLinkerUnlabeledKD
FeatureLinkerUnlabeledQT
FileConverter
FileFilter
FileInfo
FileMerger
FLASHDeconv
FuzzyDiff
GenericWrapper
GNPSExport
HighResPrecursorMassCorrector
IDConflictResolver
IDDecoyProbability
IDExtractor
IDFileConverter
IDFilter
IDMapper
IDMerger
IDPosteriorErrorProbability
IDRipper
IDRTCalibration
IDScoreSwitcher
IDSplitter
InternalCalibration
IonMobilityBinning
IsobaricAnalyzer
IsobaricWorkflow
JSONExporter
LuciphorAdapter
MapAlignerIdentification
MapAlignerPoseClustering
MapAlignerTreeGuided
MapNormalizer
MapRTTransformer
MapStatistics
MaRaClusterAdapter
MascotAdapterOnline
MassCalculator
MassTraceExtractor
MetaboliteAdductDecharger
MetaboliteSpectralMatcher
MetaProSIP
MRMMapper
MRMPairFinder
MSGFPlusAdapter
MSFraggerAdapter
MSstatsConverter
MultiplexResolver
MzMLSplitter
MzTabExporter
NoiseFilterGaussian
NoiseFilterSGolay
NovorAdapter
NucleicAcidSearchEngine
OpenMSDatabasesInfo
OpenMSInfo
OpenNuXL
OpenPepXL
OpenSwathAnalyzer
OpenSwathAssayGenerator
OpenSwathChromatogramExtractor
OpenSwathConfidenceScoring
OpenSwathDecoyGenerator
OpenSwathFeatureXMLToTSV
OpenSwathRTNormalizer
PeakPickerHiRes
PeakPickerIterative
PeakPickerIM
PeptideIndexer
PeptideDataBaseSearchFI
PercolatorAdapter
PhosphoScoring
ProteinInference
ProteinQuantifier
ProteomicsLFQ
PSMFeatureExtractor
QCCalculator
QCEmbedder
QCExporter
QCExtractor
QCImporter
QCMerger
QCShrinker
QualityControl
RNADigestor
RNAMassCalculator
RNPxlXICFilter
SageAdapter
SeedListGenerator
SemanticValidator
SequenceCoverageCalculator
SimpleSearchEngine
SiriusExport
SpectraFilterNLargest
SpectraFilterNormalizer
SpectraFilterThresholdMower
SpectraFilterWindowMower
SpectraMerger
SpectraSTSearchAdapter
StaticModification
TICCalculator
TextExporter
TriqlerConverter
XFDR
XMLValidator
)

if(NOT DISABLE_OPENSWATH)
  set(TOPP_executables
    ${TOPP_executables}
    TargetedFileConverter
    OpenSwathDIAPreScoring
    OpenSwathMzMLFileCacher
    OpenSwathWorkflow
    OpenSwathFileSplitter
    OpenSwathRewriteToFeatureXML
    MRMTransitionGroupPicker
  )
endif(NOT DISABLE_OPENSWATH)

if(WITH_PARQUET)
  set(TOPP_executables
    ${TOPP_executables}
    QuantmsIOConverter
  )
endif(WITH_PARQUET)

## all targets requiring OpenMS_GUI
set(TOPP_executables_with_GUIlib
ExecutePipeline
Resampler
# util category
ImageCreator
INIUpdater
)

### add filenames to Visual Studio solution tree
set(sources_VS)
foreach(i ${TOPP_executables} ${TOPP_executables_with_GUIlib})
	list(APPEND sources_VS "${i}.cpp")
endforeach(i)

source_group("" FILES ${sources_VS})
