<?php
# Copyright (c) 2002-present, OpenMS Inc. -- EKU Tuebingen, ETH Zurich, and FU Berlin
# SPDX-License-Identifier: BSD-3-Clause
# 
# --------------------------------------------------------------------------
# $Maintainer: $
# $Authors: Marc Sturm $
# --------------------------------------------------------------------------
error_reporting(E_ERROR| E_WARNING| E_PARSE| E_NOTICE);
date_default_timezone_set('UTC');

include "common_functions.php";

########################usage###############################
if(!($argc == 3 || $argc == 4))
{
  print "Usage: create_test.php <Absolute path to OpenMS build dir> <Absolute path to header> [Author]\n";
  "  <header_file> -- the header of the class to create the test from.\n";
  "  [Author]      -- the author argument is optional, the name will be added to the Maintainer/Author section.\n";
  exit;
}

$path         = $argv[1];
$file         = $argv[2];
$class        = substr(basename($file), 0,-2);
$pathToHeader = substr($file, strpos($file, "include/OpenMS")+8);

$user = "";

if($argc == 4)
{
  // we got a user name
  $user = trim($argv[3], "\"");
}

#load file info
$class_info = getClassInfo($path, $file, 0);

?>
// Copyright (c) 2002-<?php print date("Y");?>, OpenMS Inc. -- EKU Tuebingen, ETH Zurich, and FU Berlin
// SPDX-License-Identifier: BSD-3-Clause
// 
// --------------------------------------------------------------------------
// $Maintainer: <?php print $user;?>$
// $Authors: <?php print $user;?>$
// --------------------------------------------------------------------------

#include <OpenMS/CONCEPT/ClassTest.h>

///////////////////////////
#include <<?php print $pathToHeader;?>>
///////////////////////////

using namespace OpenMS;
using namespace std;

START_TEST(<?php print $class;?>, "$Id$")

/////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////

<?php print $class;?>* ptr = 0;
<?php print $class;?>* null_ptr = 0;
START_SECTION(<?php print $class;?>())
{
	ptr = new <?php print $class;?>();
	TEST_NOT_EQUAL(ptr, null_ptr)
}
END_SECTION

START_SECTION(~<?php print $class;?>())
{
	delete ptr;
}
END_SECTION

<?php
foreach($class_info["test-name"] as $c)
{
  if(trim($c) != $class_info["classname"]."()")
  {
    print "START_SECTION(($c))\n";
    print "{\n";
    print "  // TODO\n";
    print "}\n";
    print "END_SECTION\n";
    print "\n";
  }
}
?>

/////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////
END_TEST



