// Copyright (c) 2002-present, OpenMS Inc. -- EKU Tuebingen, ETH Zurich, and FU Berlin
// SPDX-License-Identifier: BSD-3-Clause
//
// --------------------------------------------------------------------------
// $Maintainer: Chris Bielow $
// $Authors: Chris Bielow $
// --------------------------------------------------------------------------

#pragma once

#include <OpenMS/QC/QCBase.h>

namespace OpenMS
{
  class FeatureMap;

  /**
    @brief QC metric calculating (un)calibrated m/z error

    The metric sets m/z-values of the original experiment and the calculated reference m/z-values, uncalibrated m/z error (ppm)
    and calibrated m/z error (ppm) as metavalues of all PeptideIdentifications in a FeatureMap.

    For full functionality a PeakMap/MSExperiment with original m/z-values before m/z calibration generated by InternalCalibration has to be given.
    It's also possible to use this without an MzML File, but then only uncalibrated m/z error (ppm) will be reported.
    A FeatureMap after FDR is always required.

    **/
  class OPENMS_DLLAPI FWHM : public QCBase
  {
  public:
    /// Constructor
    FWHM() = default;

    /// Destructor
    virtual ~FWHM() = default;

    /**
      @brief Moves FWHM metavalues from the feature to all its PeptideIdentifications (since that's were mzTab takes it from if we want to preserve Raw file origin)

      A warning is issued on the commandline if a feature does not have either 'FWHM' or 'model_FWHM' as metavalue.

      @param features FeatureMap with features which have metavalue 'FWHM' or 'model_FWHM'
    **/
    void compute(FeatureMap& features);


    const String& getName() const override;

    Status requirements() const override;
  };

} // namespace OpenMS
