/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.fdr;

import edu.ucsd.msjava.fdr.PSMSet;
import edu.ucsd.msjava.fdr.ScoredString;
import edu.ucsd.msjava.msdbsearch.CompactSuffixArray;
import edu.ucsd.msjava.msdbsearch.DatabaseMatch;
import edu.ucsd.msjava.msdbsearch.MSGFPlusMatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class MSGFPlusPSMSet
extends PSMSet {
    private final List<MSGFPlusMatch> msgfPlusPSMList;
    private final boolean isDecoy;
    private final CompactSuffixArray sa;
    private final String decoyProteinPrefix;
    private boolean considerBestMatchOnly = false;

    public MSGFPlusPSMSet(List<MSGFPlusMatch> msgfPlusPSMList, boolean isDecoy, CompactSuffixArray sa, String decoyProteinPrefix) {
        this.msgfPlusPSMList = msgfPlusPSMList;
        this.isDecoy = isDecoy;
        this.sa = sa;
        this.decoyProteinPrefix = decoyProteinPrefix == null || decoyProteinPrefix.trim().isEmpty() ? "XXX" : decoyProteinPrefix;
    }

    public MSGFPlusPSMSet setConsiderBestMatchOnly(boolean considerBestMatchOnly) {
        this.considerBestMatchOnly = considerBestMatchOnly;
        return this;
    }

    @Override
    public boolean isGreaterBetter() {
        return false;
    }

    @Override
    public void read() {
        this.psmList = new ArrayList();
        this.peptideScoreTable = new HashMap();
        for (MSGFPlusMatch match : this.msgfPlusPSMList) {
            List<DatabaseMatch> dbMatchList;
            if (this.considerBestMatchOnly) {
                dbMatchList = new ArrayList<DatabaseMatch>();
                dbMatchList.add(match.getBestDBMatch());
            } else {
                dbMatchList = match.getMatchList();
            }
            for (DatabaseMatch m : dbMatchList) {
                String pepSeq = m.getPepSeq();
                boolean isDecoy = true;
                Iterator iterator = m.getIndices().iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    String protAcc = this.sa.getSequence().getAnnotation(index);
                    if (protAcc.startsWith(this.decoyProteinPrefix)) continue;
                    isDecoy = false;
                    break;
                }
                if (this.isDecoy != isDecoy) continue;
                float specEValue = (float)m.getSpecEValue();
                this.psmList.add(new ScoredString(pepSeq, Float.valueOf(specEValue)));
                Float prevSpecEValue = (Float)this.peptideScoreTable.get(pepSeq);
                if (prevSpecEValue != null && !(specEValue < prevSpecEValue.floatValue())) continue;
                this.peptideScoreTable.put(pepSeq, Float.valueOf(specEValue));
            }
        }
    }
}

