/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.misc;

import edu.ucsd.msjava.msgf.Histogram;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Composition;
import edu.ucsd.msjava.msutil.CompositionFactory;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.msutil.SpectraIterator;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.parser.BufferedLineReader;
import edu.ucsd.msjava.parser.MgfSpectrumParser;
import edu.ucsd.msjava.parser.MzXMLSpectraMap;
import edu.ucsd.msjava.parser.SpectrumParser;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;

public class HCDCIDETD {
    private static AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSet();

    public static void main(String[] argv) throws Exception {
    }

    public static void approxCompGraphTest() throws Exception {
        int maxLength = 30;
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        CompositionFactory allCompositions = new CompositionFactory(aaSet, null, maxLength);
        HashSet<ExtComposition> approxCompSet = new HashSet<ExtComposition>();
        System.out.println("Composition building done.");
        float maxErr = 0.0f;
        Composition worstComp = Composition.NIL;
        for (int n : allCompositions.getData()) {
            Composition c = new Composition(n);
            int numC = c.getC();
            int numH = c.getH();
            int numN = c.getN();
            int numO = c.getO();
            int numS = c.getS();
            ExtComposition newComp = new ExtComposition(numC, numH, numN, numO, numS);
            approxCompSet.add(newComp);
            float err = newComp.getMass() - c.getMass();
            if (!(Math.abs(err) > maxErr)) continue;
            maxErr = Math.abs(err);
            worstComp = c;
        }
        System.out.println("MaxErr\t" + worstComp.toString() + "\t" + worstComp.getMass() + "\t" + maxErr);
        System.out.println("CompositionSize\t" + allCompositions.size());
        System.out.println("Size\t" + approxCompSet.size());
    }

    public static void findGoodAAConst() throws Exception {
        int i;
        double target = 31.9720707;
        double base = Math.abs(target - 1.007825035 * (double)Math.round(target / 1.007825035));
        ArrayList<Integer> bestI = new ArrayList<Integer>();
        ArrayList<Integer> bestJ = new ArrayList<Integer>();
        ArrayList<Double> diffList = new ArrayList<Double>();
        for (i = 1; i < 100; ++i) {
            for (int j = 1; j < 1000; ++j) {
                double diff = Math.abs(target * (double)i - 1.007825035 * (double)j);
                if (!(diff < base)) continue;
                bestI.add(i);
                bestJ.add(j);
                diffList.add(target * (double)i - 1.007825035 * (double)j);
            }
        }
        System.out.println("Base: " + base);
        for (i = 0; i < bestI.size(); ++i) {
            System.out.println(bestI.get(i) + "\t" + bestJ.get(i) + "\t" + diffList.get(i));
        }
    }

    public static void analyzeMSGFResults(boolean target) throws Exception {
        String s;
        String fileName = "/home/sangtaekim/Developments/MS_Java/bin/PNNLCompGraph.txt";
        BufferedLineReader in = new BufferedLineReader(fileName);
        in.readLine();
        while ((s = in.readLine()) != null) {
            String annotation;
            String pepStr;
            String[] token = s.split("\t");
            if (token.length != 20 || (pepStr = (annotation = token[10]).substring(annotation.indexOf(46) + 1, annotation.lastIndexOf(46))).length() > 20) continue;
            String prot = token[8];
            if (target && prot.startsWith("Reversed") || !target && !prot.startsWith("Reversed") || token[19].startsWith("Parent")) continue;
            float specProb = Float.parseFloat(token[19]);
            float xcorr = Float.parseFloat(token[5]);
            System.out.println(specProb + "\t" + xcorr);
        }
    }

    public static void analyzeFragmentErrors() throws Exception {
        String[] methods;
        for (String method : methods = new String[]{"CID", "ETD", "HCD"}) {
            HCDCIDETD.analyzeFragmentErrors(method);
        }
    }

    public static void analyzeFragmentErrors(String method) throws Exception {
        File dir = new File(System.getProperty("user.home") + "/Research/Data/CIDETDHCD");
        File specFile = new File(dir.getPath() + File.separator + "AnnotatedSpectra/Annotated_" + method + ".mgf");
        double prefixMass = Composition.ChargeCarrierMass();
        double suffixMass = 18.0105647;
        SpectraIterator itr = new SpectraIterator(specFile.getPath(), (SpectrumParser)new MgfSpectrumParser().aaSet(aaSet));
        while (itr.hasNext()) {
            Spectrum spec = itr.next();
            Peptide pep = spec.getAnnotation();
            for (int i = 0; i < pep.size() - 1; ++i) {
                prefixMass += pep.get(i).getAccurateMass();
                suffixMass += pep.get(pep.size() - 1 - i).getAccurateMass();
            }
        }
    }

    public static void generateAnnotatedSpectra() throws Exception {
        String[] methods;
        for (String method : methods = new String[]{"CID", "ETD", "HCD"}) {
            HCDCIDETD.generateAnnotatedSpectra(method);
        }
    }

    public static void generateAnnotatedSpectra(String method) throws Exception {
        String s;
        File dir = new File(System.getProperty("user.home") + "/Research/Data/CIDETDHCD");
        File resultFile = new File(dir.getPath() + File.separator + "AnalysisResults/" + method + "_FDR1pct.txt");
        File specFile = new File(dir.getPath() + File.separator + "HCD_CID_ETD_EBCP_LMW_1y_50ug_300rt.mzXML");
        File outputFile = new File(dir.getPath() + File.separator + "AnnotatedSpectra/Annotated_" + method + ".mgf");
        MzXMLSpectraMap map = new MzXMLSpectraMap(specFile.getPath());
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
        Histogram<Integer> pmErrorHist = new Histogram<Integer>();
        BufferedLineReader in = new BufferedLineReader(resultFile.getPath());
        in.readLine();
        int numSpecs = 0;
        while ((s = in.readLine()) != null) {
            String db;
            String[] token = s.split("\t");
            if (token.length != 25 || (db = token[9]).startsWith("Reverse")) continue;
            int scanNum = Integer.parseInt(token[2]);
            Spectrum spec = map.getSpectrumBySpecIndex(scanNum);
            int charge = Integer.parseInt(token[4]);
            spec.setCharge(charge);
            float expMass = spec.getPrecursorMass();
            String annotation = token[11];
            Peptide pep = aaSet.getPeptide(annotation.substring(annotation.indexOf(46) + 1, annotation.lastIndexOf(46)));
            float theoMass = pep.getParentMass();
            float parentMassError = expMass - theoMass;
            float parentMassErrorPPM = parentMassError * 1000000.0f / theoMass;
            if (parentMassErrorPPM > 50.0f || parentMassErrorPPM < -50.0f) {
                System.out.println(annotation + " " + expMass + " " + theoMass + " " + parentMassErrorPPM);
            } else if (parentMassErrorPPM < 20.0f && parentMassErrorPPM > -20.0f) {
                spec.setAnnotation(pep);
                spec.outputMgf(out);
                ++numSpecs;
            }
            pmErrorHist.add(Math.round(parentMassErrorPPM));
        }
        out.close();
        System.out.println("Done: " + numSpecs + " spectra.");
        pmErrorHist.printSorted();
    }

    public static void printParentMassErrorDist(String method) throws Exception {
        String s;
        File dir = new File(System.getProperty("user.home") + "/Research/Data/CIDETDHCD");
        File resultFile = new File(dir.getPath() + File.separator + "AnalysisResults/" + method + "_FDR1pct.txt");
        File specFile = new File(dir.getPath() + File.separator + "HCD_CID_ETD_EBCP_LMW_1y_50ug_300rt.mzXML");
        File outputFile = new File(dir.getPath() + File.separator + "AnnotatedSpectra/Annotated_" + method + ".mgf");
        MzXMLSpectraMap map = new MzXMLSpectraMap(specFile.getPath());
        Histogram<Integer> pmErrorHistPPM = new Histogram<Integer>();
        Histogram<Integer> pmErrorHistDa = new Histogram<Integer>();
        BufferedLineReader in = new BufferedLineReader(resultFile.getPath());
        in.readLine();
        int numSpecs = 0;
        while ((s = in.readLine()) != null) {
            String db;
            String[] token = s.split("\t");
            if (token.length != 25 || (db = token[9]).startsWith("Reverse")) continue;
            int scanNum = Integer.parseInt(token[2]);
            Spectrum spec = map.getSpectrumBySpecIndex(scanNum);
            int charge = Integer.parseInt(token[4]);
            spec.setCharge(charge);
            float expMass = spec.getPrecursorMass();
            String annotation = token[11];
            Peptide pep = aaSet.getPeptide(annotation.substring(annotation.indexOf(46) + 1, annotation.lastIndexOf(46)));
            float theoMass = pep.getParentMass();
            float parentMassError = expMass - theoMass;
            float parentMassErrorPPM = parentMassError * 1000000.0f / theoMass;
            if (parentMassErrorPPM > 50.0f || parentMassErrorPPM < -50.0f) {
                System.out.println(annotation + " " + expMass + " " + theoMass + " " + parentMassErrorPPM);
            }
            ++numSpecs;
            pmErrorHistPPM.add(Math.round(parentMassErrorPPM));
            pmErrorHistDa.add(Math.round(parentMassError * 1000.0f));
        }
        System.out.println("PPM");
        pmErrorHistPPM.printSorted();
        System.out.println("\tDa");
        pmErrorHistDa.printSorted();
    }

    static class ExtComposition {
        int number;

        public ExtComposition(int c, int h, int n, int o, int s) {
            int newC = c % 43;
            int newH = h + c / 43 * 512 + n / 19 * 264 + o / 31 * 492 + s / 7 * 222;
            int newN = n % 19;
            int newO = o % 31;
            int newS = s % 7;
            this.number = newC * 0x4000000 + newH * 8192 + newN * 256 + newO * 8 + newS;
        }

        public int getC() {
            return (this.number & 0xFC000000) >>> 26;
        }

        public int getH() {
            return (this.number & 0x3FFE000) >> 13;
        }

        public int getN() {
            return (this.number & 0x1F00) >> 8;
        }

        public int getO() {
            return (this.number & 0xF8) >> 3;
        }

        public int getS() {
            return this.number & 7;
        }

        public int getNumber() {
            return this.number;
        }

        public int hashCode() {
            return this.number;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ExtComposition) {
                ExtComposition other = (ExtComposition)obj;
                if (this.number == other.number) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return new String(this.getC() + " " + this.getH() + " " + this.getN() + " " + this.getO() + " " + this.getS());
        }

        public float getMass() {
            return (float)((double)this.getC() * 12.0 + (double)this.getH() * 1.007825035 + (double)this.getN() * 14.003074 + (double)this.getO() * 15.99491463 + (double)this.getS() * 31.9720707);
        }
    }
}

