/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.misc;

import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.parser.BufferedLineReader;
import edu.ucsd.msjava.parser.MzXMLSpectraMap;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Hashtable;

public class HeckPercolator {
    private static Hashtable<String, Float[]> mascotThresholds;
    private static Hashtable<String, Float[]> percolatorThresholds;
    private static Hashtable<String, Float[]> msgfThresholds;

    public static void main(String[] argv) throws Exception {
        HeckPercolator.makeAnnotatedSpectraWithMascot();
    }

    public static void makeAnnotatedSpectraWithMascot() throws Exception {
        File specDir = new File("/home/sangtaekim/Research/Data/HeckWhole/Spectra");
        HashMap<String, MzXMLSpectraMap> specMap = new HashMap<String, MzXMLSpectraMap>();
        for (File f : specDir.listFiles()) {
            String fileName = f.getName();
            if (!fileName.endsWith(".mzXML")) continue;
            String name = fileName.substring(0, fileName.lastIndexOf(46)).toLowerCase();
            specMap.put(name, new MzXMLSpectraMap(f.getPath()));
        }
        File mascotDir = new File("/home/sangtaekim/Research/Data/HeckRevision/Mascot23");
        File annotatedSpecDir = new File("/home/sangtaekim/Research/Data/HeckRevision/AnnotatedSpectra");
        for (File f : mascotDir.listFiles()) {
            String s;
            String fileName = f.getName();
            if (!fileName.endsWith("Target.txt")) continue;
            String method = fileName.substring(0, 7);
            String outputFileName = annotatedSpecDir.getPath() + File.separator + "MascotAnnotated_" + method + ".mgf";
            PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(outputFileName)));
            System.out.print(fileName + ": ");
            HashMap<String, Spectrum> pepSpecMap = new HashMap<String, Spectrum>();
            HashMap<String, Float> pepScoreMap = new HashMap<String, Float>();
            BufferedLineReader in = new BufferedLineReader(f.getPath());
            String prevTitle = "";
            while ((s = in.readLine()) != null) {
                float threshold;
                String[] token;
                if (s.startsWith("#") || (token = s.split("\t")).length < 4 || prevTitle.equalsIgnoreCase(token[0])) continue;
                prevTitle = token[0];
                float score = Float.parseFloat(token[3]);
                int chargeIndex = Integer.parseInt(token[1]) - 2;
                if (chargeIndex > 2) {
                    chargeIndex = 2;
                }
                if (!(score > (threshold = mascotThresholds.get(method)[chargeIndex].floatValue()))) continue;
                String annotation = token[2];
                String peptide = annotation.substring(annotation.indexOf(46) + 1, annotation.lastIndexOf(46));
                if (pepSpecMap.get(peptide + ":" + chargeIndex) != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (!(((Float)pepScoreMap.get(stringBuilder.append(peptide).append(":").append(chargeIndex).toString())).floatValue() < score)) continue;
                }
                String specFileID = token[0].substring(token[0].indexOf("090"), token[0].lastIndexOf(95));
                String[] titleToken = token[0].split("\\s+");
                int scanNum = Integer.parseInt(titleToken[titleToken.length - 1]);
                Spectrum spec = ((MzXMLSpectraMap)specMap.get(specFileID.toLowerCase())).getSpectrumBySpecIndex(scanNum);
                Peptide pep = new Peptide(peptide);
                spec.setAnnotation(pep);
                assert (spec != null);
                assert (Math.abs(spec.getPrecursorMass() - pep.getParentMass()) < 5.0f) : s + " " + spec.getPrecursorMass() + " " + pep.getParentMass();
                pepSpecMap.put(peptide + ":" + chargeIndex, spec);
                pepScoreMap.put(peptide + ":" + chargeIndex, Float.valueOf(score));
            }
            int numSpecs = 0;
            for (Spectrum spec : pepSpecMap.values()) {
                spec.outputMgf(out);
                ++numSpecs;
            }
            in.close();
            out.close();
            System.out.println(numSpecs);
        }
    }

    static {
        Float[] mascotThresholdCIDTryp = new Float[]{Float.valueOf(37.08f), Float.valueOf(23.35f), Float.valueOf(24.18f)};
        Float[] mascotThresholdETDTryp = new Float[]{Float.valueOf(46.79f), Float.valueOf(74.49f), Float.valueOf(44.2f)};
        Float[] mascotThresholdCIDLysN = new Float[]{Float.valueOf(33.53f), Float.valueOf(22.31f), Float.valueOf(23.01f)};
        Float[] mascotThresholdETDLysN = new Float[]{Float.valueOf(35.8f), Float.valueOf(30.48f), Float.valueOf(21.07f)};
        mascotThresholds = new Hashtable();
        mascotThresholds.put("CIDTryp", mascotThresholdCIDTryp);
        mascotThresholds.put("ETDTryp", mascotThresholdETDTryp);
        mascotThresholds.put("CIDLysN", mascotThresholdCIDLysN);
        mascotThresholds.put("ETDLysN", mascotThresholdETDLysN);
        Float[] percolatorThresholdCIDTryp = new Float[]{Float.valueOf(0.0239881f), Float.valueOf(0.0467094f), Float.valueOf(0.0178952f)};
        Float[] percolatorThresholdETDTryp = new Float[]{Float.valueOf(0.0147269f), Float.valueOf(0.050837f), Float.valueOf(0.0568241f)};
        Float[] percolatorThresholdCIDLysN = new Float[]{Float.valueOf(0.0295369f), Float.valueOf(0.0437894f), Float.valueOf(0.0125539f)};
        Float[] percolatorThresholdETDLysN = new Float[]{Float.valueOf(0.0207123f), Float.valueOf(0.0456574f), Float.valueOf(0.0456574f)};
        percolatorThresholds = new Hashtable();
        percolatorThresholds.put("CIDTryp", percolatorThresholdCIDTryp);
        percolatorThresholds.put("ETDTryp", percolatorThresholdETDTryp);
        percolatorThresholds.put("CIDLysN", percolatorThresholdCIDLysN);
        percolatorThresholds.put("ETDLysN", percolatorThresholdETDLysN);
        Float[] thresholdCIDTryp = new Float[]{Float.valueOf(4.9982934E-11f), Float.valueOf(2.5958782E-11f), Float.valueOf(1.0835081E-11f)};
        Float[] thresholdETDTryp = new Float[]{Float.valueOf(2.3154301E-11f), Float.valueOf(7.760064E-13f), Float.valueOf(2.299933E-13f)};
        Float[] thresholdSumTryp = new Float[]{Float.valueOf(5.6320247E-11f), Float.valueOf(2.3743533E-11f), Float.valueOf(1.8667672E-11f)};
        Float[] thresholdCIDLysN = new Float[]{Float.valueOf(3.2987557E-11f), Float.valueOf(1.5884185E-11f), Float.valueOf(1.615089E-12f)};
        Float[] thresholdETDLysN = new Float[]{Float.valueOf(2.2711777E-11f), Float.valueOf(2.1367989E-11f), Float.valueOf(9.767584E-12f)};
        Float[] thresholdSumLysN = new Float[]{Float.valueOf(2.4446337E-11f), Float.valueOf(2.8512514E-11f), Float.valueOf(9.074788E-12f)};
        msgfThresholds = new Hashtable();
        msgfThresholds.put("CIDTryp", thresholdCIDTryp);
        msgfThresholds.put("ETDTryp", thresholdETDTryp);
        msgfThresholds.put("SumTryp", thresholdSumTryp);
        msgfThresholds.put("CIDLysN", thresholdCIDLysN);
        msgfThresholds.put("ETDLysN", thresholdETDLysN);
        msgfThresholds.put("SumLysN", thresholdSumLysN);
    }
}

