/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.misc;

import edu.ucsd.msjava.msdbsearch.CompactFastaSequence;
import edu.ucsd.msjava.msdbsearch.CompactSuffixArray;
import edu.ucsd.msjava.msscorer.NewRankScorer;
import edu.ucsd.msjava.msscorer.NewScorerFactory;
import edu.ucsd.msjava.msscorer.ScoringParameterGeneratorWithErrors;
import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Enzyme;
import edu.ucsd.msjava.msutil.InstrumentType;
import edu.ucsd.msjava.msutil.Protocol;
import edu.ucsd.msjava.parser.BufferedLineReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class MSGFPlusPaper {
    public static void main(String[] argv) throws Exception {
        MSGFPlusPaper.countTotalNumberOfPartitions();
    }

    public static void vennDiagram() throws Exception {
        int id;
        String s;
        String dataset = "HCD_FT";
        File msgfdbFile = new File("/home/sangtaekim/Research/Data/Heck_DDDT/backup1229/" + dataset + "_7ppm.tsv");
        File mascotDATFile = new File("/home/sangtaekim/Research/Data/Heck_DDDT/Mascot/Mascot_" + dataset + ".dat");
        File percolatorFile = new File("/home/sangtaekim/Research/Data/Heck_DDDT/Mascot/Percolator_" + dataset + ".tsv");
        HashSet<Integer> msgfdbID = new HashSet<Integer>();
        BufferedLineReader in = new BufferedLineReader(msgfdbFile.getPath());
        int scanNumIndex = 2;
        int fdrIndex = 13;
        while ((s = in.readLine()) != null) {
            float fdr;
            String[] token;
            if (s.startsWith("#") || (token = s.split("\t")).length < fdrIndex || !((fdr = Float.parseFloat(token[fdrIndex])) <= 0.01f)) continue;
            msgfdbID.add(Integer.parseInt(token[scanNumIndex]));
        }
        in.close();
        HashMap<Integer, Integer> queryNumToScanNum = new HashMap<Integer, Integer>();
        in = new BufferedLineReader(mascotDATFile.getPath());
        String keyWord = "Content-Type: application/x-Mascot; name=\"query";
        while ((s = in.readLine()) != null) {
            if (!s.startsWith(keyWord)) continue;
            int queryNum = Integer.parseInt(s.substring(keyWord.length(), s.lastIndexOf(34)));
            in.readLine();
            in.readLine();
            s = in.readLine();
            assert (s.startsWith("scans="));
            int scanNum = Integer.parseInt(s.substring(s.lastIndexOf(61) + 1));
            queryNumToScanNum.put(queryNum, scanNum);
        }
        in.close();
        HashSet<Integer> percolatorID = new HashSet<Integer>();
        in = new BufferedLineReader(percolatorFile.getPath());
        int qValueIndex = 2;
        in.readLine();
        while ((s = in.readLine()) != null) {
            float qValue;
            String[] token = s.split("\t");
            if (token.length < 5 || !((qValue = Float.parseFloat(token[qValueIndex])) <= 0.01f)) continue;
            int queryNum = Integer.parseInt(token[0].substring(token[0].indexOf(58) + 1, token[0].indexOf(59)));
            int scanNum = (Integer)queryNumToScanNum.get(queryNum);
            percolatorID.add(scanNum);
        }
        int msgfdbOnly = 0;
        int percolatorOnly = 0;
        int both = 0;
        Iterator iterator = msgfdbID.iterator();
        while (iterator.hasNext()) {
            id = (Integer)iterator.next();
            if (percolatorID.contains(id)) {
                ++both;
                continue;
            }
            ++msgfdbOnly;
        }
        iterator = percolatorID.iterator();
        while (iterator.hasNext()) {
            id = (Integer)iterator.next();
            if (msgfdbID.contains(id)) continue;
            ++percolatorOnly;
        }
        System.out.println("MS-GFDB all: " + msgfdbID.size());
        System.out.println("Percolator all: " + percolatorID.size());
        System.out.println("Both: " + both);
        System.out.println("MS-GFDB only: " + msgfdbOnly);
        System.out.println("Percolator only: " + percolatorOnly);
    }

    public static void modInLib() throws Exception {
        String s;
        String fileName = "/home/sangtaekim/Research/Data/NISTLib/yeast_2011_05_24_it.pepidx";
        BufferedLineReader in = new BufferedLineReader(fileName);
        HashSet<String> modNames = new HashSet<String>();
        while ((s = in.readLine()) != null) {
            if (s.startsWith("#") || s.length() == 0) continue;
            String[] token = s.split("\\s+");
            String pepStr = token[0];
            String pepInfoStr = token[1];
            String[] tokenInfo = pepInfoStr.split("\\|");
            int charge = Integer.parseInt(tokenInfo[0]);
            String modInfo = tokenInfo[1];
            String[] tokenMod = modInfo.split("/");
            int numMods = Integer.parseInt(tokenMod[0]);
            for (int i = 1; i < tokenMod.length; ++i) {
                String[] mod = tokenMod[i].split(",");
                int location = Integer.parseInt(mod[0]);
                char residue = mod[1].charAt(0);
                String modName = mod[2];
                modNames.add(modName + ":" + residue + ":" + location);
            }
        }
        for (String m : modNames) {
            System.out.println(m);
        }
    }

    public static void aLPModel() throws Exception {
        File specFile = new File("/home/sangtaekim/Research/Data/IonStat/SpectraForTraining/ETD_LowRes_aLP.mgf");
        NewScorerFactory.SpecDataType dataType = new NewScorerFactory.SpecDataType(ActivationMethod.ETD, InstrumentType.LOW_RESOLUTION_LTQ, Enzyme.ALP, Protocol.AUTOMATIC);
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        File outputDir = new File("/home/sangtaekim/Developments/MS_Java_Dev/bin");
        ScoringParameterGeneratorWithErrors.generateParameters(specFile, dataType, aaSet, outputDir, true, true, true);
    }

    public static void countTotalNumberOfPartitions() throws Exception {
        int numPartitions = 0;
        for (ActivationMethod method : ActivationMethod.getAllRegisteredActivationMethods()) {
            if (method == ActivationMethod.FUSION || method == ActivationMethod.ASWRITTEN) continue;
            for (InstrumentType inst : InstrumentType.getAllRegisteredInstrumentTypes()) {
                for (Enzyme enzyme : Enzyme.getAllRegisteredEnzymes()) {
                    for (Protocol protocol : Protocol.getAllRegisteredProtocols()) {
                        NewScorerFactory.SpecDataType condition = new NewScorerFactory.SpecDataType(method, inst, enzyme, protocol);
                        InputStream is = ClassLoader.getSystemResourceAsStream("resources/ionstat/" + condition + ".param");
                        if (is == null) continue;
                        System.out.println(condition);
                        NewRankScorer scorer = new NewRankScorer(new BufferedInputStream(is));
                        numPartitions += scorer.getParitionSet().size();
                    }
                }
            }
        }
        System.out.println("NumPartitions: " + numPartitions);
    }

    public static void nominalMassTable() throws Exception {
        String delimiter = " & ";
        System.out.println("Residue" + delimiter + "NominalMass" + delimiter + "RealMass" + delimiter + "RescaledMass" + delimiter + "Error(RealMass)" + delimiter + "Error(RescaledMass)");
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        float sumReal = 0.0f;
        float sumRes = 0.0f;
        float sumPPM = 0.0f;
        float absSumReal = 0.0f;
        float absSumRes = 0.0f;
        for (AminoAcid aa : aaSet) {
            float mass = aa.getMass();
            int nominalMass = aa.getNominalMass();
            float rescaledMass = mass * 0.9995f;
            float error = mass - (float)nominalMass;
            float rescaledError = rescaledMass - (float)nominalMass;
            float errorPPM = (rescaledMass - (float)nominalMass) / mass * 1000000.0f;
            System.out.format("%c%s%d%s%.3f%s%.3f%s%.3f%s%.3f\\\\\n", Character.valueOf(aa.getResidue()), delimiter, nominalMass, delimiter, Float.valueOf(mass), delimiter, Float.valueOf(rescaledMass), delimiter, Float.valueOf(error), delimiter, Float.valueOf(rescaledError), delimiter);
            sumReal += error;
            sumRes += rescaledError;
            absSumReal += Math.abs(error);
            absSumRes += Math.abs(rescaledError);
            sumPPM += errorPPM;
        }
        System.out.println("AverageRealError\t" + sumReal / 20.0f);
        System.out.println("AverageRescaledError\t" + sumRes / 20.0f);
        System.out.println("AbsAverageRealError\t" + absSumReal / 20.0f);
        System.out.println("AbsAverageRescaledError\t" + absSumRes / 20.0f);
        System.out.println("AverageErrorPPM\t" + sumPPM / 20.0f);
    }

    public static void checkPeptidesWithNominalMassErrors() throws Exception {
        String fileName = System.getProperty("user.home") + "/Research/Data/IPI/IPI_human_3.87.fasta";
        int maxPeptideLength = 100;
        CompactFastaSequence fastaSequence = new CompactFastaSequence(fileName);
        CompactSuffixArray sa = new CompactSuffixArray(fastaSequence, maxPeptideLength);
        sa.measureNominalMassError(AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys());
    }
}

