/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.misc;

import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Composition;
import edu.ucsd.msjava.msutil.Peptide;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class MassCalc {
    public static void main(String[] argv) {
        AminoAcidSet aaSet = argv.length > 0 ? AminoAcidSet.getStandardAminoAcidSet() : AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        while (true) {
            System.out.print("Sequence : ");
            String pepStr = MassCalc.readLine();
            if (pepStr.matches("[A-Z]*\\..+\\.[A-Z]*")) {
                pepStr = pepStr.substring(pepStr.indexOf(46) + 1, pepStr.lastIndexOf(46));
            }
            Peptide pep = new Peptide(pepStr, aaSet);
            Composition composition = null;
            if (!pep.isModified()) {
                composition = pep.getComposition();
            }
            System.out.println("Mass : " + pep.getAccurateMass() + " (" + composition + ")\t" + pep.getNominalMass() + "\t" + ((double)pep.getMass() + 18.0105647) + "\t" + ((double)pep.getMass() + 18.0105647 + Composition.ChargeCarrierMass()) + "\t" + ((double)pep.getMass() + 18.0105647 + 2.0 * Composition.ChargeCarrierMass()) / 2.0 + "\t" + ((double)pep.getMass() + 18.0105647 + 3.0 * Composition.ChargeCarrierMass()) / 3.0);
        }
    }

    public static String readLine() {
        String buffer = null;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            buffer = br.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }
}

