/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.misc;

import edu.ucsd.msjava.parser.BufferedLineReader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class SplitMgf {
    public static void main(String[] argv) throws Exception {
        String fileName;
        String ext;
        File mgfFile;
        if (argv.length != 2) {
            SplitMgf.printUsageAndExit("Invalid parameters!");
        }
        if (!(mgfFile = new File(argv[0])).exists()) {
            SplitMgf.printUsageAndExit(argv[0] + " does not exist!");
        }
        if (!(ext = (fileName = mgfFile.getName()).substring(fileName.lastIndexOf(46) + 1)).equalsIgnoreCase("mgf")) {
            SplitMgf.printUsageAndExit(argv[0] + ": Invalid file extension!");
        }
        int numParts = Integer.parseInt(argv[1]);
        SplitMgf.split(mgfFile, numParts);
    }

    public static void printUsageAndExit(String message) {
        if (message != null) {
            System.err.println(message);
        }
        System.out.println("usage: java SplitMgf mgfFile(*.mgf) numParts");
        System.exit(-1);
    }

    public static void split(File mgfFile, int numParts) throws Exception {
        String s;
        BufferedLineReader in = new BufferedLineReader(mgfFile.getPath());
        int numSpecs = 0;
        while ((s = in.readLine()) != null) {
            if (!s.startsWith("BEGIN")) continue;
            ++numSpecs;
        }
        int numSpecsPerPart = numSpecs / numParts;
        PrintStream[] out = new PrintStream[numParts];
        for (int i = 0; i < out.length; ++i) {
            String name = mgfFile.getPath().substring(0, mgfFile.getPath().lastIndexOf(46)) + "_Part" + i + ".mgf";
            out[i] = new PrintStream(new BufferedOutputStream(new FileOutputStream(name)));
        }
        int curSize = 0;
        int fileNum = 0;
        in = new BufferedLineReader(mgfFile.getPath());
        while ((s = in.readLine()) != null) {
            if (s.startsWith("BEGIN")) {
                ++curSize;
            }
            if (curSize > numSpecsPerPart) {
                if (fileNum < numParts - 1) {
                    ++fileNum;
                }
                curSize = 0;
            }
            out[fileNum].println(s);
        }
        for (int i = 0; i < out.length; ++i) {
            out[i].close();
        }
    }
}

