/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdbsearch;

import edu.ucsd.msjava.msdbsearch.CandidatePeptideGrid;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Enzyme;

public class CandidatePeptideGridConsideringMetCleavage
extends CandidatePeptideGrid {
    private final CandidatePeptideGrid candidatePepGridMetCleaved;
    boolean isProteinNTermWithHeadingMet = false;

    public CandidatePeptideGridConsideringMetCleavage(AminoAcidSet aaSet, Enzyme enzyme, int maxPeptideLength, int maxNumVariantsPerPeptide, int maxNumMissedCleavages) {
        super(aaSet, enzyme, maxPeptideLength, maxNumVariantsPerPeptide, maxNumMissedCleavages);
        this.candidatePepGridMetCleaved = new CandidatePeptideGrid(aaSet, enzyme, maxPeptideLength, maxNumVariantsPerPeptide, maxNumMissedCleavages);
    }

    @Override
    public boolean addProtNTermResidue(char residue) {
        this.isProteinNTermWithHeadingMet = residue == 'M';
        return super.addProtNTermResidue(residue);
    }

    @Override
    public boolean addNTermResidue(char residue) {
        this.isProteinNTermWithHeadingMet = false;
        return super.addNTermResidue(residue);
    }

    @Override
    public boolean addResidue(int length, char residue) {
        boolean op1 = super.addResidue(length, residue);
        boolean op2 = false;
        if (this.isProteinNTermWithHeadingMet) {
            op2 = length == 2 ? this.candidatePepGridMetCleaved.addProtNTermResidue(residue) : this.candidatePepGridMetCleaved.addResidue(length - 1, residue);
        }
        return op1 || op2;
    }

    @Override
    public boolean addProtCTermResidue(int length, char residue) {
        if (!super.addProtCTermResidue(length, residue)) {
            return false;
        }
        if (this.isProteinNTermWithHeadingMet) {
            return this.candidatePepGridMetCleaved.addProtCTermResidue(length - 1, residue);
        }
        return true;
    }

    @Override
    public boolean addCTermResidue(int length, char residue) {
        if (!super.addCTermResidue(length, residue)) {
            return false;
        }
        if (this.isProteinNTermWithHeadingMet) {
            return this.candidatePepGridMetCleaved.addCTermResidue(length - 1, residue);
        }
        return true;
    }

    @Override
    public int size() {
        if (!this.isProteinNTermWithHeadingMet) {
            return super.size();
        }
        return super.size() + this.candidatePepGridMetCleaved.size();
    }

    @Override
    public boolean isNTermMetCleaved(int index) {
        int sizeNormPep = super.size();
        return index >= sizeNormPep;
    }

    @Override
    public int[] getNominalPRMGrid(int index) {
        if (!this.isProteinNTermWithHeadingMet) {
            return super.getNominalPRMGrid(index);
        }
        int sizeNormPep = super.size();
        if (index < sizeNormPep) {
            return super.getNominalPRMGrid(index);
        }
        return this.candidatePepGridMetCleaved.getNominalPRMGrid(index - sizeNormPep);
    }

    @Override
    public double[] getPRMGrid(int index) {
        if (!this.isProteinNTermWithHeadingMet) {
            return super.getPRMGrid(index);
        }
        int sizeNormPep = super.size();
        if (index < sizeNormPep) {
            return super.getPRMGrid(index);
        }
        return this.candidatePepGridMetCleaved.getPRMGrid(index - sizeNormPep);
    }

    @Override
    public float getPeptideMass(int index) {
        if (!this.isProteinNTermWithHeadingMet) {
            return super.getPeptideMass(index);
        }
        int sizeNormPep = super.size();
        if (index < sizeNormPep) {
            return super.getPeptideMass(index);
        }
        return this.candidatePepGridMetCleaved.getPeptideMass(index - sizeNormPep);
    }

    @Override
    public int getNominalPeptideMass(int index) {
        if (!this.isProteinNTermWithHeadingMet) {
            return super.getNominalPeptideMass(index);
        }
        int sizeNormPep = super.size();
        if (index < sizeNormPep) {
            return super.getNominalPeptideMass(index);
        }
        return this.candidatePepGridMetCleaved.getNominalPeptideMass(index - sizeNormPep);
    }

    @Override
    public String getPeptideSeq(int index) {
        if (!this.isProteinNTermWithHeadingMet) {
            return super.getPeptideSeq(index);
        }
        int sizeNormPep = super.size();
        if (index < sizeNormPep) {
            return super.getPeptideSeq(index);
        }
        return this.candidatePepGridMetCleaved.getPeptideSeq(index - sizeNormPep);
    }

    @Override
    public int getNumMods(int index) {
        if (!this.isProteinNTermWithHeadingMet) {
            return super.getNumMods(index);
        }
        int sizeNormPep = super.size();
        if (index < sizeNormPep) {
            return super.getNumMods(index);
        }
        return this.candidatePepGridMetCleaved.getNumMods(index - sizeNormPep);
    }

    @Override
    public boolean gridIsOverMaxMissedCleavages(int index) {
        if (!this.isProteinNTermWithHeadingMet) {
            return super.gridIsOverMaxMissedCleavages(index);
        }
        int sizeNormPep = super.size();
        if (index < sizeNormPep) {
            return super.gridIsOverMaxMissedCleavages(index);
        }
        return this.candidatePepGridMetCleaved.gridIsOverMaxMissedCleavages(index - sizeNormPep);
    }

    @Override
    public int getPeptideNumMissedCleavages(int index) {
        if (!this.isProteinNTermWithHeadingMet) {
            return super.getPeptideNumMissedCleavages(index);
        }
        int sizeNormPep = super.size();
        if (index < sizeNormPep) {
            return super.getPeptideNumMissedCleavages(index);
        }
        return this.candidatePepGridMetCleaved.getPeptideNumMissedCleavages(index - sizeNormPep);
    }
}

