/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdbsearch;

import edu.ucsd.msjava.msdbsearch.CompactFastaSequence;
import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.suffixarray.SuffixFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;

public class CompactSuffixArray {
    public static final int COMPACT_SUFFIX_ARRAY_FILE_FORMAT_ID = 8294;
    protected static final String EXTENSION_INDICES = ".csarr";
    protected static final String EXTENSION_NLCPS = ".cnlcp";
    protected static final int BUCKET_SIZE = 5;
    protected static final int INT_BYTE_SIZE = 4;
    private final File indexFile;
    private final File nlcpFile;
    private CompactFastaSequence sequence;
    private SuffixFactory factory;
    private int size;
    private int maxPeptideLength;
    private int[] numDistinctPeptides;

    public CompactSuffixArray(CompactFastaSequence sequence) {
        int id;
        this.sequence = sequence;
        this.size = (int)sequence.getSize();
        this.factory = new SuffixFactory(sequence);
        this.indexFile = new File(sequence.getBaseFilepath() + EXTENSION_INDICES);
        this.nlcpFile = new File(sequence.getBaseFilepath() + EXTENSION_NLCPS);
        if (!(this.indexFile.exists() && this.nlcpFile.exists() && this.isCompactSuffixArrayValid(sequence.getLastModified()))) {
            this.createSuffixArrayFiles(sequence, this.indexFile, this.nlcpFile);
        }
        if ((id = this.checkID()) != sequence.getId()) {
            System.err.println("Suffix array files are not consistent: " + this.indexFile + ", " + this.nlcpFile + " (" + id + "!=" + sequence.getId() + ")");
            System.err.println("Please recreate the suffix array file by deleting the .canno, .cseq, and .csarr files.");
            System.exit(-1);
        }
    }

    public CompactSuffixArray(CompactFastaSequence sequence, int maxPeptideLength) {
        this(sequence);
        this.maxPeptideLength = maxPeptideLength;
        this.computeNumDistinctPeptides();
    }

    public File getIndexFile() {
        return this.indexFile;
    }

    public File getNeighboringLcpFile() {
        return this.nlcpFile;
    }

    public CompactFastaSequence getSequence() {
        return this.sequence;
    }

    public int getSize() {
        return this.size;
    }

    public int getNumDistinctPeptides(int length) {
        return this.numDistinctPeptides[length];
    }

    public String getAnnotation(long index) {
        return this.sequence.getAnnotation(index);
    }

    private boolean isCompactSuffixArrayValid(long lastModified) {
        File[] files;
        for (File f : files = new File[]{this.indexFile, this.nlcpFile}) {
            try {
                RandomAccessFile raf = new RandomAccessFile(f, "r");
                raf.seek(raf.length() - 4L - 8L);
                long lastModifiedRecorded = raf.readLong();
                int id = raf.readInt();
                raf.close();
                if (!CompactSuffixArray.NearlyEqualFileTimes(lastModifiedRecorded, lastModified)) {
                    Date suffixArrayModificationTime = new Date(lastModifiedRecorded);
                    Date fastaFileModificationTime = new Date(lastModified);
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
                    System.out.println("Re-creating suffix array files since the cached LastModified time is not within 2 seconds of the LastModified time of the sequence file:\n Time cached in " + f.getName() + " is " + lastModifiedRecorded + " (" + dateFormat.format(suffixArrayModificationTime) + ") while the sequence file has " + dateFormat.format(fastaFileModificationTime));
                    return false;
                }
                if (id == 8294) continue;
                System.out.println("Re-creating suffix array files since " + f.getName() + " has file format ID " + id + " instead of " + 8294);
                return false;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private void computeNumDistinctPeptides() {
        boolean[] isValidResidue = new boolean[128];
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSet();
        for (AminoAcid aa : aaSet) {
            isValidResidue[aa.getResidue()] = true;
        }
        this.numDistinctPeptides = new int[this.maxPeptideLength + 2];
        try {
            File indexFile = this.getIndexFile();
            System.out.printf("Counting number of distinct peptides in %s using %s\n", indexFile.getName(), this.nlcpFile.getName());
            DataInputStream indices = new DataInputStream(new BufferedInputStream(new FileInputStream(indexFile)));
            indices.skip(8L);
            DataInputStream neighboringLcps = new DataInputStream(new BufferedInputStream(new FileInputStream(this.nlcpFile)));
            int size = neighboringLcps.readInt();
            neighboringLcps.readInt();
            long lastStatusTime = System.currentTimeMillis();
            for (int i = 0; i < size; ++i) {
                if (i % 100000 == 0 && System.currentTimeMillis() - lastStatusTime > 2000L) {
                    lastStatusTime = System.currentTimeMillis();
                    System.out.printf("Counting distinct peptides: %.2f%% complete.\n", (double)i * 100.0 / (double)size);
                }
                int index = indices.readInt();
                byte lcp = neighboringLcps.readByte();
                char idx = this.sequence.getCharAt(index);
                if (!isValidResidue[idx]) continue;
                int l = lcp + 1;
                while (l < this.numDistinctPeptides.length) {
                    int n = l++;
                    this.numDistinctPeptides[n] = this.numDistinctPeptides[n] + 1;
                }
            }
            neighboringLcps.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private int checkID() {
        try {
            DataInputStream indices = new DataInputStream(new BufferedInputStream(new FileInputStream(this.indexFile)));
            int sizeIndexFile = indices.readInt();
            int idIndexFile = indices.readInt();
            DataInputStream neighboringLcps = new DataInputStream(new BufferedInputStream(new FileInputStream(this.nlcpFile)));
            int sizeNLcp = neighboringLcps.readInt();
            int idNLcp = neighboringLcps.readInt();
            indices.close();
            neighboringLcps.close();
            if (sizeIndexFile == sizeNLcp && idIndexFile == idNLcp) {
                return idIndexFile;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return 0;
    }

    private void createSuffixArrayFiles(CompactFastaSequence sequence, File indexFile, File nlcpFile) {
        System.out.println("Creating the suffix array indexed file... Size: " + sequence.getSize());
        int hashBase = sequence.getAlphabetSize();
        System.out.println("AlphabetSize: " + sequence.getAlphabetSize());
        if (hashBase > 30) {
            System.err.println("Suffix array construction failure: alphabet size is too large: " + sequence.getAlphabetSize());
            System.exit(-1);
        }
        int denominator = 1;
        for (int i = 0; i < 4; ++i) {
            denominator *= hashBase;
        }
        int numBuckets = denominator * hashBase;
        int currentHash = 0;
        for (int i = 0; i < 4; ++i) {
            currentHash = currentHash * hashBase + sequence.getByteAt(i);
        }
        class Bucket {
            private int[] items = new int[10];
            private int size = 0;

            public void add(int item) {
                if (this.size >= this.items.length) {
                    this.items = Arrays.copyOf(this.items, this.size * 2);
                }
                this.items[this.size++] = item;
            }

            public SuffixFactory.Suffix[] getSortedSuffixes() {
                Object[] sa = new SuffixFactory.Suffix[this.size];
                for (int i = 0; i < this.size; ++i) {
                    sa[i] = CompactSuffixArray.this.factory.makeSuffix(this.items[i]);
                }
                Arrays.sort(sa);
                return sa;
            }
        }
        Bucket[] bucketSuffixes = new Bucket[numBuckets];
        long lastStatusTime = System.currentTimeMillis();
        int numResiduesInSequence = (int)sequence.getSize();
        int i = 4;
        for (int j = 0; j < numResiduesInSequence; ++j) {
            if (j % 100000 == 0 && System.currentTimeMillis() - lastStatusTime > 2000L) {
                lastStatusTime = System.currentTimeMillis();
                System.out.printf("Suffix creation: %.2f%% complete.\n", (double)j * 100.0 / (double)numResiduesInSequence);
            }
            byte b = 0;
            if (i < numResiduesInSequence) {
                b = sequence.getByteAt(i);
            }
            if (bucketSuffixes[currentHash = currentHash % denominator * hashBase + b] == null) {
                bucketSuffixes[currentHash] = new Bucket();
            }
            bucketSuffixes[currentHash].add(j);
            ++i;
        }
        System.gc();
        try {
            DataOutputStream indexOut = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
            DataOutputStream nlcpOut = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(nlcpFile)));
            indexOut.writeInt(numResiduesInSequence);
            indexOut.writeInt(sequence.getId());
            nlcpOut.writeInt(numResiduesInSequence);
            nlcpOut.writeInt(sequence.getId());
            SuffixFactory.Suffix prevBucketSuffix = null;
            System.out.println("Sorting suffixes... Size: " + bucketSuffixes.length);
            lastStatusTime = System.currentTimeMillis();
            for (int i2 = 0; i2 < bucketSuffixes.length; ++i2) {
                if (i2 % 100000 == 0 && System.currentTimeMillis() - lastStatusTime > 2000L) {
                    lastStatusTime = System.currentTimeMillis();
                    System.out.printf("Sorting: %.2f%% complete.\n", (double)i2 * 100.0 / (double)bucketSuffixes.length);
                }
                if (bucketSuffixes[i2] == null) continue;
                SuffixFactory.Suffix[] sortedSuffixes = bucketSuffixes[i2].getSortedSuffixes();
                SuffixFactory.Suffix first = sortedSuffixes[0];
                byte lcp = 0;
                if (prevBucketSuffix != null) {
                    lcp = first.getLCP(prevBucketSuffix);
                }
                indexOut.writeInt(first.getIndex());
                nlcpOut.writeByte(lcp);
                SuffixFactory.Suffix prevSuffix = first;
                for (int j = 1; j < sortedSuffixes.length; ++j) {
                    SuffixFactory.Suffix thisSuffix = sortedSuffixes[j];
                    indexOut.writeInt(thisSuffix.getIndex());
                    lcp = thisSuffix.getLCP(prevSuffix, 5);
                    nlcpOut.writeByte(lcp);
                    prevSuffix = thisSuffix;
                }
                prevBucketSuffix = sortedSuffixes[0];
                bucketSuffixes[i2] = null;
            }
            bucketSuffixes = null;
            long lastModified = sequence.getLastModified();
            indexOut.writeLong(lastModified);
            indexOut.writeInt(8294);
            indexOut.flush();
            indexOut.close();
            nlcpOut.writeLong(lastModified);
            nlcpOut.writeInt(8294);
            nlcpOut.flush();
            nlcpOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public String toString() {
        String retVal = "Size of the suffix array: " + this.size + "\n";
        return retVal;
    }

    public void measureNominalMassError(AminoAcidSet aaSet) throws Exception {
        double[] aaMass = new double[128];
        int[] nominalAAMass = new int[128];
        for (int i = 0; i < aaMass.length; ++i) {
            aaMass[i] = -1.0;
            nominalAAMass[i] = -1;
        }
        for (AminoAcid aa : aaSet) {
            aaMass[aa.getResidue()] = aa.getAccurateMass();
            nominalAAMass[aa.getResidue()] = aa.getNominalMass();
        }
        double[] prm = new double[this.maxPeptideLength];
        int[] nominalPRM = new int[this.maxPeptideLength];
        int i = 2147482647;
        int[] numPeptides = new int[this.maxPeptideLength];
        int[][] numPepWithError = new int[this.maxPeptideLength][11];
        DataInputStream indices = new DataInputStream(new BufferedInputStream(new FileInputStream(this.getIndexFile())));
        indices.skip(8L);
        DataInputStream nlcps = new DataInputStream(new BufferedInputStream(new FileInputStream(this.getNeighboringLcpFile())));
        nlcps.skip(8L);
        int size = this.getSize();
        int index = -1;
        for (int bufferIndex = 0; bufferIndex < size; ++bufferIndex) {
            char residue;
            double m;
            index = indices.readInt();
            byte lcp = nlcps.readByte();
            char idx = this.sequence.getCharAt(index);
            if (aaMass[idx] <= 0.0 || lcp > i) continue;
            for (i = (int)lcp; i < this.maxPeptideLength && !((m = aaMass[residue = this.sequence.getCharAt(index + i)]) <= 0.0); ++i) {
                if (i != 0) {
                    prm[i] = prm[i - 1] + m;
                    nominalPRM[i] = nominalPRM[i - 1] + nominalAAMass[residue];
                } else {
                    prm[i] = m;
                    nominalPRM[i] = nominalAAMass[residue];
                }
                if (i + 1 > this.maxPeptideLength) continue;
                int n = i;
                numPeptides[n] = numPeptides[n] + 1;
                int error = (int)Math.round(prm[i] * 0.9995) - nominalPRM[i];
                int[] nArray = numPepWithError[i];
                int n2 = error += 5;
                nArray[n2] = nArray[n2] + 1;
            }
        }
        long total = 0L;
        long totalErr = 0L;
        System.out.println("Length\tNumDistinctPeptides\tNumPeptides\tNumPeptidesWithErrors");
        for (i = 0; i < this.maxPeptideLength; ++i) {
            System.out.print(i + 1 + "\t" + this.numDistinctPeptides[i + 1] + "\t" + numPeptides[i]);
            total += (long)numPeptides[i];
            for (int j = 0; j < 11; ++j) {
                if (numPepWithError[i][j] <= 0) continue;
                System.out.print("\t" + (j - 5) + ":" + numPepWithError[i][j]);
                if (j == 5) continue;
                totalErr += (long)numPepWithError[i][j];
            }
            System.out.println("\t" + total + "\t" + totalErr + "\t" + (double)totalErr / (double)total);
        }
        System.out.println("Total #Peptides\t" + total);
        System.out.println("Total #Peptides with nominalMass errors\t" + totalErr + "\t" + (double)totalErr / (double)total);
        indices.close();
        nlcps.close();
    }

    public static boolean NearlyEqualFileTimes(long time1, long time2) {
        double timeDiffSeconds = (double)(time1 - time2) / 1000.0;
        return Math.abs(timeDiffSeconds) <= 2.05;
    }
}

