/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdbsearch;

import edu.ucsd.msjava.msdbsearch.DatabaseMatch;
import edu.ucsd.msjava.msdbsearch.Match;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;

public class MSGFPlusMatch
implements Comparable<MSGFPlusMatch> {
    private final int specIndex;
    private final List<DatabaseMatch> matchList;
    private final double specEValue;

    public MSGFPlusMatch(int specIndex, PriorityQueue<DatabaseMatch> matchQueue) {
        this.specIndex = specIndex;
        this.matchList = new ArrayList<DatabaseMatch>(matchQueue);
        Collections.sort(this.matchList, new Match.SpecProbComparator());
        this.specEValue = this.getBestDBMatch().getSpecEValue();
    }

    public DatabaseMatch getBestDBMatch() {
        return this.matchList.get(this.matchList.size() - 1);
    }

    public int getSpecIndex() {
        return this.specIndex;
    }

    public List<DatabaseMatch> getMatchList() {
        return this.matchList;
    }

    public double getSpecEValue() {
        return this.specEValue;
    }

    @Override
    public int compareTo(MSGFPlusMatch o) {
        if (this.specEValue < o.specEValue) {
            return -1;
        }
        if (this.specEValue == o.specEValue) {
            return 0;
        }
        return 1;
    }
}

