/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdbsearch;

import edu.ucsd.msjava.msdbsearch.MassErrorStat;
import edu.ucsd.msjava.msgf.NominalMass;
import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msscorer.NewRankScorer;
import edu.ucsd.msjava.msscorer.NewScoredSpectrum;
import edu.ucsd.msjava.msutil.Pair;
import edu.ucsd.msjava.msutil.Peak;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.msutil.Spectrum;
import java.util.ArrayList;
import java.util.List;

public class PSMFeatureFinder {
    private final Spectrum spec;
    private final Peptide peptide;
    private final NewScoredSpectrum<NominalMass> scoredSpec;
    private Float ms2IonCurrent = null;
    private Float nTermIonCurrent = null;
    private Float cTermIonCurrent = null;
    private Integer numExplainedPeaks = null;
    private Float errSDAll = null;
    private Float errMeanAll = null;
    private Float errSD7 = null;
    private Float errMean7 = null;
    private Float errRSDAll = null;
    private Float errRMeanAll = null;
    private Float errRSD7 = null;
    private Float errRMean7 = null;
    private Tolerance mme;

    public PSMFeatureFinder(Spectrum spec, Spectrum precursorSpec, Peptide peptide, NewRankScorer scorer) {
        this.spec = spec;
        this.peptide = peptide;
        this.scoredSpec = scorer.getScoredSpectrum(spec);
        this.mme = scorer.getSpecDataType().getInstrumentType().isHighResolution() ? new Tolerance(20.0f, true) : new Tolerance(0.5f, false);
        this.extractFeatures();
    }

    public PSMFeatureFinder(Spectrum spec, Peptide peptide, NewRankScorer scorer) {
        this(spec, null, peptide, scorer);
    }

    public List<Pair<String, String>> getAllFeatures() {
        Float isolationWindowEfficiency;
        Float ms1IonCurrent;
        Float cTermExplainedIonCurrent;
        Float nTermExplainedIonCurrent;
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        Float explainedIonCurrentRatio = this.getExplainedIonCurrent();
        if (explainedIonCurrentRatio != null) {
            list.add(new Pair<String, String>("ExplainedIonCurrentRatio", String.valueOf(this.getExplainedIonCurrent())));
        }
        if ((nTermExplainedIonCurrent = this.getNTermExplainedIonCurrent()) != null) {
            list.add(new Pair<String, String>("NTermIonCurrentRatio", String.valueOf(nTermExplainedIonCurrent)));
        }
        if ((cTermExplainedIonCurrent = this.getCTermExplainedIonCurrent()) != null) {
            list.add(new Pair<String, String>("CTermIonCurrentRatio", String.valueOf(cTermExplainedIonCurrent)));
        }
        Float ms2IonCurrent = this.getMS2IonCurrent();
        if (explainedIonCurrentRatio != null) {
            list.add(new Pair<String, String>("MS2IonCurrent", String.valueOf(ms2IonCurrent)));
        }
        if ((ms1IonCurrent = this.getMS1IonCurrent()) != null) {
            list.add(new Pair<String, String>("MS1IonCurrent", String.valueOf(ms1IonCurrent)));
        }
        if ((isolationWindowEfficiency = this.getIsolationWindowEfficiency()) != null) {
            list.add(new Pair<String, String>("IsolationWindowEfficiency", String.valueOf(isolationWindowEfficiency)));
        }
        if (this.numExplainedPeaks != null) {
            list.add(new Pair<String, String>("NumMatchedMainIons", String.valueOf(this.numExplainedPeaks)));
        }
        if (this.errMeanAll != null) {
            list.add(new Pair<String, String>("MeanErrorAll", String.valueOf(this.errMeanAll)));
        }
        if (this.errSDAll != null) {
            list.add(new Pair<String, String>("StdevErrorAll", String.valueOf(this.errSDAll)));
        }
        if (this.errMean7 != null) {
            list.add(new Pair<String, String>("MeanErrorTop7", String.valueOf(this.errMean7)));
        }
        if (this.errSD7 != null) {
            list.add(new Pair<String, String>("StdevErrorTop7", String.valueOf(this.errSD7)));
        }
        if (this.errRMeanAll != null) {
            list.add(new Pair<String, String>("MeanRelErrorAll", String.valueOf(this.errRMeanAll)));
        }
        if (this.errRSDAll != null) {
            list.add(new Pair<String, String>("StdevRelErrorAll", String.valueOf(this.errRSDAll)));
        }
        if (this.errRMean7 != null) {
            list.add(new Pair<String, String>("MeanRelErrorTop7", String.valueOf(this.errRMean7)));
        }
        if (this.errRSD7 != null) {
            list.add(new Pair<String, String>("StdevRelErrorTop7", String.valueOf(this.errRSD7)));
        }
        return list;
    }

    private void extractFeatures() {
        this.computeSumIonCurrent();
        this.computeExplainedIonCurrent();
    }

    private void computeSumIonCurrent() {
        float ms2IonCurrent = 0.0f;
        for (Peak p : this.spec) {
            ms2IonCurrent += p.getIntensity();
        }
        this.ms2IonCurrent = Float.valueOf(ms2IonCurrent);
    }

    private void computeExplainedIonCurrent() {
        float nTermIonCurrent = 0.0f;
        float cTermIonCurrent = 0.0f;
        MassErrorStat errStat = new MassErrorStat();
        double prm = 0.0;
        double srm = 0.0;
        for (int i = 0; i < this.peptide.size() - 1; ++i) {
            nTermIonCurrent += this.scoredSpec.getExplainedIonCurrent((float)(prm += this.peptide.get(i).getAccurateMass()), true, this.mme);
            cTermIonCurrent += this.scoredSpec.getExplainedIonCurrent((float)(srm += this.peptide.get(this.peptide.size() - 1 - i).getAccurateMass()), false, this.mme);
            Pair<Float, Float> err = this.scoredSpec.getMassErrorWithIntensity((float)prm, true, this.mme);
            if (err != null) {
                errStat.add(err);
            }
            if ((err = this.scoredSpec.getMassErrorWithIntensity((float)srm, false, this.mme)) == null) continue;
            errStat.add(err);
        }
        if (errStat.size() > 0) {
            errStat.computeStats();
            this.numExplainedPeaks = errStat.size();
            this.errMeanAll = Float.valueOf(errStat.getMean());
            this.errSDAll = Float.valueOf(errStat.getSd());
            this.errMean7 = Float.valueOf(errStat.getMean7());
            this.errSD7 = Float.valueOf(errStat.getSd7());
            this.errRMeanAll = Float.valueOf(errStat.getRMean());
            this.errRSDAll = Float.valueOf(errStat.getRSd());
            this.errRMean7 = Float.valueOf(errStat.getRMean7());
            this.errRSD7 = Float.valueOf(errStat.getRSd7());
        }
        this.nTermIonCurrent = Float.valueOf(nTermIonCurrent);
        this.cTermIonCurrent = Float.valueOf(cTermIonCurrent);
    }

    public Float getExplainedIonCurrent() {
        Float nEIC = this.getNTermExplainedIonCurrent();
        Float cEIC = this.getCTermExplainedIonCurrent();
        if (nEIC != null && cEIC != null) {
            return Float.valueOf(nEIC.floatValue() + cEIC.floatValue());
        }
        return null;
    }

    public Float getNTermExplainedIonCurrent() {
        return Float.valueOf(this.nTermIonCurrent.floatValue() / this.ms2IonCurrent.floatValue());
    }

    public Float getCTermExplainedIonCurrent() {
        return Float.valueOf(this.cTermIonCurrent.floatValue() / this.ms2IonCurrent.floatValue());
    }

    public Float getMS2IonCurrent() {
        return this.ms2IonCurrent;
    }

    public Float getMS1IonCurrent() {
        return null;
    }

    public Float getIsolationWindowEfficiency() {
        return null;
    }
}

