/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdbsearch;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Random;

public class ShuffleDB {
    public static void main(String[] argv) throws Exception {
        if (argv.length != 2) {
            ShuffleDB.printUsageAndExit();
        }
        String ext1 = argv[0].substring(argv[0].lastIndexOf(46) + 1);
        String ext2 = argv[1].substring(argv[1].lastIndexOf(46) + 1);
        if (!ext1.equalsIgnoreCase("fasta") || !ext2.equalsIgnoreCase("fasta")) {
            System.out.println(ext1 + "," + ext2);
            ShuffleDB.printUsageAndExit();
        }
        ShuffleDB.shuffleDB(argv[0], argv[1], false);
    }

    public static void printUsageAndExit() {
        System.out.println("usage: java ShuffleDB input(fasta) output(fasta)");
        System.exit(0);
    }

    public static void shuffleDB(String inFileName, String outFileName, boolean concatenate) throws Exception {
        int i;
        String s;
        BufferedReader in = new BufferedReader(new FileReader(inFileName));
        ArrayList<StringBuffer> proteinList = new ArrayList<StringBuffer>();
        ArrayList<String> annotation = new ArrayList<String>();
        StringBuffer protein = null;
        while ((s = in.readLine()) != null) {
            if (s.startsWith(">")) {
                if (protein != null) {
                    proteinList.add(protein);
                }
                annotation.add(s.trim());
                protein = new StringBuffer();
                continue;
            }
            protein.append(s.trim());
        }
        if (protein != null) {
            proteinList.add(protein);
        }
        in.close();
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(outFileName)));
        if (concatenate) {
            for (int i2 = 0; i2 < proteinList.size(); ++i2) {
                out.println((String)annotation.get(i2));
                out.println(proteinList.get(i2));
            }
        }
        int numProteins = proteinList.size();
        Random rand = new Random();
        for (i = 0; i < numProteins; ++i) {
            for (int j = 0; j < ((StringBuffer)proteinList.get(i)).length(); ++j) {
                int protIdx = rand.nextInt(numProteins);
                int aaIdx = rand.nextInt(((StringBuffer)proteinList.get(protIdx)).length());
                char curChar = ((StringBuffer)proteinList.get(i)).charAt(j);
                char newChar = ((StringBuffer)proteinList.get(protIdx)).charAt(aaIdx);
                ((StringBuffer)proteinList.get(i)).setCharAt(j, newChar);
                ((StringBuffer)proteinList.get(protIdx)).setCharAt(aaIdx, curChar);
            }
        }
        for (i = 0; i < proteinList.size(); ++i) {
            out.println(">SHFL_" + ((String)annotation.get(i)).substring(1));
            out.println(proteinList.get(i));
        }
        out.close();
    }
}

