/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdictionary;

import edu.ucsd.msjava.msdictionary.GenomeTranslator;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class GenomeLocator {
    File[] genomeFiles;
    RandomAccessFile[] rafs;

    public GenomeLocator(String genomePath) {
        File path = new File(genomePath);
        if (path.isDirectory()) {
            class FastaFilter
            implements FileFilter {
                FastaFilter() {
                }

                @Override
                public boolean accept(File pathname) {
                    String name = pathname.getName();
                    return name.substring(name.lastIndexOf(46) + 1).equalsIgnoreCase("fasta");
                }
            }
            this.genomeFiles = path.listFiles(new FastaFilter());
        } else {
            this.genomeFiles = new File[1];
            this.genomeFiles[0] = path;
        }
        assert (this.genomeFiles.length > 0);
        this.rafs = new RandomAccessFile[this.genomeFiles.length];
        int i = 0;
        for (File f : this.genomeFiles) {
            try {
                this.rafs[i++] = new RandomAccessFile(f, "r");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public String getGenome(String annotation, long filePos, int shift) {
        StringBuffer segment = new StringBuffer();
        for (RandomAccessFile raf : this.rafs) {
            StringBuffer s = new StringBuffer();
            try {
                raf.seek(filePos - (long)shift);
                while (true) {
                    char residue;
                    if ((residue = (char)raf.readByte()) == 'A' || residue == 'T' || residue == 'C' || residue == 'G') {
                        s.append(residue);
                        continue;
                    }
                    if (residue != '\r' && residue != '\n') break;
                }
                System.out.println(s);
                System.out.println(GenomeTranslator.translate(s.toString(), shift));
                System.out.println(GenomeTranslator.translateReverseComplement(s.toString(), shift));
                System.out.println();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return segment.toString();
    }

    public static void main(String[] argv) {
        GenomeLocator loc = new GenomeLocator(System.getProperty("user.home") + "/Research/Data/HumanGenome/splitted");
        loc.getGenome("14", 146908676L, 1);
    }
}

