/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf;

import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Annotation;
import edu.ucsd.msjava.msutil.Matter;
import edu.ucsd.msjava.msutil.Peptide;
import java.util.ArrayList;

public abstract class DeNovoGraph<T extends Matter> {
    protected T source;
    protected T pmNode;
    protected ArrayList<T> sinkNodes;
    protected ArrayList<T> intermediateNodes;

    public T getSource() {
        return this.source;
    }

    public T getPMNode() {
        return this.pmNode;
    }

    public ArrayList<T> getSinkList() {
        return this.sinkNodes;
    }

    public ArrayList<T> getIntermediateNodeList() {
        return this.intermediateNodes;
    }

    public abstract boolean isReverse();

    public abstract int getScore(Peptide var1);

    public abstract int getScore(Annotation var1);

    public abstract int getNodeScore(T var1);

    public abstract ArrayList<Edge<T>> getEdges(T var1);

    public abstract T getComplementNode(T var1);

    public abstract AminoAcidSet getAASet();

    public static class Edge<T extends Matter> {
        private T prevNode;
        private float probability;
        private int index;
        private float mass;
        private int cleavageScore;
        private int errorScore;

        public Edge(T prevNode, float probability, int index, float mass) {
            this.prevNode = prevNode;
            this.probability = probability;
            this.index = index;
            this.mass = mass;
        }

        public T getPrevNode() {
            return this.prevNode;
        }

        public void setCleavageScore(int cleavageScore) {
            this.cleavageScore = cleavageScore;
        }

        public void setErrorScore(int errorScore) {
            this.errorScore = errorScore;
        }

        public void setEdgeMass(float mass) {
            this.mass = mass;
        }

        public int getEdgeScore() {
            return this.cleavageScore + this.errorScore;
        }

        public int getErrorScore() {
            return this.errorScore;
        }

        public float getEdgeProbability() {
            return this.probability;
        }

        public int getEdgeIndex() {
            return this.index;
        }

        public float getEdgeMass() {
            return this.mass;
        }
    }
}

