/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf;

import edu.ucsd.msjava.msgf.DeNovoGraph;
import edu.ucsd.msjava.msgf.NominalMass;
import edu.ucsd.msjava.msgf.ScoredSpectrum;
import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Annotation;
import edu.ucsd.msjava.msutil.Enzyme;
import edu.ucsd.msjava.msutil.Modification;
import edu.ucsd.msjava.msutil.Peptide;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class FlexAminoAcidGraph
extends DeNovoGraph<NominalMass> {
    public static final int MODIFIED_EDGE_PENALTY = 0;
    private ScoredSpectrum<NominalMass> scoredSpec;
    private Enzyme enzyme;
    private boolean direction;
    private AminoAcidSet aaSet;
    private boolean useProtNTerm;
    private boolean useProtCTerm;
    private HashMap<NominalMass, ArrayList<DeNovoGraph.Edge<NominalMass>>> edgeMap;
    private HashMap<NominalMass, Integer> nodeScore;
    private static AtomicInteger negativeCompNodeMassWarnCount;
    private static AtomicInteger negativeNodeMassWarnCount;
    private static AtomicInteger nullNodeCountGetNodeScore;
    private static AtomicInteger exceptionCountGetNodeScore;

    public FlexAminoAcidGraph(AminoAcidSet aaSet, int peptideMass, Enzyme enzyme, ScoredSpectrum<NominalMass> scoredSpec) {
        this(aaSet, peptideMass, enzyme, scoredSpec, false, false);
    }

    public FlexAminoAcidGraph(AminoAcidSet aaSet, int peptideMass, Enzyme enzyme, ScoredSpectrum<NominalMass> scoredSpec, boolean useProteinNTerm, boolean useProteinCTerm) {
        this.enzyme = enzyme;
        this.direction = scoredSpec.getMainIonDirection();
        this.scoredSpec = scoredSpec;
        this.aaSet = aaSet;
        this.useProtNTerm = useProteinNTerm;
        this.useProtCTerm = useProteinCTerm;
        this.source = new NominalMass(0);
        this.pmNode = new NominalMass(peptideMass);
        if (negativeNodeMassWarnCount == null) {
            negativeNodeMassWarnCount = new AtomicInteger();
        }
        if (negativeCompNodeMassWarnCount == null) {
            negativeCompNodeMassWarnCount = new AtomicInteger();
        }
        if (nullNodeCountGetNodeScore == null) {
            nullNodeCountGetNodeScore = new AtomicInteger();
        }
        if (exceptionCountGetNodeScore == null) {
            exceptionCountGetNodeScore = new AtomicInteger();
        }
        this.edgeMap = new HashMap();
        this.edgeMap.put((NominalMass)this.source, new ArrayList());
        this.setForwardEdgesFromSource();
        this.setForwardEdgesFromIntermediateNodes();
        this.intermediateNodes = new ArrayList<NominalMass>(this.edgeMap.keySet());
        Collections.sort(this.intermediateNodes);
        this.setBackwardEdgesFromSink();
        this.sinkNodes = new ArrayList();
        this.sinkNodes.add(this.pmNode);
        this.computeNodeScores();
    }

    @Override
    public NominalMass getComplementNode(NominalMass node) {
        return new NominalMass(((NominalMass)this.pmNode).getNominalMass() - node.getNominalMass());
    }

    @Override
    public ArrayList<DeNovoGraph.Edge<NominalMass>> getEdges(NominalMass curNode) {
        return this.edgeMap.get(curNode);
    }

    @Override
    public int getNodeScore(NominalMass node) {
        if (node == null) {
            int errorCount = nullNodeCountGetNodeScore.addAndGet(1);
            if (this.notifyError(errorCount)) {
                System.out.println("Note: null node encountered in getNodeScore");
            }
            return 0;
        }
        try {
            return this.nodeScore.get(node);
        }
        catch (Exception ex) {
            int errorCount = exceptionCountGetNodeScore.addAndGet(1);
            if (this.notifyError(errorCount)) {
                System.out.println("Note: Exception in getNodeScore retrieving node at nominal mass " + node.getNominalMass() + ": " + ex.getMessage());
            }
            return 0;
        }
    }

    @Override
    public int getScore(Peptide pep) {
        int score = 0;
        NominalMass prevNode = (NominalMass)this.source;
        int nominalMass = 0;
        for (int i = 0; i < pep.size() - 1; ++i) {
            AminoAcid aa = this.direction ? pep.get(i) : pep.get(pep.size() - 1 - i);
            NominalMass curNode = new NominalMass(nominalMass += aa.getNominalMass());
            int nodeScore = this.getNodeScore(curNode);
            int edgeScore = this.scoredSpec.getEdgeScore(curNode, prevNode, aa.getMass());
            if (prevNode == this.source && !this.direction && this.enzyme != null) {
                edgeScore = this.enzyme.isCleavable(aa) ? (edgeScore += this.aaSet.getPeptideCleavageCredit()) : (edgeScore += this.aaSet.getPeptideCleavagePenalty());
            }
            prevNode = curNode;
            score += nodeScore + edgeScore;
        }
        if (this.direction && this.enzyme != null) {
            score = this.enzyme.isCleavable(pep.get(pep.size() - 1)) ? (score += this.aaSet.getPeptideCleavageCredit()) : (score += this.aaSet.getPeptideCleavagePenalty());
        }
        nominalMass = this.direction ? (nominalMass += pep.get(pep.size() - 1).getNominalMass()) : (nominalMass += pep.get(0).getNominalMass());
        if (nominalMass != ((NominalMass)this.pmNode).getNominalMass()) {
            return Integer.MIN_VALUE;
        }
        return score;
    }

    @Override
    public int getScore(Annotation annotation) {
        int score = this.getScore(annotation.getPeptide());
        if (this.enzyme != null) {
            AminoAcid neighboringAA = this.enzyme.isCTerm() ? annotation.getPrevAA() : annotation.getNextAA();
            score = neighboringAA == null || this.enzyme.isCleavable(neighboringAA) ? (score += this.aaSet.getNeighboringAACleavageCredit()) : (score += this.aaSet.getNeighboringAACleavagePenalty());
        }
        return score;
    }

    @Override
    public boolean isReverse() {
        return !this.direction;
    }

    @Override
    public AminoAcidSet getAASet() {
        return this.aaSet;
    }

    private void computeNodeScores() {
        this.nodeScore = new HashMap();
        this.nodeScore.put((NominalMass)this.source, 0);
        boolean warnNegativeNodeMass = false;
        boolean warnNegativeCompNodeMass = false;
        for (int i = 1; i < this.intermediateNodes.size(); ++i) {
            int warnCount;
            NominalMass node = (NominalMass)this.intermediateNodes.get(i);
            NominalMass compNode = this.getComplementNode(node);
            if (node.getNominalMass() < 0 && !warnNegativeNodeMass) {
                warnNegativeNodeMass = true;
                warnCount = negativeNodeMassWarnCount.addAndGet(1);
                if (this.notifyError(warnCount)) {
                    System.out.println("Note: negative node mass in computeNodeScores (count = " + Integer.toString(warnCount) + ")");
                }
            }
            if (compNode.getNominalMass() < 0 && !warnNegativeCompNodeMass) {
                warnNegativeCompNodeMass = true;
                warnCount = negativeCompNodeMassWarnCount.addAndGet(1);
                if (this.notifyError(warnCount)) {
                    System.out.println("Note: negative compnode mass in computeNodeScores (count = " + Integer.toString(warnCount) + ")");
                }
            }
            int score = this.isReverse() ? this.scoredSpec.getNodeScore(compNode, node) : this.scoredSpec.getNodeScore(node, compNode);
            this.nodeScore.put(node, score);
        }
        for (NominalMass node : this.sinkNodes) {
            this.nodeScore.put(node, 0);
        }
    }

    private boolean notifyError(int errorCount) {
        return errorCount < 5 || errorCount == 100 || errorCount == 1000 || errorCount % 10000 == 0;
    }

    private void setForwardEdgesFromSource() {
        Modification.Location location = this.direction ? (!this.useProtNTerm ? Modification.Location.N_Term : Modification.Location.Protein_N_Term) : (!this.useProtCTerm ? Modification.Location.C_Term : Modification.Location.Protein_C_Term);
        ArrayList<AminoAcid> aaList = this.aaSet.getAAList(location);
        this.makeForwardEdges((NominalMass)this.source, aaList, this.enzyme != null && this.direction == this.enzyme.isNTerm());
    }

    private void setForwardEdgesFromIntermediateNodes() {
        ArrayList<AminoAcid> aaList = this.aaSet.getAAList(Modification.Location.Anywhere);
        for (int i = 1; i < ((NominalMass)this.pmNode).getNominalMass(); ++i) {
            this.makeForwardEdges(new NominalMass(i), aaList, false);
        }
    }

    private void setBackwardEdgesFromSink() {
        Modification.Location location = this.direction ? (!this.useProtCTerm ? Modification.Location.C_Term : Modification.Location.Protein_C_Term) : (!this.useProtNTerm ? Modification.Location.N_Term : Modification.Location.Protein_N_Term);
        ArrayList<AminoAcid> aaList = this.aaSet.getAAList(location);
        int peptideNominalMass = ((NominalMass)this.pmNode).getNominalMass();
        ArrayList<DeNovoGraph.Edge<NominalMass>> edges = new ArrayList<DeNovoGraph.Edge<NominalMass>>();
        for (AminoAcid aa : aaList) {
            NominalMass prevNode = new NominalMass(peptideNominalMass - aa.getNominalMass());
            if (!this.edgeMap.containsKey(prevNode)) continue;
            DeNovoGraph.Edge<NominalMass> edge = new DeNovoGraph.Edge<NominalMass>(prevNode, aa.getProbability(), this.aaSet.getIndex(aa), aa.getMass());
            edges.add(edge);
            if (this.enzyme != null && this.direction != this.enzyme.isNTerm()) {
                if (this.enzyme.isCleavable(aa)) {
                    edge.setCleavageScore(this.aaSet.getPeptideCleavageCredit());
                } else {
                    edge.setCleavageScore(this.aaSet.getPeptideCleavagePenalty());
                }
            }
            if (!aa.isModified()) continue;
            edge.setErrorScore(0);
        }
        this.edgeMap.put((NominalMass)this.pmNode, edges);
    }

    private void makeForwardEdges(NominalMass curNode, ArrayList<AminoAcid> aaList, boolean addCleavageScore) {
        if (this.edgeMap.get(curNode) == null) {
            return;
        }
        int curNominalMass = curNode.getNominalMass();
        for (AminoAcid aa : aaList) {
            int nextNodeNominalMass = curNominalMass + aa.getNominalMass();
            if (nextNodeNominalMass >= ((NominalMass)this.pmNode).getNominalMass()) continue;
            NominalMass nextNode = new NominalMass(nextNodeNominalMass);
            ArrayList<DeNovoGraph.Edge<NominalMass>> edges = this.edgeMap.get(nextNode);
            if (edges == null) {
                edges = new ArrayList();
                this.edgeMap.put(nextNode, edges);
            }
            DeNovoGraph.Edge<NominalMass> edge = new DeNovoGraph.Edge<NominalMass>(curNode, aa.getProbability(), this.aaSet.getIndex(aa), aa.getMass());
            int errorScore = this.scoredSpec.getEdgeScore(nextNode, curNode, aa.getMass());
            if (errorScore < -100 || errorScore > 100) {
                System.err.println("Warning, invalid ErrorScore: " + errorScore);
                errorScore = -4;
            }
            edge.setErrorScore(errorScore);
            if (addCleavageScore) {
                if (this.enzyme.isCleavable(aa)) {
                    edge.setCleavageScore(this.aaSet.getPeptideCleavageCredit());
                } else {
                    edge.setCleavageScore(this.aaSet.getPeptideCleavagePenalty());
                }
            }
            edges.add(edge);
        }
    }
}

