/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf;

import edu.ucsd.msjava.msgf.GF;
import edu.ucsd.msjava.msgf.GeneratingFunction;
import edu.ucsd.msjava.msgf.ScoreDist;
import edu.ucsd.msjava.msgf.ScoreDistFactory;
import edu.ucsd.msjava.msutil.Annotation;
import edu.ucsd.msjava.msutil.Matter;
import java.util.HashMap;
import java.util.Map;

public class GeneratingFunctionGroup<T extends Matter>
extends HashMap<T, GeneratingFunction<T>>
implements GF<T> {
    private static ScoreDistFactory factory = new ScoreDistFactory(false, true);
    private static final long serialVersionUID = 1L;
    private ScoreDist mergedScoreDist = null;

    public void registerGF(T sink, GeneratingFunction<T> gf) {
        this.put(sink, gf);
    }

    @Override
    public boolean computeGeneratingFunction() {
        GeneratingFunction gf;
        int minScore = Integer.MAX_VALUE;
        int maxScore = Integer.MIN_VALUE;
        for (Map.Entry entry : this.entrySet()) {
            int curMaxScore;
            gf = (GeneratingFunction)entry.getValue();
            if (gf.isGFComputed() || !gf.computeGeneratingFunction()) continue;
            int curMinScore = gf.getMinScore();
            if (minScore > curMinScore) {
                minScore = curMinScore;
            }
            if (maxScore >= (curMaxScore = gf.getMaxScore())) continue;
            maxScore = curMaxScore;
        }
        if (minScore >= maxScore) {
            return false;
        }
        this.mergedScoreDist = factory.getInstance(minScore, maxScore);
        for (Map.Entry entry : this.entrySet()) {
            gf = (GeneratingFunction)entry.getValue();
            this.mergedScoreDist.addProbDist(gf.getScoreDist(), 0, 1.0f);
        }
        return true;
    }

    @Override
    public int getScore(Annotation annotation) {
        int score = Integer.MIN_VALUE;
        for (Map.Entry entry : this.entrySet()) {
            GeneratingFunction gf = (GeneratingFunction)entry.getValue();
            int curScore = gf.getScore(annotation);
            if (curScore <= score) continue;
            score = curScore;
        }
        return score;
    }

    @Override
    public double getSpectralProbability(int score) {
        return this.mergedScoreDist.getSpectralProbability(score);
    }

    @Override
    public int getMaxScore() {
        if (this.mergedScoreDist == null) {
            System.out.println("Debug in getMaxScore: getMaxScore is null");
        }
        return this.mergedScoreDist.getMaxScore();
    }

    @Override
    public ScoreDist getScoreDist() {
        return this.mergedScoreDist;
    }
}

