/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf;

import edu.ucsd.msjava.msgf.DeNovoGraph;
import edu.ucsd.msjava.msgf.DeNovoNodeFactory;
import edu.ucsd.msjava.msgf.ScoredSpectrum;
import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Annotation;
import edu.ucsd.msjava.msutil.Enzyme;
import edu.ucsd.msjava.msutil.Matter;
import edu.ucsd.msjava.msutil.Modification;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.msutil.Sequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

public class GenericDeNovoGraph<T extends Matter>
extends DeNovoGraph<T> {
    private HashMap<T, Integer> nodeScore;
    private ScoredSpectrum<T> scoredSpec;
    private DeNovoNodeFactory<T> factory;
    private Enzyme enzyme;
    private HashMap<T, ArrayList<DeNovoGraph.Edge<T>>> edgeMap;

    public GenericDeNovoGraph(DeNovoNodeFactory<T> factory, float parentMass, Tolerance pmTolerance, Enzyme enzyme, ScoredSpectrum<T> scoredSpec) {
        this(factory, parentMass, pmTolerance, enzyme, scoredSpec, false);
    }

    public GenericDeNovoGraph(DeNovoNodeFactory<T> factory, float parentMass, Tolerance pmTolerance, Enzyme enzyme, ScoredSpectrum<T> scoredSpec, boolean containsModifiedSinkEdge) {
        this.factory = factory;
        this.enzyme = enzyme;
        this.scoredSpec = scoredSpec;
        this.edgeMap = new HashMap();
        this.source = factory.getZero();
        float peptideMass = parentMass - 18.010565f;
        this.pmNode = factory.getNode(peptideMass);
        this.sinkNodes = factory.getNodes(peptideMass, pmTolerance);
        this.setEdgesToSinkNodes(containsModifiedSinkEdge);
        this.setIntermediateNodes();
        this.setEdgesToIntermediateNodes();
        this.computeNodeScores();
    }

    @Override
    public T getComplementNode(T srm) {
        return (T)this.factory.getComplementNode((Matter)srm, this.pmNode);
    }

    @Override
    public ArrayList<DeNovoGraph.Edge<T>> getEdges(T curNode) {
        return this.edgeMap.get(curNode);
    }

    @Override
    public int getNodeScore(T node) {
        return this.nodeScore.get(node);
    }

    @Override
    public int getScore(Peptide pep) {
        int score = 0;
        Matter prevNode = this.source;
        Sequence<T> seq = this.factory.toCumulativeSequence(!this.isReverse(), pep);
        Matter pmNode = (Matter)seq.get(seq.size() - 1);
        if (!this.sinkNodes.contains(pmNode)) {
            return Integer.MIN_VALUE;
        }
        for (int i = 0; i < seq.size() - 1; ++i) {
            Matter curNode = (Matter)seq.get(i);
            int nodeScore = this.getNodeScore(curNode);
            AminoAcid aa = !this.isReverse() ? pep.get(i) : pep.get(pep.size() - 1 - i);
            int edgeScore = this.scoredSpec.getEdgeScore(curNode, prevNode, aa.getMass());
            if (prevNode == this.source && this.enzyme != null) {
                edgeScore = this.enzyme.isCleavable(aa) ? (edgeScore += this.factory.getAASet().getPeptideCleavageCredit()) : (edgeScore += this.factory.getAASet().getPeptideCleavagePenalty());
            }
            score += nodeScore + edgeScore;
            prevNode = curNode;
        }
        return score;
    }

    @Override
    public int getScore(Annotation annotation) {
        int score = this.getScore(annotation.getPeptide());
        if (score > Integer.MIN_VALUE && this.enzyme != null) {
            AminoAcid neighboringAA = this.enzyme.isCTerm() ? annotation.getPrevAA() : annotation.getNextAA();
            score = neighboringAA == null || this.enzyme.isCleavable(neighboringAA) ? (score += this.factory.getAASet().getNeighboringAACleavageCredit()) : (score += this.factory.getAASet().getNeighboringAACleavagePenalty());
        }
        return score;
    }

    @Override
    public boolean isReverse() {
        return this.factory.isReverse();
    }

    @Override
    public AminoAcidSet getAASet() {
        return this.factory.getAASet();
    }

    private void computeNodeScores() {
        this.nodeScore = new HashMap();
        boolean isReverse = this.factory.isReverse();
        this.nodeScore.put(this.source, 0);
        for (int i = 1; i < this.intermediateNodes.size(); ++i) {
            Matter node = (Matter)this.intermediateNodes.get(i);
            Matter compNode = this.getComplementNode(node);
            int score = isReverse ? this.scoredSpec.getNodeScore(compNode, node) : this.scoredSpec.getNodeScore(node, compNode);
            this.nodeScore.put(node, score);
        }
        for (Matter node : this.sinkNodes) {
            this.nodeScore.put(node, 0);
        }
    }

    private void setEdgesToSinkNodes(boolean containsModifiedSinkEdge) {
        boolean isReverse = this.factory.isReverse();
        Modification.Location location = isReverse ? (!containsModifiedSinkEdge ? Modification.Location.N_Term : Modification.Location.Protein_N_Term) : (!containsModifiedSinkEdge ? Modification.Location.C_Term : Modification.Location.Protein_C_Term);
        AminoAcidSet aaSet = this.factory.getAASet();
        ArrayList<AminoAcid> aaList = aaSet.getAAList(location);
        for (Matter curNode : this.sinkNodes) {
            ArrayList<DeNovoGraph.Edge<Matter>> edges = new ArrayList<DeNovoGraph.Edge<Matter>>();
            for (AminoAcid aa : aaList) {
                Matter prevNode = this.factory.getPreviousNode(curNode, aa);
                if (prevNode == null) continue;
                DeNovoGraph.Edge<Matter> edge = new DeNovoGraph.Edge<Matter>(prevNode, aa.getProbability(), aaSet.getIndex(aa), aa.getMass());
                edges.add(edge);
            }
            this.edgeMap.put(curNode, edges);
        }
    }

    private void setEdgesToIntermediateNodes() {
        for (Matter curNode : this.intermediateNodes) {
            ArrayList<DeNovoGraph.Edge<Matter>> edges = this.factory.getEdges(curNode);
            for (DeNovoGraph.Edge<Matter> edge : edges) {
                Matter prevNode = edge.getPrevNode();
                int errorScore = this.scoredSpec.getEdgeScore(curNode, prevNode, edge.getEdgeMass());
                edge.setErrorScore(errorScore);
            }
            this.edgeMap.put(curNode, edges);
        }
    }

    private void setIntermediateNodes() {
        HashSet<Matter> depth1Nodes = new HashSet<Matter>();
        for (Matter sink : this.sinkNodes) {
            ArrayList<DeNovoGraph.Edge<Matter>> edges = this.getEdges(sink);
            if (edges == null) continue;
            for (DeNovoGraph.Edge<Matter> edge : edges) {
                Matter prevNode = edge.getPrevNode();
                depth1Nodes.add(prevNode);
            }
        }
        ArrayList<T> intermidiateNodeList = this.factory.getLinkedNodeList(depth1Nodes);
        Collections.sort(intermidiateNodeList);
        this.intermediateNodes = intermidiateNodeList;
    }
}

