/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf;

import edu.ucsd.msjava.msgf.DeNovoGraph;
import edu.ucsd.msjava.msgf.MassFactory;
import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Enzyme;
import edu.ucsd.msjava.msutil.Matter;
import java.util.ArrayList;

public class IntMassFactory
extends MassFactory<IntMass> {
    private float rescalingConstant;
    private IntMass[] factory;
    private IntMass zero;
    private int[] aaMassIndex;

    public IntMassFactory(AminoAcidSet aaSet, Enzyme enzyme, int maxLength, float rescalingConstant, boolean preComputeEdges) {
        super(aaSet, enzyme, maxLength);
        this.rescalingConstant = rescalingConstant;
        int heaviestAAIndex = this.getMassIndex(aaSet.getHeaviestAA().getMass());
        int maxIndex = heaviestAAIndex * maxLength;
        this.factory = new IntMass[maxIndex + 2];
        this.zero = this.factory[0] = new IntMass(0);
        this.aaMassIndex = new int[128];
        for (AminoAcid aa : aaSet) {
            this.aaMassIndex[aa.getResidue()] = this.getMassIndex(aa.getMass());
        }
        this.makeAllPossibleMasses(preComputeEdges);
    }

    public IntMassFactory(AminoAcidSet aaSet, Enzyme enzyme, int maxLength, float rescalingConstant) {
        this(aaSet, enzyme, maxLength, rescalingConstant, true);
    }

    public IntMass getInstance(float mass) {
        int massIndex = this.getMassIndex(mass);
        return this.getInstanceOfIndex(massIndex);
    }

    public float getRescalingConstant() {
        return this.rescalingConstant;
    }

    public IntMass getInstanceOfIndex(int index) {
        if (index < this.factory.length) {
            return this.factory[index];
        }
        return null;
    }

    public int getMassIndex(float mass) {
        return Math.round(mass * this.rescalingConstant);
    }

    public float getMassFromIndex(int massIndex) {
        return (float)massIndex / this.rescalingConstant;
    }

    @Override
    public ArrayList<DeNovoGraph.Edge<IntMass>> getEdges(IntMass curNode) {
        if (this.edgeMap != null) {
            return (ArrayList)this.edgeMap.get(curNode);
        }
        int curIndex = curNode.massIndex;
        ArrayList<DeNovoGraph.Edge<IntMass>> edges = new ArrayList<DeNovoGraph.Edge<IntMass>>();
        for (AminoAcid aa : this.aaSet) {
            int prevIndex = curIndex - this.aaMassIndex[aa.getResidue()];
            IntMass prevNode = new IntMass(prevIndex);
            DeNovoGraph.Edge<IntMass> edge = new DeNovoGraph.Edge<IntMass>(prevNode, aa.getProbability(), this.aaSet.getIndex(aa), aa.getMass());
            int cleavageScore = 0;
            if (prevIndex == 0 && this.enzyme != null) {
                cleavageScore = this.enzyme.isCleavable(aa) ? (cleavageScore += this.aaSet.getPeptideCleavageCredit()) : (cleavageScore += this.aaSet.getPeptideCleavagePenalty());
            }
            edge.setCleavageScore(cleavageScore);
            edges.add(edge);
        }
        return edges;
    }

    @Override
    public DeNovoGraph.Edge<IntMass> getEdge(IntMass curNode, IntMass prevNode) {
        return null;
    }

    @Override
    public IntMass getPreviousNode(IntMass curNode, AminoAcid aa) {
        int index = curNode.getMassIndex() - this.getMassIndex(aa.getMass());
        if (index < 0) {
            return null;
        }
        return this.factory[index];
    }

    @Override
    public IntMass getNextNode(IntMass curNode, AminoAcid aa) {
        int index = curNode.getMassIndex() + this.getMassIndex(aa.getMass());
        if (this.factory[index] == null) {
            this.factory[index] = new IntMass(index);
        }
        return this.factory[index];
    }

    @Override
    public IntMass getComplementNode(IntMass srm, IntMass pmNode) {
        int index = pmNode.massIndex - srm.massIndex;
        if (this.factory[index] != null) {
            return this.factory[index];
        }
        return new IntMass(index);
    }

    @Override
    public ArrayList<IntMass> getNodes(float peptideMass, Tolerance tolerance) {
        ArrayList<IntMass> nodes = new ArrayList<IntMass>();
        float tolDa = tolerance.getToleranceAsDa(peptideMass);
        int minIndex = this.getMassIndex(peptideMass - tolDa);
        int maxIndex = this.getMassIndex(peptideMass + tolDa);
        for (int index = minIndex; index <= maxIndex; ++index) {
            if (this.factory[index] != null) {
                nodes.add(this.factory[index]);
                continue;
            }
            nodes.add(new IntMass(index));
        }
        return nodes;
    }

    @Override
    public IntMass getNode(float peptideMass) {
        int index = this.getMassIndex(peptideMass);
        if (this.factory[index] != null) {
            return this.factory[index];
        }
        return new IntMass(index);
    }

    @Override
    public IntMass getZero() {
        return this.zero;
    }

    @Override
    public boolean contains(IntMass node) {
        int index = node.massIndex;
        if (index < 0 || index >= this.factory.length) {
            return false;
        }
        return this.factory[node.massIndex] != null;
    }

    public class IntMass
    extends Matter {
        private int massIndex;

        protected IntMass(int massIndex) {
            this.massIndex = massIndex;
        }

        @Override
        public float getMass() {
            return (float)this.massIndex / IntMassFactory.this.rescalingConstant;
        }

        @Override
        public int getNominalMass() {
            return this.massIndex;
        }

        public int getMassIndex() {
            return this.massIndex;
        }

        public int hashCode() {
            return this.massIndex;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof IntMass)) {
                return false;
            }
            return this.massIndex == ((IntMass)obj).massIndex;
        }

        @Override
        public String toString() {
            return String.valueOf(this.massIndex);
        }
    }
}

