/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf;

import java.util.ArrayList;

public class LinearCalibration {
    ArrayList<Float> x = new ArrayList();
    ArrayList<Float> y = new ArrayList();
    float slope;
    float intercept;
    boolean isUpdated = false;

    public float predict(float x) {
        if (!this.isUpdated) {
            this.update();
        }
        return x * this.slope + this.intercept;
    }

    public float getSlope() {
        if (this.isUpdated) {
            return this.slope;
        }
        this.update();
        return this.slope;
    }

    public float getIntercept() {
        if (this.isUpdated) {
            return this.intercept;
        }
        this.update();
        return this.intercept;
    }

    public void addData(float x, float y) {
        this.x.add(Float.valueOf(x));
        this.y.add(Float.valueOf(y));
        this.isUpdated = false;
    }

    private void update() {
        float sumXSq = 0.0f;
        float sumX = 0.0f;
        float sumY = 0.0f;
        float sumXY = 0.0f;
        if (this.x.size() < 2) {
            this.slope = 1.0f;
            this.intercept = 0.0f;
            return;
        }
        for (int i = 0; i < this.x.size(); ++i) {
            sumXSq += this.x.get(i).floatValue() * this.x.get(i).floatValue();
            sumX += this.x.get(i).floatValue();
            sumY += this.y.get(i).floatValue();
            sumXY += this.x.get(i).floatValue() * this.y.get(i).floatValue();
        }
        this.slope = ((float)this.x.size() * sumXY - sumX * sumY) / ((float)this.x.size() * sumXSq - sumX * sumX);
        this.intercept = (sumY - this.slope * sumX) / (float)this.x.size();
        this.isUpdated = true;
    }
}

