/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf;

import edu.ucsd.msjava.msgf.DeNovoGraph;
import edu.ucsd.msjava.msgf.MassFactory;
import edu.ucsd.msjava.msgf.NominalMass;
import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Enzyme;
import java.util.ArrayList;

public class NominalMassFactory
extends MassFactory<NominalMass> {
    private float rescalingConstant = 0.999497f;
    private NominalMass[] factory;
    private NominalMass zero;
    private static NominalMassFactory defaultNominalMassFactory = new NominalMassFactory(50);

    public NominalMassFactory(AminoAcidSet aaSet, Enzyme enzyme, int maxLength) {
        super(aaSet, enzyme, maxLength);
        int heaviestNominalMass = aaSet.getHeaviestAA().getNominalMass();
        int maxIndex = heaviestNominalMass * maxLength;
        this.factory = new NominalMass[maxIndex + 2];
        this.zero = this.factory[0] = new NominalMass(0);
        this.makeAllPossibleMasses(true);
    }

    private NominalMassFactory(int maxLength) {
        super(null, null, maxLength);
    }

    public NominalMass getInstance(float mass) {
        int massIndex = this.getMassIndex(mass);
        return this.getInstanceOfIndex(massIndex);
    }

    public float getRescalingConstant() {
        return this.rescalingConstant;
    }

    public NominalMass getInstanceOfIndex(int index) {
        if (index < this.factory.length) {
            return this.factory[index];
        }
        return null;
    }

    public int getMassIndex(float mass) {
        return Math.round(mass * this.rescalingConstant);
    }

    public float getMassFromIndex(int massIndex) {
        return (float)massIndex / this.rescalingConstant;
    }

    @Override
    public ArrayList<DeNovoGraph.Edge<NominalMass>> getEdges(NominalMass curNode) {
        return (ArrayList)this.edgeMap.get(curNode);
    }

    @Override
    public NominalMass getPreviousNode(NominalMass curNode, AminoAcid aa) {
        int index = curNode.getNominalMass() - aa.getNominalMass();
        if (index < 0) {
            return null;
        }
        return this.factory[index];
    }

    @Override
    public NominalMass getNextNode(NominalMass curNode, AminoAcid aa) {
        int index = curNode.getNominalMass() + aa.getNominalMass();
        if (this.factory[index] == null) {
            this.factory[index] = new NominalMass(index);
        }
        return this.factory[index];
    }

    @Override
    public NominalMass getComplementNode(NominalMass srm, NominalMass pmNode) {
        int index = pmNode.getNominalMass() - srm.getNominalMass();
        if (this.factory[index] != null) {
            return this.factory[index];
        }
        return new NominalMass(index);
    }

    @Override
    public ArrayList<NominalMass> getNodes(float peptideMass, Tolerance tolerance) {
        ArrayList<NominalMass> nodes = new ArrayList<NominalMass>();
        float tolDa = tolerance.getToleranceAsDa(peptideMass);
        int minIndex = this.getMassIndex(peptideMass - tolDa);
        int maxIndex = this.getMassIndex(peptideMass + tolDa);
        for (int index = minIndex; index <= maxIndex; ++index) {
            if (this.factory[index] != null) {
                nodes.add(this.factory[index]);
                continue;
            }
            nodes.add(new NominalMass(index));
        }
        return nodes;
    }

    @Override
    public NominalMass getNode(float peptideMass) {
        int index = this.getMassIndex(peptideMass);
        if (this.factory[index] != null) {
            return this.factory[index];
        }
        return new NominalMass(index);
    }

    @Override
    public NominalMass getZero() {
        return this.zero;
    }

    @Override
    public boolean contains(NominalMass node) {
        int index = node.getNominalMass();
        if (index < 0 || index >= this.factory.length) {
            return false;
        }
        return this.factory[index] != null;
    }

    public static NominalMass getInstanceFor(float mass) {
        return defaultNominalMassFactory.getInstance(mass);
    }
}

