/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf.test;

import edu.ucsd.msjava.msdbsearch.DBScanner;
import edu.ucsd.msjava.msgf.GeneratingFunction;
import edu.ucsd.msjava.msgf.GenericDeNovoGraph;
import edu.ucsd.msjava.msgf.IntMassFactory;
import edu.ucsd.msjava.msgf.NominalMass;
import edu.ucsd.msjava.msgf.NominalMassFactory;
import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msscorer.NewRankScorer;
import edu.ucsd.msjava.msscorer.NewScoredSpectrum;
import edu.ucsd.msjava.msscorer.NewScorerFactory;
import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Annotation;
import edu.ucsd.msjava.msutil.Enzyme;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.msutil.SpectraMap;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.parser.InsPecTPSM;
import edu.ucsd.msjava.parser.InsPecTParser;
import edu.ucsd.msjava.parser.MgfSpectrumParser;
import edu.ucsd.msjava.parser.PSMList;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class MSGFTest {
    public static void main(String[] argv) throws Exception {
        MSGFTest.dicTest();
    }

    @Deprecated
    public static void dicTest() throws Exception {
        File specFile = new File("/home/sangtaekim/Research/Data/Zubarev/SACTest/SACTest.mgf");
        SpectraMap specAccessor = new SpectraMap(specFile.getPath(), new MgfSpectrumParser());
        int scanNum = 3888;
        Spectrum spec = specAccessor.getSpectrumBySpecIndex(scanNum);
        Enzyme enzyme = Enzyme.TRYPSIN;
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        DBScanner.setAminoAcidProbabilities("/home/sangtaekim/Research/Data/CommonContaminants/IPI_human_3.79_withContam.fasta", aaSet);
        aaSet.registerEnzyme(enzyme);
        NewRankScorer scorer = NewScorerFactory.get(ActivationMethod.HCD, enzyme);
        Annotation annotation = new Annotation(MSGFTest.getAnnotationStr("R.TPEVTCVVVDVSHEDPEVQFK.W"), aaSet);
        NewScoredSpectrum scoredSpec1 = scorer.getScoredSpectrum(spec);
        NominalMassFactory factory = new NominalMassFactory(aaSet, enzyme, 50);
        Tolerance pmTolerance = Tolerance.ZERO_TOLERANCE;
        GenericDeNovoGraph<NominalMass> graph = new GenericDeNovoGraph<NominalMass>(factory, spec.getPrecursorMass(), pmTolerance, enzyme, scoredSpec1);
        GeneratingFunction<NominalMass> gf = new GeneratingFunction<NominalMass>(graph).enzyme(enzyme).doNotCalcNumber();
        gf.computeGeneratingFunction();
        int score = gf.getScore(annotation);
        double specProb = gf.getSpectralProbability(score);
        System.out.println(scanNum + "\t" + annotation + " " + (gf.getMaxScore() - 1) + " " + score + " " + specProb);
        for (int t = score; t < gf.getMaxScore(); ++t) {
            System.out.println(t + "\t" + gf.getScoreDist().getProbability(t));
        }
        System.out.println("SpecProb from Dictionary");
        ArrayList<String> dictionary = gf.getReconstructionsEqualOrAboveScore(score);
        float specProb2 = 0.0f;
        HashMap<Integer, Float> scoreMap = new HashMap<Integer, Float>();
        for (int t = score; t < gf.getMaxScore(); ++t) {
            scoreMap.put(t, Float.valueOf(0.0f));
        }
        for (String pep : dictionary) {
            int t = gf.getScore(new Annotation(MSGFTest.getAnnotationStr(pep), aaSet));
            float prob = MSGFTest.getProbability(pep, aaSet);
            scoreMap.put(t, Float.valueOf(((Float)scoreMap.get(t)).floatValue() + prob));
            System.out.println(pep + "\t" + prob + "\t" + t + "\t" + (specProb2 += prob));
        }
        System.out.println("SpecProb2\t" + specProb2 + "\t" + dictionary.size());
        for (int t = score; t < gf.getMaxScore(); ++t) {
            System.out.println(t + "\t" + scoreMap.get(t));
        }
    }

    public static float getProbability(String annotationStr, AminoAcidSet aaSet) {
        float prob = 1.0f;
        char aaBefore = annotationStr.charAt(0);
        prob = aaBefore == 'K' || aaBefore == 'R' || !Character.isLetter(aaBefore) ? (prob *= aaSet.getAminoAcid('K').getProbability() + aaSet.getAminoAcid('R').getProbability()) : (prob *= 1.0f - (aaSet.getAminoAcid('K').getProbability() + aaSet.getAminoAcid('R').getProbability()));
        String pepStr = annotationStr.substring(annotationStr.indexOf(46) + 1);
        for (int i = 0; i < pepStr.length(); ++i) {
            char c = pepStr.charAt(i);
            if (!Character.isLetter(c)) continue;
            prob *= aaSet.getAminoAcid(Character.toUpperCase(c)).getProbability();
        }
        return prob;
    }

    public static String getAnnotationStr(String annotationStr) {
        String retStr = null;
        retStr = annotationStr.replaceAll("E-18\\.011", "e");
        retStr = retStr.replaceAll("Q-17\\.027", "q");
        retStr = retStr.replaceAll("M\\+15\\.995", "m");
        if (annotationStr.charAt(annotationStr.length() - 2) != '.') {
            return retStr + ".A";
        }
        return retStr;
    }

    @Deprecated
    public static void msgfTest() throws Exception {
        File specFile = new File(System.getProperty("user.home") + "/Research/Data/ISBControl/Mix_7/ORBITRAP/mgf/ISB02_mAB_ChymoTryp_Tryp.mgf");
        SpectraMap specAccessor = new SpectraMap(specFile.getPath(), new MgfSpectrumParser());
        File resultFile = new File(System.getProperty("user.home") + "/Research/Data/TDATest/MSGFDBv2/MSGFDB_S10_Target_New.txt");
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        InsPecTParser parser = new InsPecTParser(aaSet);
        parser.parse(resultFile.getPath());
        int maxLength = 40;
        float rescalingFactor = 0.999497f;
        rescalingFactor = 274.3352f;
        Tolerance pmTolerance = Tolerance.ZERO_TOLERANCE;
        pmTolerance = new Tolerance(30.0f, true);
        Enzyme enzyme = Enzyme.TRYPSIN;
        IntMassFactory factory = new IntMassFactory(aaSet, enzyme, maxLength, rescalingFactor);
        NewRankScorer scorer = NewScorerFactory.get(ActivationMethod.CID, enzyme);
        String header = parser.getHeader();
        PSMList<InsPecTPSM> psmList = parser.getPSMList();
        for (InsPecTPSM psm : psmList) {
            if (psm.getScanNum() != 7400) continue;
            Spectrum spec = specAccessor.getSpectrumBySpecIndex(psm.getScanNum());
            NewScoredSpectrum scoredSpec = scorer.getScoredSpectrum(spec);
            GenericDeNovoGraph<IntMassFactory.IntMass> graph = new GenericDeNovoGraph<IntMassFactory.IntMass>(factory, spec.getPrecursorMass(), pmTolerance, enzyme, scoredSpec);
            GeneratingFunction<IntMassFactory.IntMass> gf = new GeneratingFunction<IntMassFactory.IntMass>(graph).enzyme(enzyme);
            gf.computeGeneratingFunction();
            double specProb = gf.getSpectralProbability(psm.getAnnotation());
            int score = gf.getScore(psm.getAnnotation());
            int msgfScore = gf.getScore(psm.getAnnotation());
            ArrayList<String> dictionary = gf.getReconstructionsEqualOrAboveScore(msgfScore);
            System.out.println(psm.getAnnotation() + "\t" + msgfScore + "\t" + (gf.getMaxScore() - 1));
            float sumProb = 0.0f;
            for (String annotationStr : dictionary) {
                if (enzyme == null) {
                    annotationStr = "." + annotationStr;
                }
                Annotation annotation = new Annotation(annotationStr + ".A", aaSet);
                Peptide pep = annotation.getPeptide();
                float prob = pep.getProbability();
                if (enzyme != null) {
                    prob = annotation.toString().startsWith("R.") ? (prob *= aaSet.getProbCleavageSites()) : (prob *= 1.0f - aaSet.getProbCleavageSites());
                }
                System.out.println(annotationStr + "\t" + prob + "\t" + (sumProb += prob) + "\t" + gf.getScore(annotation) + "\t" + (pep.getMass() - spec.getPrecursorMass() + 18.010565f));
            }
            System.out.println("SpecProb\t" + specProb + "\t" + sumProb);
        }
    }
}

