/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf2d;

import edu.ucsd.msjava.msgf.DeNovoGraph;
import edu.ucsd.msjava.msgf2d.BacktrackPointer2D;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Matter;
import edu.ucsd.msjava.suffixarray.SuffixArray;
import java.util.ArrayList;
import java.util.Hashtable;

public class BacktrackTable2D<T extends Matter>
extends Hashtable<T, BacktrackPointer2D> {
    private static final long serialVersionUID = 1L;
    DeNovoGraph<T> graph;
    AminoAcidSet aaSet;

    public BacktrackTable2D(DeNovoGraph<T> graph, AminoAcidSet aaSet) {
        this.graph = graph;
        this.aaSet = aaSet;
    }

    public void getReconstructions(T curNode, int score1, int score2, String prefix, ArrayList<String> reconstructions) {
        this.getReconstructions(curNode, score1, score2, prefix, reconstructions, null);
    }

    public void getReconstructions(T curNode, int score1, int score2, String prefix, ArrayList<String> reconstructions, SuffixArray sa) {
        if (sa != null && sa.search(prefix) < 0) {
            return;
        }
        BacktrackPointer2D pointer = (BacktrackPointer2D)this.get(curNode);
        if (pointer == null) {
            return;
        }
        if (score1 >= pointer.getMaxScore1() || score2 >= pointer.getMaxScore2()) {
            return;
        }
        assert (pointer != null);
        if (((Matter)curNode).equals(this.graph.getSource())) {
            reconstructions.add(prefix);
            return;
        }
        for (DeNovoGraph.Edge<T> edge : this.graph.getEdges(curNode)) {
            T prevNode = edge.getPrevNode();
            int edgeIndex = edge.getEdgeIndex();
            if (!pointer.isSet(score1, score2, edgeIndex)) continue;
            this.getReconstructions(prevNode, score1 - pointer.getCurScore1(), score2 - pointer.getCurScore2(), prefix + this.aaSet.getAminoAcid(edgeIndex).getResidueStr(), reconstructions, sa);
        }
    }

    public String getOneReconstruction(T curNode, int score1, int score2, String prefix) {
        BacktrackPointer2D pointer = (BacktrackPointer2D)this.get(curNode);
        if (pointer == null) {
            return null;
        }
        if (score1 >= pointer.getMaxScore1() || score2 >= pointer.getMaxScore2()) {
            return null;
        }
        assert (pointer != null);
        if (((Matter)curNode).equals(this.graph.getSource())) {
            return prefix;
        }
        for (DeNovoGraph.Edge<T> edge : this.graph.getEdges(curNode)) {
            T prevNode = edge.getPrevNode();
            int edgeIndex = edge.getEdgeIndex();
            if (!pointer.isSet(score1, score2, edgeIndex)) continue;
            this.getOneReconstruction(prevNode, score1 - pointer.getCurScore1(), score2 - pointer.getCurScore2(), prefix + this.aaSet.getAminoAcid(edgeIndex).getResidueStr());
        }
        return null;
    }
}

