/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf2d;

import edu.ucsd.msjava.msgf2d.ScoreDist2D;

public class ScoreDistMerged {
    private ScoreDist2D dist2D;
    private float[][] numPeptidesWithBetterScores;
    private float[][] specProbWithBetterScores;
    private float[][] numPeptidesBetterScore1;
    private float[][] probBetterScore1;
    private float[] specProb1;
    private float[] specProb2;
    private float[] numBetter1;
    private float[] numBetter2;
    private float[][] numPeptidesBetterScore2;
    private float[][] probBetterScore2;
    private int minScore1;
    private int minScore2;
    private int maxScore1;
    private int maxScore2;
    private float[][] specProbMerged;
    private float[][] numBetterPeptidesMerged;

    public ScoreDistMerged(ScoreDist2D dist2D) {
        this.dist2D = dist2D;
        this.minScore1 = dist2D.scoreBound1.getMinScore();
        this.minScore2 = dist2D.scoreBound2.getMinScore();
        this.maxScore1 = dist2D.scoreBound1.getMaxScore() - 1;
        this.maxScore2 = dist2D.scoreBound2.getMaxScore() - 1;
        this.initBothBetter();
    }

    public int getMaxScore1() {
        return this.dist2D.getMaxScore1();
    }

    public int getMaxScore2() {
        return this.dist2D.getMaxScore2();
    }

    public int getMinScore1() {
        return this.dist2D.getMinScore1();
    }

    public int getMinScore2() {
        return this.dist2D.getMinScore2();
    }

    public float getProbabilityAt(int score1, int score2) {
        return this.dist2D.getProbability(score1, score2);
    }

    public float getNumRecsAt(int score1, int score2) {
        return this.dist2D.getNumRecs(score1, score2);
    }

    public float getNumBetterBoth(int score1, int score2) {
        return this.numPeptidesWithBetterScores[score1 - this.minScore1][score2 - this.minScore2];
    }

    public float getProbBetterBoth(int score1, int score2) {
        return this.specProbWithBetterScores[score1 - this.minScore1][score2 - this.minScore2];
    }

    public float getNumEqualOrBetterPeptides1(int score1) {
        int index1 = score1 - this.minScore1;
        float numRecs = 0.0f;
        for (int score2 = this.dist2D.getMinScore2(); score2 < this.dist2D.getMaxScore2(); ++score2) {
            numRecs += this.numPeptidesBetterScore1[index1][score2 - this.minScore2];
        }
        return numRecs;
    }

    public float getSpectralProbability1(int score1) {
        int index1 = score1 - this.minScore1;
        if (score1 < this.minScore1) {
            return 1.0f;
        }
        if (score1 > this.maxScore1) {
            return 0.0f;
        }
        return this.specProb1[index1];
    }

    public float getNumEqualOrBetterPeptides2(int score2) {
        int index2 = score2 - this.minScore2;
        float numRecs = 0.0f;
        for (int score1 = this.dist2D.getMinScore1(); score1 < this.dist2D.getMaxScore1(); ++score1) {
            numRecs += this.numPeptidesBetterScore2[score1 - this.minScore1][index2];
        }
        return numRecs;
    }

    public float getSpectralProbability2(int score2) {
        int index2 = score2 - this.minScore2;
        if (score2 < this.minScore2) {
            return 1.0f;
        }
        if (score2 > this.maxScore2) {
            return 0.0f;
        }
        return this.specProb2[index2];
    }

    public float getNumEqualOrBetterPeptides(int score1, int score2) {
        float combinedSpecProb;
        int t1;
        float numBetter = 0.0f;
        int index1 = score1 - this.minScore1;
        int index2 = score2 - this.minScore2;
        numBetter += this.numPeptidesWithBetterScores[index1][index2];
        float curCombinedSpecProb = this.specProb1[index1] * this.specProb2[index2];
        int t2 = this.maxScore2;
        for (t1 = this.minScore1; t1 < score1; ++t1) {
            while (t2 >= score2 && !((combinedSpecProb = this.specProb1[t1 - this.minScore1] * this.specProb2[t2 - this.minScore2]) > curCombinedSpecProb)) {
                --t2;
            }
            if (t2 + 1 > this.maxScore2) continue;
            numBetter += this.numPeptidesBetterScore2[t1 - this.minScore1][t2 + 1 - this.minScore2];
        }
        t1 = this.maxScore1;
        for (t2 = this.minScore2; t2 < score2; ++t2) {
            while (t1 >= score1 && !((combinedSpecProb = this.specProb1[t1 - this.minScore1] * this.specProb2[t2 - this.minScore2]) > curCombinedSpecProb)) {
                --t1;
            }
            if (t1 + 1 > this.maxScore1) continue;
            numBetter += this.numPeptidesBetterScore1[t1 + 1 - this.minScore1][t2 - this.minScore2];
        }
        return numBetter;
    }

    public float getSpectralProbability(int score1, int score2) {
        float combinedSpecProb;
        int t1;
        float specProb = 0.0f;
        int index1 = score1 - this.minScore1;
        int index2 = score2 - this.minScore2;
        specProb += this.specProbWithBetterScores[index1][index2];
        float curCombinedSpecProb = this.specProb1[index1] * this.specProb2[index2];
        int t2 = this.maxScore2;
        for (t1 = this.minScore1; t1 < score1; ++t1) {
            while (t2 >= score2 && !((combinedSpecProb = this.specProb1[t1 - this.minScore1] * this.specProb2[t2 - this.minScore2]) > curCombinedSpecProb)) {
                --t2;
            }
            if (t2 + 1 > this.maxScore2) continue;
            specProb += this.probBetterScore2[t1 - this.minScore1][t2 + 1 - this.minScore2];
        }
        t1 = this.maxScore1;
        for (t2 = this.minScore2; t2 < score2; ++t2) {
            while (t1 >= score1 && !((combinedSpecProb = this.specProb1[t1 - this.minScore1] * this.specProb2[t2 - this.minScore2]) > curCombinedSpecProb)) {
                --t1;
            }
            if (t1 + 1 > this.maxScore1) continue;
            specProb += this.probBetterScore1[t1 + 1 - this.minScore1][t2 - this.minScore2];
        }
        return specProb;
    }

    public float getNumEqualOrBetterPeptidesNumBetterPeptides(int score1, int score2) {
        float numRecs;
        int t1;
        float numBetter = 0.0f;
        int index1 = score1 - this.minScore1;
        int index2 = score2 - this.minScore2;
        float curNumRecs = this.numPeptidesWithBetterScores[index1][index2];
        numBetter += curNumRecs;
        int t2 = this.maxScore2;
        for (t1 = this.minScore1; t1 < score1; ++t1) {
            while (t2 >= score2 && !((numRecs = this.numPeptidesWithBetterScores[t1 - this.minScore1][t2 - this.minScore2]) > curNumRecs)) {
                --t2;
            }
            if (t2 + 1 > this.maxScore2) continue;
            numBetter += this.numPeptidesBetterScore2[t1 - this.minScore1][t2 + 1 - this.minScore2];
        }
        t1 = this.maxScore1;
        for (t2 = this.minScore2; t2 < score2; ++t2) {
            while (t1 >= score1 && !((numRecs = this.numPeptidesWithBetterScores[t1 - this.minScore1][t2 - this.minScore2]) > curNumRecs)) {
                --t1;
            }
            if (t1 + 1 > this.maxScore1) continue;
            numBetter += this.numPeptidesBetterScore1[t1 + 1 - this.minScore1][t2 - this.minScore2];
        }
        return numBetter;
    }

    public float getSpectralProbabilityNumBetterPeptides(int score1, int score2) {
        float numRecs;
        int t1;
        float specProb = 0.0f;
        int index1 = score1 - this.minScore1;
        int index2 = score2 - this.minScore2;
        specProb += this.specProbWithBetterScores[index1][index2];
        float curNumRecs = this.numPeptidesWithBetterScores[index1][index2];
        int t2 = this.maxScore2;
        for (t1 = this.minScore1; t1 < score1; ++t1) {
            while (t2 >= score2 && !((numRecs = this.numPeptidesWithBetterScores[t1 - this.minScore1][t2 - this.minScore2]) > curNumRecs)) {
                --t2;
            }
            if (t2 + 1 > this.maxScore2) continue;
            specProb += this.probBetterScore2[t1 - this.minScore1][t2 + 1 - this.minScore2];
        }
        t1 = this.maxScore1;
        for (t2 = this.minScore2; t2 < score2; ++t2) {
            while (t1 >= score1 && !((numRecs = this.numPeptidesWithBetterScores[t1 - this.minScore1][t2 - this.minScore2]) > curNumRecs)) {
                --t1;
            }
            if (t1 + 1 > this.maxScore1) continue;
            specProb += this.probBetterScore1[t1 + 1 - this.minScore1][t2 - this.minScore2];
        }
        return specProb;
    }

    public float getNumEqualOrBetterPeptidesSumScores(int score1, int score2) {
        float numRecs = 0.0f;
        int sumScore = score1 + score2;
        for (int s1 = this.minScore1; s1 <= this.maxScore1; ++s1) {
            int s2 = sumScore - s1;
            if (s2 < this.minScore2 || s2 > this.maxScore2) continue;
            numRecs += this.numPeptidesBetterScore1[s1 - this.minScore1][s2 - this.minScore2];
        }
        return numRecs;
    }

    public float getSpectralProbabilitySumScores(int score1, int score2) {
        float specProb = 0.0f;
        int sumScore = score1 + score2;
        for (int s1 = this.minScore1; s1 <= this.maxScore1; ++s1) {
            int s2 = sumScore - s1;
            if (s2 < this.minScore2 || s2 > this.maxScore2) continue;
            specProb += this.probBetterScore1[s1 - this.minScore1][s2 - this.minScore2];
        }
        return specProb;
    }

    private void initBothBetter() {
        int t;
        this.numPeptidesWithBetterScores = new float[this.maxScore1 - this.minScore1 + 1][this.maxScore2 - this.minScore2 + 1];
        this.specProbWithBetterScores = new float[this.maxScore1 - this.minScore1 + 1][this.maxScore2 - this.minScore2 + 1];
        this.numPeptidesBetterScore1 = new float[this.maxScore1 - this.minScore1 + 1][this.maxScore2 - this.minScore2 + 1];
        this.probBetterScore1 = new float[this.maxScore1 - this.minScore1 + 1][this.maxScore2 - this.minScore2 + 1];
        this.numPeptidesBetterScore2 = new float[this.maxScore1 - this.minScore1 + 1][this.maxScore2 - this.minScore2 + 1];
        this.probBetterScore2 = new float[this.maxScore1 - this.minScore1 + 1][this.maxScore2 - this.minScore2 + 1];
        int maxSumScore = this.maxScore1 + this.maxScore2;
        for (int energy = 0; energy <= this.maxScore1 + this.maxScore2 - this.minScore1 - this.minScore2; ++energy) {
            for (int score1 = Math.max(maxSumScore - energy - this.maxScore2, this.minScore1); score1 <= this.maxScore1 && score1 <= maxSumScore - this.minScore2 - energy; ++score1) {
                int score2 = maxSumScore - score1 - energy;
                int index1 = score1 - this.minScore1;
                int index2 = score2 - this.minScore2;
                if (score1 + 1 < this.dist2D.getMaxScore1() && score2 + 1 < this.dist2D.getMaxScore2()) {
                    float[] fArray = this.numPeptidesWithBetterScores[index1];
                    int n = index2;
                    fArray[n] = fArray[n] + this.numPeptidesWithBetterScores[index1 + 1][index2 + 1];
                    float[] fArray2 = this.specProbWithBetterScores[index1];
                    int n2 = index2;
                    fArray2[n2] = fArray2[n2] + this.specProbWithBetterScores[index1 + 1][index2 + 1];
                }
                if (score1 + 1 < this.dist2D.getMaxScore1()) {
                    float[] fArray = this.numPeptidesWithBetterScores[index1];
                    int n = index2;
                    fArray[n] = fArray[n] + this.numPeptidesBetterScore1[index1 + 1][index2];
                    float[] fArray3 = this.specProbWithBetterScores[index1];
                    int n3 = index2;
                    fArray3[n3] = fArray3[n3] + this.probBetterScore1[index1 + 1][index2];
                    float[] fArray4 = this.numPeptidesBetterScore1[index1];
                    int n4 = index2;
                    fArray4[n4] = fArray4[n4] + this.numPeptidesBetterScore1[index1 + 1][index2];
                    float[] fArray5 = this.probBetterScore1[index1];
                    int n5 = index2;
                    fArray5[n5] = fArray5[n5] + this.probBetterScore1[index1 + 1][index2];
                }
                if (score2 + 1 < this.dist2D.getMaxScore2()) {
                    float[] fArray = this.numPeptidesWithBetterScores[index1];
                    int n = index2;
                    fArray[n] = fArray[n] + this.numPeptidesBetterScore2[index1][index2 + 1];
                    float[] fArray6 = this.specProbWithBetterScores[index1];
                    int n6 = index2;
                    fArray6[n6] = fArray6[n6] + this.probBetterScore2[index1][index2 + 1];
                    float[] fArray7 = this.numPeptidesBetterScore2[index1];
                    int n7 = index2;
                    fArray7[n7] = fArray7[n7] + this.numPeptidesBetterScore2[index1][index2 + 1];
                    float[] fArray8 = this.probBetterScore2[index1];
                    int n8 = index2;
                    fArray8[n8] = fArray8[n8] + this.probBetterScore2[index1][index2 + 1];
                }
                float curNumRecs = this.dist2D.getNumRecs(score1, score2);
                float[] fArray = this.numPeptidesWithBetterScores[index1];
                int n = index2;
                fArray[n] = fArray[n] + curNumRecs;
                float[] fArray9 = this.numPeptidesBetterScore1[index1];
                int n9 = index2;
                fArray9[n9] = fArray9[n9] + curNumRecs;
                float[] fArray10 = this.numPeptidesBetterScore2[index1];
                int n10 = index2;
                fArray10[n10] = fArray10[n10] + curNumRecs;
                float curProb = this.dist2D.getProbability(score1, score2);
                float[] fArray11 = this.specProbWithBetterScores[index1];
                int n11 = index2;
                fArray11[n11] = fArray11[n11] + curProb;
                float[] fArray12 = this.probBetterScore1[index1];
                int n12 = index2;
                fArray12[n12] = fArray12[n12] + curProb;
                float[] fArray13 = this.probBetterScore2[index1];
                int n13 = index2;
                fArray13[n13] = fArray13[n13] + curProb;
            }
        }
        this.specProb1 = new float[this.maxScore1 - this.minScore1 + 1];
        for (t = this.maxScore1; t >= this.minScore1; --t) {
            this.specProb1[t - this.minScore1] = this.probBetterScore2[t - this.minScore1][0];
            if (t + 1 > this.maxScore1) continue;
            int n = t - this.minScore1;
            this.specProb1[n] = this.specProb1[n] + this.specProb1[t + 1 - this.minScore1];
        }
        this.specProb2 = new float[this.maxScore2 - this.minScore2 + 1];
        for (t = this.maxScore2; t >= this.minScore2; --t) {
            this.specProb2[t - this.minScore2] = this.probBetterScore1[0][t - this.minScore2];
            if (t + 1 > this.maxScore2) continue;
            int n = t - this.minScore2;
            this.specProb2[n] = this.specProb2[n] + this.specProb2[t + 1 - this.minScore2];
        }
    }

    protected void initMerged() {
        this.numBetterPeptidesMerged = new float[this.maxScore1 - this.minScore1 + 1][this.maxScore2 - this.minScore2 + 1];
        this.specProbMerged = new float[this.maxScore1 - this.minScore1 + 1][this.maxScore2 - this.minScore2 + 1];
        this.numBetterPeptidesMerged[this.dist2D.getMaxScore1() - 1 - this.minScore1][this.dist2D.getMaxScore2() - 1 - this.minScore2] = this.dist2D.getNumRecs(this.dist2D.getMaxScore1() - 1, this.dist2D.getMaxScore2() - 1);
        this.specProbMerged[this.dist2D.getMaxScore1() - 1 - this.minScore1][this.dist2D.getMaxScore2() - 1 - this.minScore2] = this.dist2D.getProbability(this.dist2D.getMaxScore1() - 1, this.dist2D.getMaxScore2() - 1);
        int minScore1 = this.dist2D.getMinScore1();
        int minScore2 = this.dist2D.getMinScore2();
        int maxScore1 = this.dist2D.getMaxScore1() - 1;
        int maxScore2 = this.dist2D.getMaxScore2() - 1;
        int maxSumScore = this.dist2D.getMaxScore1() + this.dist2D.getMaxScore2() - 2;
        for (int energy = 1; energy < this.dist2D.getMaxScore1() + this.dist2D.getMaxScore2() - 1; ++energy) {
            for (int score1 = Math.max(maxSumScore - energy - maxScore2, minScore1); score1 <= maxScore1 && score1 <= maxSumScore - minScore2 - energy; ++score1) {
                float numRecs;
                int t1;
                int score2 = maxSumScore - score1 - energy;
                int index1 = score1 - minScore1;
                int index2 = score2 - minScore2;
                float[] fArray = this.numBetterPeptidesMerged[index1];
                int n = index2;
                fArray[n] = fArray[n] + this.numPeptidesWithBetterScores[index1][index2];
                float[] fArray2 = this.specProbMerged[index1];
                int n2 = index2;
                fArray2[n2] = fArray2[n2] + this.specProbWithBetterScores[index1][index2];
                float curNumRecs = this.numPeptidesWithBetterScores[index1][index2];
                int t2 = maxScore2;
                for (t1 = minScore1; t1 < score1; ++t1) {
                    while (t2 >= score2 && !((numRecs = this.numPeptidesWithBetterScores[t1 - minScore1][t2 - minScore2]) > curNumRecs)) {
                        --t2;
                    }
                    if (t2 + 1 > maxScore2) continue;
                    float[] fArray3 = this.numBetterPeptidesMerged[index1];
                    int n3 = index2;
                    fArray3[n3] = fArray3[n3] + this.numPeptidesBetterScore2[t1 - minScore1][t2 + 1 - minScore2];
                    float[] fArray4 = this.specProbMerged[index1];
                    int n4 = index2;
                    fArray4[n4] = fArray4[n4] + this.probBetterScore1[t1 - minScore1][t2 + 1 - minScore2];
                }
                t1 = maxScore1;
                for (t2 = minScore2; t2 < score2; ++t2) {
                    while (t1 >= score1 && !((numRecs = this.numPeptidesWithBetterScores[t1 - minScore1][t2 - minScore2]) > curNumRecs)) {
                        --t1;
                    }
                    if (t1 + 1 > maxScore1) continue;
                    float[] fArray5 = this.numBetterPeptidesMerged[index1];
                    int n5 = index2;
                    fArray5[n5] = fArray5[n5] + this.numPeptidesBetterScore1[t1 + 1 - minScore1][t2 - minScore2];
                    float[] fArray6 = this.specProbMerged[index1];
                    int n6 = index2;
                    fArray6[n6] = fArray6[n6] + this.probBetterScore1[t1 + 1 - minScore1][t2 - minScore2];
                }
            }
        }
    }
}

