/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msscorer;

import edu.ucsd.msjava.msgf.NominalMass;
import edu.ucsd.msjava.msscorer.FastScorer;
import edu.ucsd.msjava.msscorer.NewRankScorer;
import edu.ucsd.msjava.msscorer.NewScoredSpectrum;
import edu.ucsd.msjava.msscorer.Partition;

public class DBScanScorer
extends FastScorer {
    private float[] nodeMass = null;
    private NewRankScorer scorer = null;
    private Partition partition;
    private float probPeak;
    private boolean isNodeMassPRM;

    public DBScanScorer(NewScoredSpectrum<NominalMass> scoredSpec, int peptideMass) {
        super(scoredSpec, peptideMass);
        this.scorer = scoredSpec.getScorer();
        this.nodeMass = new float[peptideMass];
        for (int i = 0; i < this.nodeMass.length; ++i) {
            this.nodeMass[i] = -1.0f;
        }
        this.isNodeMassPRM = scoredSpec.getMainIonDirection();
        this.nodeMass[0] = 0.0f;
        for (int nominalMass = 1; nominalMass < this.nodeMass.length; ++nominalMass) {
            this.nodeMass[nominalMass] = scoredSpec.getNodeMass(new NominalMass(nominalMass));
        }
        this.partition = scoredSpec.getPartition();
        this.probPeak = scoredSpec.getProbPeak();
    }

    @Override
    public int getScore(double[] prefixMassArr, int[] nominalPrefixMassArr, int fromIndex, int toIndex, int numMods) {
        int nodeScore = super.getScore(prefixMassArr, nominalPrefixMassArr, fromIndex, toIndex, numMods);
        int edgeScore = 0;
        if (!this.isNodeMassPRM) {
            int nominalPeptideMass = nominalPrefixMassArr[toIndex - 1];
            for (int i = toIndex - 2; i >= fromIndex; --i) {
                edgeScore += this.getEdgeScoreInt(nominalPeptideMass - nominalPrefixMassArr[i], nominalPeptideMass - nominalPrefixMassArr[i + 1], (float)(prefixMassArr[i + 1] - prefixMassArr[i]));
            }
        } else {
            for (int i = fromIndex; i <= toIndex - 2; ++i) {
                edgeScore += this.getEdgeScoreInt(nominalPrefixMassArr[i], nominalPrefixMassArr[i - 1], (float)(prefixMassArr[i] - prefixMassArr[i - 1]));
            }
        }
        return nodeScore + edgeScore;
    }

    @Override
    public int getEdgeScore(NominalMass curNode, NominalMass prevNode, float theoMass) {
        return this.getEdgeScoreInt(curNode.getNominalMass(), prevNode.getNominalMass(), theoMass);
    }

    private int getEdgeScoreInt(int curNominalMass, int prevNominalMass, float theoMass) {
        float prevMass;
        if (curNominalMass >= this.nodeMass.length || prevNominalMass >= this.nodeMass.length || curNominalMass < 0 || prevNominalMass < 0) {
            return 0;
        }
        int ionExistenceIndex = 0;
        float curMass = this.nodeMass[curNominalMass];
        if (curMass >= 0.0f) {
            ++ionExistenceIndex;
        }
        if ((prevMass = this.nodeMass[prevNominalMass]) >= 0.0f) {
            ionExistenceIndex += 2;
        }
        float edgeScore = this.scorer.getIonExistenceScore(this.partition, ionExistenceIndex, this.probPeak);
        if (ionExistenceIndex == 3) {
            edgeScore += this.scorer.getErrorScore(this.partition, curMass - prevMass - theoMass);
        }
        return Math.round(edgeScore);
    }
}

