/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msscorer;

import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msutil.IonType;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.msutil.Reshape;
import edu.ucsd.msjava.msutil.Spectrum;
import java.util.HashSet;
import java.util.Iterator;

public class IonProbability {
    private Iterator<Spectrum> itr;
    private Reshape filter;
    private IonType[] ions;
    private Tolerance tol;
    private boolean onePerPep = false;
    private int numAllSegments = 1;
    private int targetSegment = 0;

    public IonProbability(Iterator<Spectrum> itr, IonType[] ions, Tolerance tol) {
        this.itr = itr;
        this.ions = ions;
        this.tol = tol;
    }

    public IonProbability segment(int targetSegment, int numAllSegments) {
        this.numAllSegments = numAllSegments;
        this.targetSegment = targetSegment;
        return this;
    }

    public IonProbability filter(Reshape filter) {
        this.filter = filter;
        return this;
    }

    public IonProbability onePerPeptide(boolean isOnePerPep) {
        this.onePerPep = isOnePerPep;
        return this;
    }

    public float[] getIonProb() {
        float[] ionProbArr = new float[this.ions.length];
        int[] numObservedPeaks = new int[this.ions.length];
        int[] numMissingPeaks = new int[this.ions.length];
        HashSet<String> pepSet = null;
        if (this.onePerPep) {
            pepSet = new HashSet<String>();
        }
        while (this.itr.hasNext()) {
            Peptide pep;
            Spectrum spec = this.itr.next();
            if (this.filter != null) {
                spec = this.filter.apply(spec);
            }
            if ((pep = spec.getAnnotation()) == null) continue;
            if (this.onePerPep) {
                String pepStr = spec.getAnnotationStr();
                if (pepSet.contains(pepStr)) continue;
                pepSet.add(pepStr);
            }
            int index = -1;
            for (IonType ion : this.ions) {
                int segNum;
                float mz;
                int i;
                ++index;
                if (ion instanceof IonType.PrefixIon) {
                    double prm = 0.0;
                    for (i = 0; i < pep.size() - 1; ++i) {
                        mz = ion.getMz((float)(prm += (double)pep.get(i).getMass()));
                        if (this.numAllSegments > 1) {
                            segNum = (int)(mz / spec.getPrecursorMass() * (float)this.numAllSegments);
                            if (segNum >= this.numAllSegments) {
                                segNum = this.numAllSegments - 1;
                            }
                            if (segNum != this.targetSegment) continue;
                        }
                        if (spec.getPeakByMass(mz, this.tol) != null) {
                            int n = index;
                            numObservedPeaks[n] = numObservedPeaks[n] + 1;
                            continue;
                        }
                        int n = index;
                        numMissingPeaks[n] = numMissingPeaks[n] + 1;
                    }
                    continue;
                }
                double srm = 0.0;
                for (i = 0; i < pep.size() - 1; ++i) {
                    mz = ion.getMz((float)(srm += (double)pep.get(pep.size() - 1 - i).getMass()));
                    if (this.numAllSegments > 1) {
                        segNum = (int)(mz / spec.getPrecursorMass() * (float)this.numAllSegments);
                        if (segNum >= this.numAllSegments) {
                            segNum = this.numAllSegments - 1;
                        }
                        if (segNum != this.targetSegment) continue;
                    }
                    if (spec.getPeakByMass(mz, this.tol) != null) {
                        int n = index;
                        numObservedPeaks[n] = numObservedPeaks[n] + 1;
                        continue;
                    }
                    int n = index;
                    numMissingPeaks[n] = numMissingPeaks[n] + 1;
                }
            }
        }
        for (int i = 0; i < this.ions.length; ++i) {
            ionProbArr[i] = numObservedPeaks[i] + numMissingPeaks[i] <= 1000 ? 0.0f : (float)numObservedPeaks[i] / (float)(numObservedPeaks[i] + numMissingPeaks[i]);
        }
        return ionProbArr;
    }
}

