/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msscorer;

import edu.ucsd.msjava.msgf.Histogram;
import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msscorer.FragmentOffsetFrequency;
import edu.ucsd.msjava.msscorer.NewAdditiveScorer;
import edu.ucsd.msjava.msscorer.NewScoredSpectrum;
import edu.ucsd.msjava.msscorer.NewScorerFactory;
import edu.ucsd.msjava.msscorer.Partition;
import edu.ucsd.msjava.msscorer.PrecursorOffsetFrequency;
import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.Enzyme;
import edu.ucsd.msjava.msutil.InstrumentType;
import edu.ucsd.msjava.msutil.IonType;
import edu.ucsd.msjava.msutil.Matter;
import edu.ucsd.msjava.msutil.Protocol;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.msutil.WindowFilter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class NewRankScorer
implements NewAdditiveScorer {
    public static final int VERSION = 7061;
    public static final String DATE = "12/21/2011";
    protected WindowFilter filter = new WindowFilter(6, 50.0f);
    protected NewScorerFactory.SpecDataType dataType;
    protected int numSegments = 1;
    protected Histogram<Integer> chargeHist = null;
    protected TreeSet<Partition> partitionSet = null;
    protected TreeMap<Integer, ArrayList<PrecursorOffsetFrequency>> precursorOFFMap = null;
    protected Hashtable<Partition, ArrayList<FragmentOffsetFrequency>> fragOFFTable = null;
    protected Hashtable<Partition, ArrayList<FragmentOffsetFrequency>> insignificantFragOFFTable = null;
    protected Hashtable<Partition, Hashtable<IonType, Float[]>> rankDistTable = null;
    protected Tolerance mme = new Tolerance(0.5f);
    protected boolean applyDeconvolution = false;
    protected float deconvolutionErrorTolerance = 0.0f;
    protected int numPrecurOFF = 0;
    protected int maxRank = 0;
    protected int errorScalingFactor = 0;
    protected Hashtable<Partition, Float[]> ionErrDistTable = null;
    protected Hashtable<Partition, Float[]> noiseErrDistTable = null;
    protected Hashtable<Partition, Float[]> ionExistenceTable = null;
    private HashMap<Partition, IonType> mainIonTable;
    private HashMap<Partition, IonType[]> ionTypeTable;

    public NewRankScorer() {
    }

    public NewRankScorer(String paramFileName) {
        this.readFromFile(new File(paramFileName), false);
    }

    public NewRankScorer(InputStream is) {
        this.readFromInputStream(is, false);
    }

    public <T extends Matter> NewScoredSpectrum<T> getScoredSpectrum(Spectrum spec) {
        return new NewScoredSpectrum(spec, this);
    }

    public NewScorerFactory.SpecDataType getSpecDataType() {
        return this.dataType;
    }

    public TreeSet<Partition> getParitionSet() {
        return this.partitionSet;
    }

    public void filterPrecursorPeaks(Spectrum spec) {
        for (PrecursorOffsetFrequency off : this.getPrecursorOFF(spec.getCharge())) {
            spec.filterPrecursorPeaks(this.mme, off.getReducedCharge(), off.getOffset());
        }
    }

    public NewRankScorer mme(Tolerance mme) {
        this.mme = mme;
        return this;
    }

    public boolean applyDeconvolution() {
        return this.applyDeconvolution;
    }

    public float deconvolutionErrorTolerance() {
        return this.deconvolutionErrorTolerance;
    }

    public NewRankScorer doNotUseError() {
        this.errorScalingFactor = 0;
        return this;
    }

    public boolean supportEdgeScores() {
        return this.errorScalingFactor != 0;
    }

    @Override
    public float getNodeScore(Partition part, IonType ionType, int rank) {
        Hashtable<IonType, Float[]> rankTable = this.rankDistTable.get(part);
        assert (rankTable != null);
        int rankIndex = rank > this.maxRank ? this.maxRank - 1 : rank - 1;
        float ionScore = this.getScoreFromTable(rankIndex, rankTable, ionType, false);
        return ionScore;
    }

    @Override
    public float getMissingIonScore(Partition part, IonType ionType) {
        Hashtable<IonType, Float[]> table = this.rankDistTable.get(part);
        assert (table != null);
        int rankIndex = this.maxRank;
        return this.getScoreFromTable(rankIndex, table, ionType, false);
    }

    @Override
    public float getErrorScore(Partition part, float error) {
        int errIndex = Math.round(error * (float)this.errorScalingFactor);
        if (errIndex > this.errorScalingFactor) {
            errIndex = this.errorScalingFactor;
        } else if (errIndex < -this.errorScalingFactor) {
            errIndex = -this.errorScalingFactor;
        }
        Float[] ionErrHist = this.ionErrDistTable.get(part);
        Float[] noiseErrHist = this.noiseErrDistTable.get(part);
        return (float)Math.log(ionErrHist[errIndex += this.errorScalingFactor].floatValue() / noiseErrHist[errIndex].floatValue());
    }

    @Override
    public float getIonExistenceScore(Partition part, int index, float probPeak) {
        Float[] ionExistenceProb = this.ionExistenceTable.get(part);
        float noiseExistenceProb = index == 0 ? (1.0f - probPeak) * (1.0f - probPeak) : (index == 3 ? probPeak * probPeak : probPeak * (1.0f - probPeak));
        if (ionExistenceProb[index].floatValue() == 0.0f) {
            ionExistenceProb[index] = Float.valueOf(0.01f);
        }
        return (float)Math.log(ionExistenceProb[index].floatValue() / noiseExistenceProb);
    }

    private float getScoreFromTable(int index, Hashtable<IonType, Float[]> table, IonType ionType, boolean isError) {
        Float[] frequencies = table.get(ionType);
        assert (frequencies != null) : ionType.getName() + " is not supported!";
        float ionFrequency = frequencies[index].floatValue();
        Float[] noiseFrequencies = table.get(IonType.NOISE);
        assert (noiseFrequencies != null);
        float noiseFrequency = noiseFrequencies[index].floatValue();
        if (!isError) {
            noiseFrequency *= (float)Math.min(ionType.getCharge(), this.numSegments);
        }
        assert (ionFrequency > 0.0f && noiseFrequency > 0.0f) : "Ion frequency must be positive:" + index + " " + ionType.getName() + " " + ionFrequency + " " + noiseFrequency;
        return (float)Math.log(ionFrequency / noiseFrequency);
    }

    public void readFromFile(File paramFile) {
        this.readFromFile(paramFile, false);
    }

    protected void readFromFile(File paramFile, boolean verbose) {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(paramFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.readFromInputStream(is, verbose);
    }

    private void readFromInputStream(InputStream is, boolean verbose) {
        DataInputStream in = new DataInputStream(is);
        try {
            int validation;
            int charge;
            int i;
            Protocol protocol;
            Enzyme enzyme;
            int version = in.readInt();
            if (verbose) {
                System.out.println("Version: " + version);
            }
            StringBuffer bufMet = new StringBuffer();
            byte lenActMethod = in.readByte();
            for (byte i2 = 0; i2 < lenActMethod; i2 = (byte)(i2 + 1)) {
                bufMet.append(in.readChar());
            }
            ActivationMethod activationMethod = ActivationMethod.get(bufMet.toString());
            assert (activationMethod != null);
            StringBuffer bufInst = new StringBuffer();
            byte lenInst = in.readByte();
            for (byte i3 = 0; i3 < lenInst; i3 = (byte)(i3 + 1)) {
                bufInst.append(in.readChar());
            }
            InstrumentType instType = InstrumentType.get(bufInst.toString());
            assert (instType != null);
            StringBuffer bufEnz = new StringBuffer();
            byte lenEnz = in.readByte();
            if (lenEnz != 0) {
                for (byte i4 = 0; i4 < lenEnz; i4 = (byte)(i4 + 1)) {
                    bufEnz.append(in.readChar());
                }
                enzyme = Enzyme.getEnzymeByName(bufEnz.toString());
                assert (instType != null);
            } else {
                enzyme = null;
            }
            StringBuffer bufProtocol = new StringBuffer();
            byte lenProtocol = in.readByte();
            if (lenProtocol != 0) {
                for (byte i5 = 0; i5 < lenProtocol; i5 = (byte)(i5 + 1)) {
                    bufProtocol.append(in.readChar());
                }
                protocol = Protocol.get(bufProtocol.toString());
            } else {
                protocol = Protocol.AUTOMATIC;
            }
            assert (protocol != null);
            this.dataType = new NewScorerFactory.SpecDataType(activationMethod, instType, enzyme, protocol);
            boolean isTolerancePPM = in.readBoolean();
            float mmeVal = in.readFloat();
            this.mme = new Tolerance(mmeVal, isTolerancePPM);
            assert (mmeVal > 0.0f);
            boolean applyDeconvolution = in.readBoolean();
            float deconvolutionErrorTolerance = in.readFloat();
            this.applyDeconvolution = applyDeconvolution;
            this.deconvolutionErrorTolerance = deconvolutionErrorTolerance;
            if (verbose) {
                System.out.println("ChargeHistogram");
            }
            this.chargeHist = new Histogram();
            int minKey = Integer.MAX_VALUE;
            int maxKey = Integer.MIN_VALUE;
            int size = in.readInt();
            for (i = 0; i < size; ++i) {
                charge = in.readInt();
                if (charge < minKey) {
                    minKey = charge;
                }
                if (charge > maxKey) {
                    maxKey = charge;
                }
                int numSpecs = in.readInt();
                if (verbose) {
                    System.out.println(charge + "\t" + numSpecs);
                }
                this.chargeHist.put(charge, numSpecs);
            }
            this.chargeHist.setMinKey(minKey);
            this.chargeHist.setMaxKey(maxKey);
            if (verbose) {
                System.out.println("PartitionInfo");
            }
            this.partitionSet = new TreeSet();
            size = in.readInt();
            this.numSegments = in.readInt();
            for (i = 0; i < size; ++i) {
                charge = in.readInt();
                float parentMass = in.readFloat();
                int segNum = in.readInt();
                this.partitionSet.add(new Partition(charge, parentMass, segNum));
                if (!verbose) continue;
                System.out.println(charge + "\t" + parentMass + "\t" + segNum);
            }
            if (verbose) {
                System.out.println("PrecursorOFF");
            }
            this.precursorOFFMap = new TreeMap();
            this.numPrecurOFF = size = in.readInt();
            for (i = 0; i < size; ++i) {
                charge = in.readInt();
                int reducedCharge = in.readInt();
                float offset = in.readFloat();
                boolean isTolPPM = in.readBoolean();
                float tolVal = in.readFloat();
                float frequency = in.readFloat();
                ArrayList<PrecursorOffsetFrequency> offList = this.precursorOFFMap.get(charge);
                if (offList == null) {
                    offList = new ArrayList();
                    this.precursorOFFMap.put(charge, offList);
                }
                offList.add(new PrecursorOffsetFrequency(reducedCharge, offset, frequency).tolerance(new Tolerance(tolVal, isTolPPM)));
                if (!verbose) continue;
                System.out.println(charge + "\t" + reducedCharge + "\t" + offset + "\t" + new Tolerance(tolVal, isTolPPM).toString() + "\t" + frequency);
            }
            if (verbose) {
                System.out.println("FragmentOFF");
            }
            this.fragOFFTable = new Hashtable();
            for (Partition partition : this.partitionSet) {
                if (verbose) {
                    System.out.println(partition.getCharge() + "\t" + partition.getSegNum() + "\t" + partition.getParentMass());
                }
                ArrayList<FragmentOffsetFrequency> fragmentOFF = new ArrayList<FragmentOffsetFrequency>();
                size = in.readInt();
                for (int i6 = 0; i6 < size; ++i6) {
                    boolean isPrefix = in.readBoolean();
                    int charge2 = in.readInt();
                    float offset = in.readFloat();
                    IonType ionType = isPrefix ? new IonType.PrefixIon("P_" + charge2 + "_" + Math.round(offset), charge2, offset) : new IonType.SuffixIon("S_" + charge2 + "_" + Math.round(offset), charge2, offset);
                    float frequency = in.readFloat();
                    fragmentOFF.add(new FragmentOffsetFrequency(ionType, frequency));
                    if (!verbose) continue;
                    System.out.println(ionType.getName() + "\t" + frequency);
                }
                this.fragOFFTable.put(partition, fragmentOFF);
            }
            this.determineIonTypes();
            this.rankDistTable = new Hashtable();
            this.maxRank = in.readInt();
            if (verbose) {
                System.out.println("RankDistribution," + this.maxRank);
            }
            for (Partition partition : this.partitionSet) {
                if (verbose) {
                    System.out.println(partition.getCharge() + "\t" + partition.getSegNum() + "\t" + partition.getParentMass());
                }
                Hashtable<IonType, Float[]> table = new Hashtable<IonType, Float[]>();
                ArrayList<IonType> ionTypeList = new ArrayList<IonType>();
                IonType[] ionTypes = this.getIonTypes(partition);
                if (ionTypes == null || ionTypes.length == 0) continue;
                for (IonType ion : ionTypes) {
                    ionTypeList.add(ion);
                }
                ionTypeList.add(IonType.NOISE);
                for (IonType ion : ionTypeList) {
                    if (verbose) {
                        System.out.print(ion.getName());
                    }
                    Float[] frequencies = new Float[this.maxRank + 1];
                    for (int i7 = 0; i7 < frequencies.length; ++i7) {
                        frequencies[i7] = Float.valueOf(in.readFloat());
                        if (verbose) {
                            System.out.print("\t" + frequencies[i7]);
                        }
                        assert (frequencies[i7].floatValue() > 0.0f);
                    }
                    table.put(ion, frequencies);
                    if (!verbose) continue;
                    System.out.println();
                }
                this.rankDistTable.put(partition, table);
            }
            this.errorScalingFactor = in.readInt();
            if (this.errorScalingFactor > 0) {
                if (verbose) {
                    System.out.println("ErrorDistribution," + this.errorScalingFactor);
                }
                this.ionErrDistTable = new Hashtable();
                this.noiseErrDistTable = new Hashtable();
                this.ionExistenceTable = new Hashtable();
                for (Partition partition : this.partitionSet) {
                    if (verbose) {
                        System.out.println(partition.getCharge() + "\t" + partition.getSegNum() + "\t" + partition.getParentMass());
                    }
                    Float[] ionErrDist = new Float[this.errorScalingFactor * 2 + 1];
                    for (int i8 = 0; i8 < ionErrDist.length; ++i8) {
                        ionErrDist[i8] = Float.valueOf(in.readFloat());
                        assert (ionErrDist[i8].floatValue() > 0.0f);
                    }
                    this.ionErrDistTable.put(partition, ionErrDist);
                    Float[] noiseErrDist = new Float[this.errorScalingFactor * 2 + 1];
                    for (int i9 = 0; i9 < noiseErrDist.length; ++i9) {
                        noiseErrDist[i9] = Float.valueOf(in.readFloat());
                        assert (noiseErrDist[i9].floatValue() > 0.0f);
                    }
                    this.noiseErrDistTable.put(partition, noiseErrDist);
                    Float[] ionExTable = new Float[4];
                    for (int i10 = 0; i10 < ionExTable.length; ++i10) {
                        ionExTable[i10] = Float.valueOf(in.readFloat());
                        if (ionExTable[i10].floatValue() == 0.0f) {
                            ionExTable[i10] = Float.valueOf(0.001f);
                        }
                        assert (ionExTable[i10].floatValue() > 0.0f);
                    }
                    this.ionExistenceTable.put(partition, ionExTable);
                }
            }
            if ((validation = in.readInt()) != Integer.MAX_VALUE) {
                System.err.println("Parameter is wrong!");
                System.exit(-1);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected NewRankScorer tolerance(Tolerance mme) {
        this.mme = mme;
        return this;
    }

    protected NewRankScorer filter(WindowFilter filter) {
        this.filter = filter;
        return this;
    }

    public Tolerance getMME() {
        return this.mme;
    }

    protected Histogram<Integer> getChargeHist() {
        return this.chargeHist;
    }

    protected TreeSet<Partition> getPartitionSet() {
        return this.partitionSet;
    }

    protected int getNumPrecursorOFF() {
        return this.numPrecurOFF;
    }

    protected int getMaxRank() {
        return this.maxRank;
    }

    protected int getNumErrorBins() {
        return this.errorScalingFactor;
    }

    protected int getNumSegments() {
        return this.numSegments;
    }

    int getSegmentNum(float peakMz, float parentMass) {
        int segNum = (int)(peakMz / parentMass * (float)this.numSegments);
        if (segNum >= this.numSegments) {
            segNum = this.numSegments - 1;
        }
        return segNum;
    }

    protected ArrayList<PrecursorOffsetFrequency> getPrecursorOFF(int charge) {
        if (this.precursorOFFMap == null || this.precursorOFFMap.size() == 0) {
            return new ArrayList<PrecursorOffsetFrequency>();
        }
        Map.Entry<Integer, ArrayList<PrecursorOffsetFrequency>> entry = this.precursorOFFMap.floorEntry(charge);
        if (entry == null) {
            entry = this.precursorOFFMap.ceilingEntry(charge);
        }
        return entry.getValue();
    }

    protected Partition getPartition(int charge, float parentMass, int segNum) {
        if (this.partitionSet == null || this.partitionSet.size() == 0) {
            return null;
        }
        Partition partition = new Partition(charge, parentMass, segNum);
        Partition matched = this.partitionSet.floor(partition);
        if (matched == null) {
            partition = new Partition(this.partitionSet.first().getCharge(), parentMass, segNum);
            return this.partitionSet.floor(partition);
        }
        if (charge == matched.getCharge()) {
            return matched;
        }
        partition = new Partition(matched.getCharge(), parentMass, segNum);
        return this.partitionSet.floor(partition);
    }

    protected ArrayList<FragmentOffsetFrequency> getFragmentOFF(int charge, float parentMass, int segNum) {
        return this.getFragmentOFF(this.getPartition(charge, parentMass, segNum));
    }

    protected ArrayList<FragmentOffsetFrequency> getFragmentOFF(Partition partition) {
        return this.fragOFFTable.get(partition);
    }

    protected Hashtable<IonType, Float[]> getRankDistTable(int charge, float parentMass, int segNum) {
        return this.getRankDistTable(this.getPartition(charge, parentMass, segNum));
    }

    protected Hashtable<IonType, Float[]> getRankDistTable(Partition partition) {
        return this.rankDistTable.get(partition);
    }

    public IonType[] getIonTypes(int charge, float parentMass, int segNum) {
        return this.getIonTypes(this.getPartition(charge, parentMass, segNum));
    }

    protected IonType[] getIonTypes(Partition partition) {
        if (this.ionTypeTable != null) {
            return this.ionTypeTable.get(partition);
        }
        ArrayList<FragmentOffsetFrequency> offList = this.fragOFFTable.get(partition);
        IonType[] ionTypes = new IonType[offList.size()];
        for (int i = 0; i < offList.size(); ++i) {
            ionTypes[i] = offList.get(i).getIonType();
        }
        return ionTypes;
    }

    protected IonType getMainIonType(Partition partition) {
        return this.mainIonTable.get(partition);
    }

    protected void determineIonTypes() {
        this.ionTypeTable = new HashMap();
        for (Partition partition : this.partitionSet) {
            ArrayList<FragmentOffsetFrequency> offList = this.fragOFFTable.get(partition);
            IonType[] ionTypes = new IonType[offList.size()];
            for (int i = 0; i < offList.size(); ++i) {
                ionTypes[i] = offList.get(i).getIonType();
            }
            this.ionTypeTable.put(partition, ionTypes);
        }
        this.mainIonTable = new HashMap();
        for (Partition partition : this.partitionSet) {
            if (partition.getSegNum() != 0) continue;
            HashMap<IonType, Float> ionProb = new HashMap<IonType, Float>();
            for (int seg = 0; seg < this.numSegments; ++seg) {
                Partition part = new Partition(partition.getCharge(), partition.getParentMass(), seg);
                ArrayList<FragmentOffsetFrequency> offList = this.fragOFFTable.get(part);
                Iterator iterator = offList.iterator();
                while (iterator.hasNext()) {
                    FragmentOffsetFrequency off = (FragmentOffsetFrequency)iterator.next();
                    Float prob = (Float)ionProb.get(off.getIonType());
                    if (prob == null) {
                        ionProb.put(off.getIonType(), Float.valueOf(off.getFrequency()));
                        continue;
                    }
                    ionProb.put(off.getIonType(), Float.valueOf(prob.floatValue() + off.getFrequency()));
                }
            }
            IonType mainIon = null;
            float prob = -1.0f;
            for (IonType ion : ionProb.keySet()) {
                if (!(((Float)ionProb.get(ion)).floatValue() > prob)) continue;
                mainIon = ion;
                prob = ((Float)ionProb.get(ion)).floatValue();
            }
            assert (mainIon != null);
            for (int seg = 0; seg < this.numSegments; ++seg) {
                Partition part = new Partition(partition.getCharge(), partition.getParentMass(), seg);
                this.mainIonTable.put(part, mainIon);
            }
        }
    }

    protected HashSet<Integer> getIonOffsets(Partition partition, int charge, boolean isPrefix) {
        HashSet<Integer> offsets = new HashSet<Integer>();
        ArrayList<FragmentOffsetFrequency> offList = this.fragOFFTable.get(partition);
        for (FragmentOffsetFrequency off : offList) {
            if ((!isPrefix || !(off.getIonType() instanceof IonType.PrefixIon)) && (isPrefix || !(off.getIonType() instanceof IonType.SuffixIon))) continue;
            offsets.add(Math.round(off.getIonType().getOffset()));
        }
        return offsets;
    }

    protected IonType[] getNoiseIonTypes(Partition partition) {
        ArrayList<FragmentOffsetFrequency> offList = this.insignificantFragOFFTable.get(partition);
        IonType[] ionTypes = new IonType[offList.size()];
        for (int i = 0; i < offList.size(); ++i) {
            ionTypes[i] = offList.get(i).getIonType();
        }
        return ionTypes;
    }

    /*
     * WARNING - void declaration
     */
    public void writeParameters(File outputFile) {
        if (this.chargeHist == null || this.partitionSet == null || this.precursorOFFMap == null || this.fragOFFTable == null || this.rankDistTable == null) {
            assert (false) : "Parameters are not generated!";
            System.exit(-1);
            return;
        }
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            Float[] ionTypeList;
            out.writeInt(7061);
            out.writeByte(this.dataType.getActivationMethod().getName().length());
            out.writeChars(this.dataType.getActivationMethod().getName());
            out.writeByte(this.dataType.getInstrumentType().getName().length());
            out.writeChars(this.dataType.getInstrumentType().getName());
            Enzyme enzyme = this.dataType.getEnzyme();
            if (enzyme != null) {
                out.writeByte(enzyme.getName().length());
                out.writeChars(enzyme.getName());
            } else {
                out.writeByte(0);
            }
            Protocol protocol = this.dataType.getProtocol();
            if (protocol != null && protocol != Protocol.AUTOMATIC) {
                out.writeByte(protocol.getName().length());
                out.writeChars(protocol.getName());
            } else {
                out.writeByte(0);
            }
            out.writeBoolean(this.mme.isTolerancePPM());
            out.writeFloat(this.mme.getValue());
            out.writeBoolean(this.applyDeconvolution);
            out.writeFloat(this.deconvolutionErrorTolerance);
            out.writeInt(this.chargeHist.maxKey() - this.chargeHist.minKey() + 1);
            for (int charge = this.chargeHist.minKey().intValue(); charge <= this.chargeHist.maxKey(); ++charge) {
                out.writeInt(charge);
                out.writeInt(this.chargeHist.get(charge));
            }
            out.writeInt(this.partitionSet.size());
            out.writeInt(this.numSegments);
            for (Partition p : this.partitionSet) {
                out.writeInt(p.getCharge());
                out.writeFloat(p.getParentMass());
                out.writeInt(p.getSegNum());
            }
            out.writeInt(this.numPrecurOFF);
            for (int charge = this.chargeHist.minKey().intValue(); charge <= this.chargeHist.maxKey(); ++charge) {
                ArrayList<PrecursorOffsetFrequency> offList = this.precursorOFFMap.get(charge);
                if (offList == null) continue;
                for (PrecursorOffsetFrequency precursorOffsetFrequency : offList) {
                    out.writeInt(charge);
                    out.writeInt(precursorOffsetFrequency.getReducedCharge());
                    out.writeFloat(precursorOffsetFrequency.getOffset());
                    out.writeBoolean(precursorOffsetFrequency.getTolerance().isTolerancePPM());
                    out.writeFloat(precursorOffsetFrequency.getTolerance().getValue());
                    out.writeFloat(precursorOffsetFrequency.getFrequency());
                }
            }
            for (Partition partition : this.partitionSet) {
                ArrayList<FragmentOffsetFrequency> fragmentOFF = this.getFragmentOFF(partition);
                out.writeInt(fragmentOFF.size());
                Collections.sort(fragmentOFF, Collections.reverseOrder());
                for (FragmentOffsetFrequency off : fragmentOFF) {
                    out.writeBoolean(off.getIonType() instanceof IonType.PrefixIon);
                    out.writeInt(off.getIonType().getCharge());
                    out.writeFloat(off.getIonType().getOffset());
                    out.writeFloat(off.getFrequency());
                }
            }
            out.writeInt(this.maxRank);
            for (Partition partition : this.partitionSet) {
                IonType[] ionTypeArray;
                Hashtable<IonType, Float[]> rankDistTable = this.getRankDistTable(partition);
                if (rankDistTable == null || (ionTypeArray = this.getIonTypes(partition)) == null || ionTypeArray.length == 0) continue;
                ionTypeList = new ArrayList();
                for (IonType ionType : ionTypeArray) {
                    ionTypeList.add(ionType);
                }
                ionTypeList.add(IonType.NOISE);
                for (IonType ionType : ionTypeList) {
                    Float[] frequencies = rankDistTable.get(ionType);
                    assert (frequencies.length == this.maxRank + 1);
                    for (Float freq : frequencies) {
                        out.writeFloat(freq.floatValue());
                    }
                }
            }
            out.writeInt(this.errorScalingFactor);
            if (this.errorScalingFactor > 0) {
                for (Partition partition : this.partitionSet) {
                    void var11_30;
                    Float[] ionErrDist = this.ionErrDistTable.get(partition);
                    assert (ionErrDist.length == 2 * this.errorScalingFactor + 1);
                    for (Float f : ionErrDist) {
                        out.writeFloat(f.floatValue());
                    }
                    Float[] floatArray = this.noiseErrDistTable.get(partition);
                    assert (floatArray.length == 2 * this.errorScalingFactor + 1);
                    ionTypeList = floatArray;
                    int n = ionTypeList.length;
                    boolean bl = false;
                    while (var11_30 < n) {
                        Float f = ionTypeList[var11_30];
                        out.writeFloat(f.floatValue());
                        ++var11_30;
                    }
                    Float[] ionExTable = this.ionExistenceTable.get(partition);
                    assert (ionExTable.length == 4);
                    for (Float f : ionExTable) {
                        out.writeFloat(f.floatValue());
                    }
                }
            }
            out.writeInt(Integer.MAX_VALUE);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void writeParametersPlainText(File outputFile) {
        Float[] ionTypeList;
        PrintStream out = null;
        if (outputFile == null) {
            out = System.out;
        } else {
            try {
                out = new PrintStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        out.println("#MSGFScoringParameters\tv" + new SimpleDateFormat("yyyyMMdd").format(Calendar.getInstance().getTime()));
        if (this.dataType.getActivationMethod() != null) {
            out.println("#Activation Method: " + this.dataType.getActivationMethod().getName());
        }
        if (this.dataType.getInstrumentType() != null) {
            out.println("#Instrument type: " + this.dataType.getInstrumentType().getName());
        }
        if (this.dataType.getEnzyme() != null) {
            out.println("#Enzyme: " + this.dataType.getEnzyme().getName());
        }
        if (this.dataType.getProtocol() != null) {
            out.println("#Protocol: " + this.dataType.getProtocol().getName());
        }
        out.println("#Maximum mass error: " + this.mme.toString());
        out.println("Apply deconvolution: " + this.applyDeconvolution);
        out.println("Deconvolution error tolerance: " + this.deconvolutionErrorTolerance);
        out.println("#ChargeHistogram\t" + (this.chargeHist.maxKey() - this.chargeHist.minKey() + 1));
        for (int charge = this.chargeHist.minKey().intValue(); charge <= this.chargeHist.maxKey(); ++charge) {
            out.println(charge + "\t" + this.chargeHist.get(charge));
        }
        out.println("#Partitions\t" + this.partitionSet.size());
        for (Partition p : this.partitionSet) {
            out.println(p.getCharge() + "\t" + p.getSegNum() + "\t" + p.getParentMass());
        }
        out.println("#PrecursorOffsetFrequencyFunction\t" + this.numPrecurOFF);
        for (int charge = this.chargeHist.minKey().intValue(); charge <= this.chargeHist.maxKey(); ++charge) {
            ArrayList<PrecursorOffsetFrequency> offList = this.precursorOFFMap.get(charge);
            if (offList == null) continue;
            for (PrecursorOffsetFrequency precursorOffsetFrequency : offList) {
                out.println(charge + "\t" + precursorOffsetFrequency.getReducedCharge() + "\t" + precursorOffsetFrequency.getOffset() + "\t" + precursorOffsetFrequency.getTolerance().toString() + "\t" + precursorOffsetFrequency.getFrequency());
            }
        }
        out.println("#FragmentOffsetFrequencyFunction\t" + this.partitionSet.size());
        for (Partition partition : this.partitionSet) {
            ArrayList<FragmentOffsetFrequency> fragmentOFF = this.getFragmentOFF(partition);
            out.println("Partition\t" + partition.getCharge() + "\t" + partition.getSegNum() + "\t" + partition.getParentMass() + "\t" + fragmentOFF.size());
            Collections.sort(fragmentOFF, Collections.reverseOrder());
            for (FragmentOffsetFrequency off : fragmentOFF) {
                out.println(off.getIonType().getName() + "\t" + off.getFrequency() + "\t" + off.getIonType().getOffset());
            }
        }
        out.println("#RankDistributions\t" + this.partitionSet.size());
        for (Partition partition : this.partitionSet) {
            Hashtable<IonType, Float[]> rankDistTable = this.getRankDistTable(partition);
            IonType[] ionTypeArray = this.getIonTypes(partition);
            if (ionTypeArray == null || ionTypeArray.length == 0) continue;
            ionTypeList = new ArrayList();
            for (IonType ionType : ionTypeArray) {
                ionTypeList.add(ionType);
            }
            ionTypeList.add(IonType.NOISE);
            out.println("Partition\t" + partition.getCharge() + "\t" + partition.getSegNum() + "\t" + partition.getParentMass() + "\t" + ionTypeList.size() + "\t" + this.maxRank);
            for (IonType ionType : ionTypeList) {
                Float[] frequencies;
                out.print(ionType.getName());
                for (Float freq : frequencies = rankDistTable.get(ionType)) {
                    out.print("\t" + freq);
                }
                out.println();
            }
        }
        if (this.errorScalingFactor > 0) {
            out.println("#ErrorDistributions\t" + this.errorScalingFactor);
            for (Partition partition : this.partitionSet) {
                void var9_27;
                out.println("Partition\t" + partition.getCharge() + "\t" + partition.getSegNum() + "\t" + partition.getParentMass() + "\t" + this.getMainIonType(partition).getName());
                Float[] ionErrDist = this.ionErrDistTable.get(partition);
                out.print("Signal");
                for (Float f : ionErrDist) {
                    out.print("\t" + f);
                }
                out.println();
                Float[] floatArray = this.noiseErrDistTable.get(partition);
                out.print("Noise");
                ionTypeList = floatArray;
                int n = ionTypeList.length;
                boolean bl = false;
                while (var9_27 < n) {
                    Float f = ionTypeList[var9_27];
                    out.print("\t" + f);
                    ++var9_27;
                }
                out.println();
                Float[] ionExTable = this.ionExistenceTable.get(partition);
                out.print("IonExistence");
                for (Float f : ionExTable) {
                    out.print("\t" + f);
                }
                out.println();
            }
        }
        out.flush();
        out.close();
    }

    public static void main(String[] argv) throws Exception {
        NewRankScorer.readWriteTest();
    }

    public static void readWriteTest() throws Exception {
    }
}

