/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msscorer;

import edu.ucsd.msjava.msgf.Histogram;
import edu.ucsd.msjava.msgf.IntHistogram;
import edu.ucsd.msjava.msgf.NominalMass;
import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msscorer.FragmentOffsetFrequency;
import edu.ucsd.msjava.msscorer.IonProbability;
import edu.ucsd.msjava.msscorer.NewRankScorer;
import edu.ucsd.msjava.msscorer.NewScorerFactory;
import edu.ucsd.msjava.msscorer.Partition;
import edu.ucsd.msjava.msscorer.PrecursorOffsetFrequency;
import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Composition;
import edu.ucsd.msjava.msutil.InstrumentType;
import edu.ucsd.msjava.msutil.IonType;
import edu.ucsd.msjava.msutil.Pair;
import edu.ucsd.msjava.msutil.Peak;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.msutil.SpectraContainer;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.parser.MgfSpectrumParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.TreeMap;
import java.util.TreeSet;

public class ScoringParameterGeneratorWithErrors
extends NewRankScorer {
    private static final float MIN_PRECURSOR_OFFSET = -300.0f;
    private static final float MAX_PRECURSOR_OFFSET = 30.0f;
    private static final int MIN_NUM_SPECTRA_PER_PARTITION = 400;
    private static final int MIN_NUM_SPECTRA_FOR_PRECURSOR_OFF = 150;
    private static final int MAX_NUM_PARTITIONS_PER_CHARGE = 30;
    private static final float MIN_PRECURSOR_OFFSET_PROBABILITY = 0.15f;
    private static final float MIN_ION_OFFSET_PROBABILITY = 0.15f;
    private static final float MIN_MAIN_ION_OFFSET_PROBABILITY = 0.01f;
    private static final int MAX_RANK = 150;
    private static final int NUM_SEGMENTS_PER_SPECTRUM = 2;
    private static final int[] smoothingRanks = new int[]{3, 5, 10, 20, 50, Integer.MAX_VALUE};
    private static final int[] smoothingWindowSize = new int[]{0, 1, 2, 3, 4, 5};
    private static final float DECONVOLUTION_MASS_TOLERANCE = 0.02f;
    protected static final int MAX_CHARGE = 20;
    private SpectraContainer specContainer;
    private final boolean considerPhosLoss;
    private final boolean consideriTRAQLoss;
    private final boolean considerTMTLoss;

    public static void generateParameters(File specFile, NewScorerFactory.SpecDataType dataType, AminoAcidSet aaSet, File outputDir, boolean isText, boolean verbose, boolean singlePartition) {
        SpectraContainer container = new SpectraContainer(specFile.getPath(), new MgfSpectrumParser().aaSet(aaSet));
        ScoringParameterGeneratorWithErrors.generateParameters(container, dataType, aaSet, outputDir, isText, verbose, singlePartition);
    }

    public static void generateParameters(SpectraContainer container, NewScorerFactory.SpecDataType dataType, AminoAcidSet aaSet, File outputDir, boolean isText, boolean verbose) {
        ScoringParameterGeneratorWithErrors.generateParameters(container, dataType, aaSet, outputDir, isText, verbose, false);
    }

    public static void generateParameters(SpectraContainer container, NewScorerFactory.SpecDataType dataType, AminoAcidSet aaSet, File outputDir, boolean isText, boolean verbose, boolean singlePartition) {
        if (verbose) {
            System.out.println("Number of annotated PSMs: " + container.size());
        }
        String paramFileName = dataType.toString() + ".param";
        File outputFile = outputDir != null ? new File(outputDir, paramFileName) : new File(paramFileName);
        if (verbose) {
            System.out.println("Output file name: " + outputFile.getAbsolutePath());
        }
        int errorScalingFactor = 0;
        boolean applyDeconvolution = false;
        if (dataType.getInstrumentType() == InstrumentType.HIGH_RESOLUTION_LTQ || dataType.getInstrumentType() == InstrumentType.TOF || dataType.getInstrumentType().isHighResolution()) {
            errorScalingFactor = 100;
            applyDeconvolution = true;
            if (verbose) {
                System.out.println("High-precision MS/MS data: errorScalingFactor(" + errorScalingFactor + ") chargeDeconvolution(" + applyDeconvolution + ")");
            }
        }
        boolean considerPhosLoss = false;
        if (dataType.getProtocol().getName().equals("Phosphorylation")) {
            considerPhosLoss = true;
            if (verbose) {
                System.out.println("Consider H3PO4 loss.");
            }
        }
        boolean consideriTRAQLoss = false;
        if (dataType.getProtocol().getName().equals("iTRAQ")) {
            consideriTRAQLoss = true;
            if (verbose) {
                System.out.println("Consider iTRAQ loss.");
            }
        }
        boolean considerTMTLoss = false;
        if (dataType.getProtocol().getName().equals("TMT")) {
            considerTMTLoss = true;
            if (verbose) {
                System.out.println("Consider TMT loss.");
            }
        }
        if (dataType.getProtocol().getName().equals("iTRAQPhospho")) {
            considerPhosLoss = true;
            consideriTRAQLoss = true;
            if (verbose) {
                System.out.println("Consider iTRAQ and H3PO4 loss.");
            }
        }
        HashSet<String> pepSet = new HashSet<String>();
        for (Spectrum spec : container) {
            pepSet.add(spec.getAnnotationStr());
        }
        if (verbose) {
            System.out.println("Number of unique peptides: " + pepSet.size());
        }
        int numSpecsPerPeptide = pepSet.size() < 2000 ? 3 : 1;
        if (verbose) {
            System.out.println("Consider " + numSpecsPerPeptide + " per spectrum.");
        }
        HashMap pepSpecMap = new HashMap();
        for (Object spec : container) {
            String pep;
            if (((Spectrum)spec).getAnnotationStr() == null || (pep = ((Spectrum)spec).getAnnotationStr() + ":" + ((Spectrum)spec).getCharge()) == null || pep.length() <= 0) continue;
            ArrayList<Object> specList = (ArrayList<Object>)pepSpecMap.get(pep);
            if (specList == null) {
                specList = new ArrayList<Object>();
                pepSpecMap.put(pep, specList);
            }
            if (specList.size() >= numSpecsPerPeptide) continue;
            specList.add(spec);
        }
        SpectraContainer specContOnePerPep = new SpectraContainer();
        for (ArrayList specList : pepSpecMap.values()) {
            for (Spectrum spec : specList) {
                specContOnePerPep.add(spec);
            }
        }
        ScoringParameterGeneratorWithErrors gen = new ScoringParameterGeneratorWithErrors(specContOnePerPep, dataType, considerPhosLoss, consideriTRAQLoss, considerTMTLoss, applyDeconvolution);
        gen.tolerance(new Tolerance(0.5f));
        if (singlePartition) {
            gen.partition(2, true);
        } else {
            gen.partition(2, false);
        }
        if (verbose) {
            System.out.println("Partition: " + gen.partitionSet.size());
        }
        gen.precursorOFF(0.15f);
        if (verbose) {
            System.out.println("PrecursorOFF Done.");
        }
        gen.filterPrecursorPeaks();
        if (verbose) {
            System.out.println("Filtering Done.");
        }
        if (applyDeconvolution) {
            gen.deconvoluteSpectra();
            if (verbose) {
                System.out.println("Deconvolution Done.");
            }
        }
        gen.selectIonTypes();
        if (verbose) {
            System.out.println("Ion types selected.");
        }
        gen.generateRankDist(150);
        if (verbose) {
            System.out.println("Rank distribution computed.");
        }
        gen.generateErrorDist(errorScalingFactor);
        if (verbose) {
            System.out.println("Error disbribution computed");
        }
        gen.smoothing();
        if (verbose) {
            System.out.println("Smoothing complete.");
        }
        gen.writeParameters(outputFile);
        gen.writeParametersPlainText(new File(outputFile.getPath() + ".txt"));
        if (verbose) {
            System.out.println("Writing Done.");
        }
    }

    public ScoringParameterGeneratorWithErrors(SpectraContainer specContainer, NewScorerFactory.SpecDataType dataType, boolean considerPhosLoss, boolean consideriTRAQLoss, boolean considerTMTLoss, boolean applyDeconvolution) {
        this.specContainer = specContainer;
        this.considerPhosLoss = considerPhosLoss;
        this.consideriTRAQLoss = consideriTRAQLoss;
        this.considerTMTLoss = considerTMTLoss;
        this.dataType = dataType;
        this.applyDeconvolution = applyDeconvolution;
        this.deconvolutionErrorTolerance = 0.02f;
    }

    public void partition(int numSegments, boolean singlePartition) {
        this.numSegments = numSegments;
        this.chargeHist = new Histogram();
        this.partitionSet = new TreeSet();
        Hashtable<Integer, ArrayList<Float>> parentMassMap = new Hashtable<Integer, ArrayList<Float>>();
        for (Spectrum spec : this.specContainer) {
            int charge = spec.getCharge();
            if (charge <= 0) continue;
            this.chargeHist.add(charge);
            if (spec.getAnnotation() == null) continue;
            ArrayList<Float> precursorList = (ArrayList<Float>)parentMassMap.get(charge);
            if (precursorList == null) {
                precursorList = new ArrayList<Float>();
                parentMassMap.put(charge, precursorList);
            }
            precursorList.add(Float.valueOf(spec.getPrecursorMass()));
        }
        for (int c = ((Integer)this.chargeHist.minKey()).intValue(); c <= (Integer)this.chargeHist.maxKey(); ++c) {
            int i;
            int numSpec;
            ArrayList parentMassList = (ArrayList)parentMassMap.get(c);
            if (parentMassList == null || (numSpec = parentMassList.size()) < Math.round(360.0f)) continue;
            int partitionSize = Math.max(numSpec / 30, 400);
            Collections.sort(parentMassList);
            int bestSetSize = 0;
            if (singlePartition) {
                bestSetSize = numSpec;
            } else {
                int smallestRemainder = partitionSize;
                for (i = Math.round((float)partitionSize * 0.9f); i <= Math.round((float)partitionSize * 1.1f); ++i) {
                    int remainder = numSpec % i;
                    if (i - remainder < remainder) {
                        remainder = i - remainder;
                    }
                    if (remainder >= smallestRemainder && (remainder != smallestRemainder || Math.abs(partitionSize - i) >= Math.abs(partitionSize - bestSetSize))) continue;
                    bestSetSize = i;
                    smallestRemainder = remainder;
                }
            }
            int num = 0;
            for (i = 0; i == 0 || i < Math.round((float)numSpec / (float)bestSetSize); ++i) {
                int seg;
                if (num != 0) {
                    for (seg = 0; seg < numSegments; ++seg) {
                        this.partitionSet.add(new Partition(c, ((Float)parentMassList.get(num)).floatValue(), seg));
                    }
                } else {
                    for (seg = 0; seg < numSegments; ++seg) {
                        this.partitionSet.add(new Partition(c, 0.0f, seg));
                    }
                }
                num += bestSetSize;
            }
        }
    }

    private void precursorOFF(float minProbThreshold) {
        if (this.chargeHist == null) {
            assert (false) : "partition() must have been called before";
            return;
        }
        this.precursorOFFMap = new TreeMap();
        this.numPrecurOFF = 0;
        for (int charge = ((Integer)this.chargeHist.minKey()).intValue(); charge <= (Integer)this.chargeHist.maxKey(); ++charge) {
            int c;
            if (this.chargeHist.get(charge) < 150) continue;
            ArrayList<PrecursorOffsetFrequency> precursorOffsetList = new ArrayList<PrecursorOffsetFrequency>();
            int numSpecs = 0;
            Hashtable histList = new Hashtable();
            for (c = charge; c >= 2; --c) {
                histList.put(c, new Histogram());
            }
            for (Spectrum spec : this.specContainer) {
                if (spec.getAnnotation() == null || spec.getCharge() != charge) continue;
                ++numSpecs;
                spec = this.filter.apply(spec);
                float precursorNeutralMass = spec.getPrecursorMass();
                for (int c2 = charge; c2 >= 2; --c2) {
                    float precursorMz = (precursorNeutralMass + (float)c2 * (float)Composition.ChargeCarrierMass()) / (float)c2;
                    ArrayList<Peak> peakList = spec.getPeakListByMassRange(precursorMz + -300.0f / (float)c2 - this.mme.getToleranceAsDa(precursorMz + -300.0f / (float)c2) / 2.0f, precursorMz + 30.0f / (float)c2 + this.mme.getToleranceAsDa(precursorMz + 30.0f / (float)c2) / 2.0f);
                    int prevMassIndexDiff = Integer.MIN_VALUE;
                    for (Peak p : peakList) {
                        float peakMass = p.getMz();
                        int massIndexDiff = NominalMass.toNominalMass(peakMass - precursorMz);
                        if (massIndexDiff <= prevMassIndexDiff) continue;
                        ((Histogram)histList.get(c2)).add(massIndexDiff);
                        prevMassIndexDiff = massIndexDiff;
                    }
                }
            }
            for (c = charge; c >= 2; --c) {
                ArrayList keyList = new ArrayList(((Histogram)histList.get(c)).keySet());
                Collections.sort(keyList);
                for (Integer key : keyList) {
                    float prob = (float)((Histogram)histList.get(c)).get(key).intValue() / (float)numSpecs;
                    if (!(prob > minProbThreshold)) continue;
                    precursorOffsetList.add(new PrecursorOffsetFrequency(charge - c, NominalMass.getMassFromNominalMass(key), prob));
                }
            }
            this.precursorOFFMap.put(charge, precursorOffsetList);
            this.numPrecurOFF += precursorOffsetList.size();
        }
    }

    private void filterPrecursorPeaks() {
        if (this.precursorOFFMap == null) {
            return;
        }
        for (Spectrum spec : this.specContainer) {
            for (PrecursorOffsetFrequency off : this.getPrecursorOFF(spec.getCharge())) {
                spec.filterPrecursorPeaks(this.mme, off.getReducedCharge(), off.getOffset());
            }
        }
    }

    private void deconvoluteSpectra() {
        SpectraContainer newSpecContainer = new SpectraContainer();
        for (Spectrum spec : this.specContainer) {
            newSpecContainer.add(spec.getDeconvolutedSpectrum(0.02f));
        }
        this.specContainer = newSpecContainer;
    }

    private Pair<Float, Float> getPrecursorMassRange(Partition partition) {
        float minParentMass = partition.getParentMass();
        float maxParentMass = Float.MAX_VALUE;
        Partition higherPartition = this.partitionSet.higher(partition);
        if (higherPartition != null && higherPartition.getCharge() == partition.getCharge() && higherPartition.getSegNum() == partition.getSegNum()) {
            maxParentMass = higherPartition.getParentMass();
        }
        return new Pair<Float, Float>(Float.valueOf(minParentMass), Float.valueOf(maxParentMass));
    }

    private void selectIonTypes() {
        if (this.partitionSet == null) {
            assert (false) : "partition() must have been called before!";
            return;
        }
        this.fragOFFTable = new Hashtable();
        for (Partition partition : this.partitionSet) {
            int charge = partition.getCharge();
            Pair<Float, Float> parentMassRange = this.getPrecursorMassRange(partition);
            SpectraContainer curPartContainer = new SpectraContainer();
            for (Spectrum spec : this.specContainer) {
                float curParentMass;
                if (spec.getAnnotation() == null || spec.getCharge() != charge || (curParentMass = spec.getPrecursorMass()) < parentMassRange.getFirst().floatValue() || curParentMass >= parentMassRange.getSecond().floatValue()) continue;
                curPartContainer.add(spec);
            }
            ArrayList<FragmentOffsetFrequency> signalFragmentOffsetFrequencyList = new ArrayList<FragmentOffsetFrequency>();
            int seg = partition.getSegNum();
            IonType[] allIonTypes = IonType.getAllKnownIonTypes(Math.min(charge, 3), true, this.considerPhosLoss, this.consideriTRAQLoss, this.considerTMTLoss).toArray(new IonType[0]);
            IonProbability probGen = new IonProbability(curPartContainer.iterator(), allIonTypes, this.mme).filter(this.filter).segment(seg, this.numSegments);
            float[] ionProb = probGen.getIonProb();
            float signalThreshold = 0.15f;
            for (int i = 0; i < allIonTypes.length; ++i) {
                if (!(ionProb[i] >= signalThreshold)) continue;
                signalFragmentOffsetFrequencyList.add(new FragmentOffsetFrequency(allIonTypes[i], ionProb[i]));
            }
            if (signalFragmentOffsetFrequencyList.size() == 0) {
                int maxIndex = -1;
                float maxIonProb = Float.MIN_VALUE;
                for (int i = 0; i < allIonTypes.length; ++i) {
                    if (!(ionProb[i] > 0.01f) || !(ionProb[i] > maxIonProb)) continue;
                    maxIndex = i;
                    maxIonProb = ionProb[i];
                }
                if (maxIndex >= 0) {
                    signalFragmentOffsetFrequencyList.add(new FragmentOffsetFrequency(allIonTypes[maxIndex], maxIonProb));
                }
            }
            Collections.sort(signalFragmentOffsetFrequencyList, Collections.reverseOrder());
            this.fragOFFTable.put(partition, signalFragmentOffsetFrequencyList);
        }
        super.determineIonTypes();
    }

    private void generateRankDist(int maxRank) {
        if (this.partitionSet == null) {
            assert (false) : "partition() must have been called!";
            return;
        }
        this.rankDistTable = new Hashtable();
        this.maxRank = maxRank;
        for (Partition partition : this.partitionSet) {
            int charge = partition.getCharge();
            IonType[] ionTypes = this.getIonTypes(partition);
            if (ionTypes == null || ionTypes.length == 0) continue;
            Pair<Float, Float> parentMassRange = this.getPrecursorMassRange(partition);
            int seg = partition.getSegNum();
            int numSpec = 0;
            Hashtable rankDist = new Hashtable();
            Hashtable<IonType, Float> rankDistMaxRank = new Hashtable<IonType, Float>();
            Hashtable<IonType, Float> rankDistUnexplained = new Hashtable<IonType, Float>();
            for (IonType ionType : ionTypes) {
                rankDist.put(ionType, new Histogram());
                rankDistMaxRank.put(ionType, Float.valueOf(0.0f));
                rankDistUnexplained.put(ionType, Float.valueOf(0.0f));
            }
            rankDist.put(IonType.NOISE, new Histogram());
            float[] noiseDist = new float[maxRank + 2];
            int numMaxRankPeaks = 0;
            int totalCleavageSites = 0;
            for (IonType[] spec : this.specContainer) {
                float curParentMass;
                int numExplainedPeaks = 0;
                if (spec.getAnnotation() == null || spec.getCharge() != charge || (curParentMass = spec.getPrecursorMass()) < parentMassRange.getFirst().floatValue() || curParentMass >= parentMassRange.getSecond().floatValue()) continue;
                Peptide annotation = spec.getAnnotation();
                spec.setRanksOfPeaks();
                ++numSpec;
                numMaxRankPeaks += spec.size() - maxRank + 1;
                totalCleavageSites += annotation.size() - 1;
                int prmMassIndex = 0;
                int srmMassIndex = 0;
                HashSet<Peak> explainedPeakSet = new HashSet<Peak>();
                Hashtable<IonType, Integer> numExplainedMaxRankPeaks = new Hashtable<IonType, Integer>();
                for (IonType ion3 : ionTypes) {
                    numExplainedMaxRankPeaks.put(ion3, 0);
                }
                int numSignalBinsAtThisSegment = 0;
                for (int i = 0; i < annotation.size() - 1; ++i) {
                    float prm = NominalMass.getMassFromNominalMass(prmMassIndex += NominalMass.toNominalMass(annotation.get(i).getMass()));
                    float srm = NominalMass.getMassFromNominalMass(srmMassIndex += NominalMass.toNominalMass(annotation.get(annotation.size() - 1 - i).getMass()));
                    for (IonType ion4 : ionTypes) {
                        float theoMass = ion4 instanceof IonType.PrefixIon ? ion4.getMz(prm) : ion4.getMz(srm);
                        int segNum = super.getSegmentNum(theoMass, curParentMass);
                        if (segNum != seg) continue;
                        ++numSignalBinsAtThisSegment;
                        Peak p = spec.getPeakByMass(theoMass, this.mme);
                        if (p != null) {
                            ++numExplainedPeaks;
                            int rank = p.getRank();
                            if (rank >= maxRank) {
                                rank = maxRank;
                                numExplainedMaxRankPeaks.put(ion4, (Integer)numExplainedMaxRankPeaks.get(ion4) + 1);
                            }
                            explainedPeakSet.add(p);
                            ((Histogram)rankDist.get(ion4)).add(rank);
                            continue;
                        }
                        ((Histogram)rankDist.get(ion4)).add(maxRank + 1);
                    }
                }
                ArrayList<Peak> unexplainedPeaksAtThisSegment = new ArrayList<Peak>();
                int numPeaksAtThisSegment = 0;
                int numMaxRankPeaksAtThisSegment = 0;
                for (Peak peak : spec) {
                    if (super.getSegmentNum(peak.getMz(), curParentMass) != seg) continue;
                    ++numPeaksAtThisSegment;
                    if (peak.getRank() >= maxRank) {
                        ++numMaxRankPeaksAtThisSegment;
                    }
                    if (explainedPeakSet.contains(peak)) continue;
                    unexplainedPeaksAtThisSegment.add(peak);
                }
                float midMassThisSegment = (1.0f / (float)this.numSegments * (float)seg + 1.0f / (float)this.numSegments / 2.0f) * annotation.getParentMass();
                float f = annotation.getParentMass() / (float)this.numSegments / this.mme.getToleranceAsDa(midMassThisSegment) / 2.0f;
                for (Peak p : unexplainedPeaksAtThisSegment) {
                    int rank = p.getRank();
                    float noiseFreq = (float)((annotation.size() - 1) / this.numSegments) / f;
                    if (rank >= maxRank) {
                        int n = maxRank;
                        noiseDist[n] = noiseDist[n] + noiseFreq / (float)numMaxRankPeaksAtThisSegment;
                        continue;
                    }
                    int n = rank;
                    noiseDist[n] = noiseDist[n] + noiseFreq;
                }
                for (IonType ion5 : ionTypes) {
                    if (numMaxRankPeaksAtThisSegment <= 0) continue;
                    Float prevSumFreq = (Float)rankDistMaxRank.get(ion5);
                    float curFreq = (float)((Integer)numExplainedMaxRankPeaks.get(ion5)).intValue() / (float)numMaxRankPeaksAtThisSegment;
                    rankDistMaxRank.put(ion5, Float.valueOf(prevSumFreq.floatValue() + curFreq));
                }
                int n = maxRank + 1;
                noiseDist[n] = noiseDist[n] + (f - (float)numPeaksAtThisSegment) * (float)(annotation.size() - 1) / (float)this.numSegments / f;
            }
            Hashtable<IonType, Float[]> hashtable = new Hashtable<IonType, Float[]>();
            for (IonType ion6 : ionTypes) {
                Float[] dist = new Float[maxRank + 1];
                Histogram hist = (Histogram)rankDist.get(ion6);
                for (int i = 1; i <= maxRank - 1; ++i) {
                    Integer num = hist.get(i);
                    dist[i - 1] = Float.valueOf((float)num.intValue() / (float)numSpec);
                }
                dist[maxRank - 1] = Float.valueOf(((Float)rankDistMaxRank.get(ion6)).floatValue() / (float)numSpec);
                dist[maxRank] = Float.valueOf((float)hist.get(maxRank + 1).intValue() / (float)numSpec);
                hashtable.put(ion6, dist);
            }
            Float[] dist = new Float[maxRank + 1];
            for (int i = 1; i <= maxRank + 1; ++i) {
                dist[i - 1] = Float.valueOf(noiseDist[i] / (float)numSpec);
            }
            hashtable.put(IonType.NOISE, dist);
            this.rankDistTable.put(partition, hashtable);
        }
    }

    private void generateErrorDist(int errorScalingFactor) {
        this.errorScalingFactor = errorScalingFactor;
        if (errorScalingFactor > 0) {
            this.generateIonErrorDist();
            this.generateNoiseErrorDist();
        }
    }

    private void generateIonErrorDist() {
        this.ionErrDistTable = new Hashtable();
        this.ionExistenceTable = new Hashtable();
        for (Partition partition : this.partitionSet) {
            int i;
            int charge = partition.getCharge();
            Pair<Float, Float> parentMassRange = this.getPrecursorMassRange(partition);
            int seg = partition.getSegNum();
            if (seg != super.getNumSegments() - 1) continue;
            IonType mainIon = this.getMainIonType(partition);
            IntHistogram errHist = new IntHistogram();
            int[] edgeCount = new int[4];
            int numSpecs = 0;
            for (Spectrum spec : this.specContainer) {
                int i2;
                float curParentMass;
                if (spec.getAnnotation() == null || spec.getCharge() != charge || (curParentMass = spec.getPrecursorMass()) < parentMassRange.getFirst().floatValue() || curParentMass >= parentMassRange.getSecond().floatValue()) continue;
                ++numSpecs;
                Peptide peptide = spec.getAnnotation();
                int intResidueMass = 0;
                float[] obsMass = new float[peptide.size() + 1];
                obsMass[0] = mainIon.getOffset();
                for (i2 = 0; i2 < peptide.size() - 1; ++i2) {
                    intResidueMass = mainIon instanceof IonType.PrefixIon ? (intResidueMass += peptide.get(i2).getNominalMass()) : (intResidueMass += peptide.get(peptide.size() - 1 - i2).getNominalMass());
                    float theoMass = mainIon.getMz(NominalMass.getMassFromNominalMass(intResidueMass));
                    Peak p = spec.getPeakByMass(theoMass, this.mme);
                    obsMass[i2 + 1] = p != null ? p.getMz() : -1.0f;
                }
                obsMass[peptide.size()] = mainIon.getMz(peptide.getMass());
                for (i2 = 1; i2 <= peptide.size(); ++i2) {
                    if (obsMass[i2] >= 0.0f) {
                        if (obsMass[i2 - 1] >= 0.0f) {
                            float expMass = obsMass[i2] - obsMass[i2 - 1];
                            AminoAcid aa = mainIon instanceof IonType.PrefixIon ? peptide.get(i2 - 1) : peptide.get(peptide.size() - i2);
                            float theoMass = aa.getMass() / (float)mainIon.getCharge();
                            float diff = expMass - theoMass;
                            int diffIndex = Math.round(diff * (float)this.errorScalingFactor);
                            if (diffIndex > this.errorScalingFactor) {
                                diffIndex = this.errorScalingFactor;
                            } else if (diffIndex < -this.errorScalingFactor) {
                                diffIndex = -this.errorScalingFactor;
                            }
                            errHist.add(diffIndex);
                            edgeCount[3] = edgeCount[3] + 1;
                            continue;
                        }
                        edgeCount[1] = edgeCount[1] + 1;
                        continue;
                    }
                    if (obsMass[i2 - 1] >= 0.0f) {
                        edgeCount[2] = edgeCount[2] + 1;
                        continue;
                    }
                    edgeCount[0] = edgeCount[0] + 1;
                }
            }
            Float[] ionErrHist = new Float[2 * this.errorScalingFactor + 1];
            float[] smoothedHist = errHist.getSmoothedHist(this.errorScalingFactor);
            for (int i3 = -this.errorScalingFactor; i3 <= this.errorScalingFactor; ++i3) {
                ionErrHist[i3 + this.errorScalingFactor] = Float.valueOf(smoothedHist[i3 + this.errorScalingFactor] / (float)errHist.totalCount());
            }
            Float[] ionExistence = new Float[edgeCount.length];
            int sumEdgeCount = 0;
            for (i = 0; i < edgeCount.length; ++i) {
                sumEdgeCount += edgeCount[i];
            }
            for (i = 0; i < edgeCount.length; ++i) {
                ionExistence[i] = Float.valueOf((float)edgeCount[i] / (float)sumEdgeCount);
            }
            for (i = 0; i < this.numSegments; ++i) {
                Partition part = new Partition(partition.getCharge(), partition.getParentMass(), i);
                if (!this.partitionSet.contains(part)) continue;
                this.ionErrDistTable.put(part, ionErrHist);
                this.ionExistenceTable.put(part, ionExistence);
            }
        }
    }

    private void generateNoiseErrorDist() {
        this.noiseErrDistTable = new Hashtable();
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        AminoAcid aaK = aaSet.getAminoAcid('K');
        AminoAcid aaQ = aaSet.getAminoAcid('Q');
        int heaviestAANominalMass = aaSet.getMaxNominalMass();
        float[] nominalMass = new float[heaviestAANominalMass + 1];
        for (AminoAcid aa : aaSet) {
            nominalMass[aa.getNominalMass()] = aa.getMass();
        }
        for (Partition partition : this.partitionSet) {
            int i;
            int charge = partition.getCharge();
            Pair<Float, Float> parentMassRange = this.getPrecursorMassRange(partition);
            int seg = partition.getSegNum();
            if (seg != super.getNumSegments() - 1) continue;
            IntHistogram errHist = new IntHistogram();
            int numSpecs = 0;
            for (Spectrum spec : this.specContainer) {
                float curParentMass;
                if (spec.getAnnotation() == null || spec.getCharge() != charge || (curParentMass = spec.getPrecursorMass()) < parentMassRange.getFirst().floatValue() || curParentMass >= parentMassRange.getSecond().floatValue()) continue;
                Spectrum noiseSpec = (Spectrum)spec.clone();
                ++numSpecs;
                block3: for (int i2 = 0; i2 < noiseSpec.size() - 1; ++i2) {
                    Peak p1 = (Peak)noiseSpec.get(i2);
                    float p1Mass = p1.getMz();
                    int nominalP1 = NominalMass.toNominalMass(p1.getMz());
                    for (int j = i2 + 1; j < noiseSpec.size(); ++j) {
                        Peak p2 = (Peak)noiseSpec.get(j);
                        float p2Mass = p2.getMz();
                        int nominalP2 = NominalMass.toNominalMass(p2.getMz());
                        int nominalDiff = nominalP2 - nominalP1;
                        if (nominalDiff > heaviestAANominalMass) continue block3;
                        if (nominalMass[nominalDiff] == 0.0f) continue;
                        float diff = p2Mass - p1Mass;
                        float aaMass = nominalMass[nominalDiff];
                        if (nominalDiff == 128) {
                            aaMass = Math.abs(diff - aaQ.getMass()) > Math.abs(diff - aaK.getMass()) ? aaK.getMass() : aaQ.getMass();
                        }
                        float err = diff - aaMass;
                        errHist.add(Math.round(err * (float)this.errorScalingFactor));
                    }
                }
            }
            Float[] noiseErrHist = new Float[2 * this.errorScalingFactor + 1];
            float[] smoothedHist = errHist.getSmoothedHist(this.errorScalingFactor);
            for (i = -this.errorScalingFactor; i <= this.errorScalingFactor; ++i) {
                noiseErrHist[i + this.errorScalingFactor] = Float.valueOf(smoothedHist[i + this.errorScalingFactor] / (float)errHist.totalCount());
            }
            for (i = 0; i < this.numSegments; ++i) {
                Partition part = new Partition(partition.getCharge(), partition.getParentMass(), i);
                if (!this.partitionSet.contains(part)) continue;
                this.noiseErrDistTable.put(part, noiseErrHist);
            }
        }
    }

    protected void smoothing() {
        this.smoothingRankDistTable();
    }

    protected void smoothingRankDistTable() {
        if (this.rankDistTable == null) {
            return;
        }
        assert (smoothingRanks.length == smoothingWindowSize.length);
        for (Partition partition : this.rankDistTable.keySet()) {
            Hashtable table = (Hashtable)this.rankDistTable.get(partition);
            for (IonType ion : table.keySet()) {
                int i;
                Float[] freq = (Float[])table.get(ion);
                Float[] smoothedFreq = new Float[freq.length];
                int smoothingIndex = 0;
                for (i = 0; i < freq.length - 2; ++i) {
                    if (smoothingIndex < smoothingRanks.length - 1 && i == smoothingRanks[smoothingIndex]) {
                        ++smoothingIndex;
                    }
                    int windowSize = smoothingWindowSize[smoothingIndex];
                    float sumFrequencies = 0.0f;
                    int numIndicesSummed = 0;
                    for (int d = -windowSize; d <= windowSize; ++d) {
                        int index = i + d;
                        if (index < 0 || index > freq.length - 3) continue;
                        sumFrequencies += freq[index].floatValue();
                        ++numIndicesSummed;
                    }
                    while (sumFrequencies == 0.0f && windowSize < freq.length - 4) {
                        int index;
                        if ((index = i - ++windowSize) >= 0) {
                            sumFrequencies += freq[index].floatValue();
                            ++numIndicesSummed;
                        }
                        if ((index = i + windowSize) > freq.length - 3) continue;
                        sumFrequencies += freq[index].floatValue();
                        ++numIndicesSummed;
                    }
                    if (sumFrequencies != 0.0f) {
                        smoothedFreq[i] = Float.valueOf(sumFrequencies / (float)numIndicesSummed);
                        continue;
                    }
                    assert (false);
                }
                for (i = 0; i < freq.length - 2; ++i) {
                    freq[i] = smoothedFreq[i];
                }
                if (freq[freq.length - 1].floatValue() == 0.0f) {
                    freq[freq.length - 1] = Float.valueOf(Float.MIN_VALUE);
                }
                if (freq[freq.length - 2].floatValue() != 0.0f) continue;
                freq[freq.length - 2] = freq[freq.length - 3];
            }
        }
    }
}

