/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.mstag;

import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.Mass;
import edu.ucsd.msjava.msutil.Peak;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.msutil.Sequence;

public class Tag
extends Sequence<Mass>
implements Comparable<Tag> {
    private static final long serialVersionUID = 1L;
    private Mass leftMass;
    private Mass rightMass;
    private Peptide sequence;
    private float score;
    private Peak[] peaks;

    public Tag(Mass left, Peptide sequence, Mass right, Peak[] peaks, float score) {
        this.add(left);
        for (AminoAcid aa : sequence) {
            this.add(new Mass(aa.getMass()));
        }
        this.add(right);
        this.leftMass = left;
        this.sequence = sequence;
        this.rightMass = right;
        this.peaks = peaks;
        this.score = score;
    }

    public float getLeftMass() {
        return this.leftMass.getMass();
    }

    public String getTagStr() {
        return this.sequence.toString();
    }

    @Override
    public int compareTo(Tag other) {
        if (this.score > other.score) {
            return -1;
        }
        if (other.score > this.score) {
            return 1;
        }
        return 0;
    }

    @Override
    public String toString() {
        String retStr = "";
        retStr = retStr + "[" + this.leftMass.toString() + "]";
        retStr = retStr + this.sequence;
        retStr = retStr + "[" + this.rightMass.toString() + "]";
        return retStr + "\t" + this.score;
    }

    public float getRightMass() {
        return this.rightMass.getMass();
    }

    public float[] getMasses() {
        return null;
    }

    public static void main(String[] args) {
    }
}

