/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.params.ParamObject;
import edu.ucsd.msjava.params.UserParam;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;

public class Enzyme
implements ParamObject {
    private boolean isNTerm;
    private String name;
    private String description;
    private char[] residues;
    private boolean[] isResidueCleavable;
    private float peptideCleavageEfficiency = 0.0f;
    private float neighboringAACleavageEfficiency = 0.0f;
    private String psiCvAccession;
    public static final Enzyme UnspecificCleavage = new Enzyme("UnspecificCleavage", null, false, "unspecific cleavage", "MS:1001956");
    public static final Enzyme TRYPSIN = new Enzyme("Tryp", "KR", false, "Trypsin", "MS:1001251");
    public static final Enzyme CHYMOTRYPSIN;
    public static final Enzyme LysC;
    public static final Enzyme LysN;
    public static final Enzyme GluC;
    public static final Enzyme ArgC;
    public static final Enzyme AspN;
    public static final Enzyme ALP;
    public static final Enzyme NoCleavage;
    private static HashMap<String, Enzyme> enzymeTable;
    private static ArrayList<Enzyme> registeredEnzymeList;
    private static String customEnzymeFilePath;
    private static ArrayList<String> customEnzymeMessages;

    private Enzyme(String name, String residues, boolean isNTerm, String description, String psiCvAccession) {
        this.name = name;
        this.description = description;
        if (psiCvAccession != null && psiCvAccession.equals("MS:1001955")) {
            this.residues = new char[0];
            this.isResidueCleavable = new boolean[128];
        } else if (residues != null) {
            this.residues = new char[residues.length()];
            this.isResidueCleavable = new boolean[128];
            for (int i = 0; i < residues.length(); ++i) {
                char residue = residues.charAt(i);
                if (!Character.isUpperCase(residue)) {
                    System.err.println("Enzyme residues must be uppercase: " + residue);
                    System.exit(-1);
                }
                this.residues[i] = residue;
                this.isResidueCleavable[residue] = true;
            }
        }
        this.isNTerm = isNTerm;
        this.psiCvAccession = psiCvAccession;
    }

    public static void loadCustomEnzymeFile(File enzymeFile) {
        customEnzymeFilePath = enzymeFile.getAbsolutePath();
        int tokenLength = 4;
        ArrayList<String> paramLines = UserParam.parseFromFile(enzymeFile.getPath(), tokenLength);
        for (String paramLine : paramLines) {
            String[] token = paramLine.split(",", tokenLength);
            String shortName = token[0];
            String cleaveAt = token[1];
            if (cleaveAt.equalsIgnoreCase("null")) {
                cleaveAt = null;
            } else {
                for (int i = 0; i < cleaveAt.length(); ++i) {
                    if (AminoAcid.isStdAminoAcid(cleaveAt.charAt(i))) continue;
                    System.err.println("Invalid user-defined enzyme at " + enzymeFile.getAbsolutePath() + ": " + paramLine);
                    System.err.println("Unrecognizable amino acid residue: " + cleaveAt.charAt(i));
                    System.exit(-1);
                }
            }
            boolean isNTerm = false;
            if (token[2].equals("C")) {
                isNTerm = false;
            } else if (token[2].equals("N")) {
                isNTerm = true;
            } else {
                System.err.println("Invalid user-defined enzyme at " + enzymeFile.getAbsolutePath() + ": " + paramLine);
                System.err.println(token[2] + " must be 'C' or 'N' for C-terminal or N-terminal");
                System.exit(-1);
            }
            int commentCharIndex = token[3].indexOf(35);
            String description = commentCharIndex > 0 ? token[3].substring(0, commentCharIndex).trim() : token[3].trim();
            Enzyme userEnzyme = new Enzyme(shortName, cleaveAt, isNTerm, description, null);
            Enzyme.register(shortName, userEnzyme, true);
        }
    }

    private void setNeighboringAAEfficiency(float neighboringAACleavageEfficiency) {
        this.neighboringAACleavageEfficiency = neighboringAACleavageEfficiency;
    }

    @Deprecated
    public float getNeighboringAACleavageEffiency() {
        return this.getNeighboringAACleavageEfficiency();
    }

    public float getNeighboringAACleavageEfficiency() {
        return this.neighboringAACleavageEfficiency;
    }

    private void setPeptideCleavageEfficiency(float peptideCleavageEfficiency) {
        this.peptideCleavageEfficiency = peptideCleavageEfficiency;
    }

    public float getPeptideCleavageEfficiency() {
        return this.peptideCleavageEfficiency;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String getParamDescription() {
        return this.description;
    }

    public boolean isNTerm() {
        return this.isNTerm;
    }

    public boolean isCTerm() {
        return !this.isNTerm;
    }

    public boolean isCleavable(AminoAcid aa) {
        if (this.residues == null) {
            return true;
        }
        for (char r : this.residues) {
            if (r != aa.getUnmodResidue()) continue;
            return true;
        }
        return false;
    }

    public boolean isCleavable(char residue) {
        if (this.isResidueCleavable == null) {
            return true;
        }
        return this.isResidueCleavable[residue];
    }

    public boolean isCleaved(Peptide p) {
        AminoAcid aa = this.isNTerm ? p.get(0) : p.get(p.size() - 1);
        return this.isCleavable(aa.getResidue());
    }

    public String getPSICvAccession() {
        return this.psiCvAccession;
    }

    public int getNumCleavedTermini(String annotation, AminoAcidSet aaSet) {
        int nCT = 0;
        String pepStr = annotation.substring(annotation.indexOf(46) + 1, annotation.lastIndexOf(46));
        Peptide peptide = aaSet.getPeptide(pepStr);
        if (this.isCleaved(peptide)) {
            ++nCT;
        }
        if (this.isNTerm) {
            AminoAcid nextAA = aaSet.getAminoAcid(annotation.charAt(annotation.length() - 1));
            if (nextAA == null || this.isCleavable(nextAA)) {
                ++nCT;
            }
        } else {
            AminoAcid precedingAA = aaSet.getAminoAcid(annotation.charAt(0));
            if (precedingAA == null || this.isCleavable(precedingAA)) {
                ++nCT;
            }
        }
        return nCT;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public char[] getResidues() {
        return this.residues;
    }

    public static String getCustomEnzymeFilePath() {
        return customEnzymeFilePath;
    }

    public static ArrayList<String> getCustomEnzymeMessages() {
        return customEnzymeMessages;
    }

    public static Enzyme getEnzymeByName(String name) {
        return enzymeTable.get(name);
    }

    public static Enzyme[] getAllRegisteredEnzymes() {
        return registeredEnzymeList.toArray(new Enzyme[0]);
    }

    @Deprecated
    public static Enzyme register(String name, String residues, boolean isNTerm, String description) {
        return null;
    }

    private static void register(String name, Enzyme enzyme) {
        Enzyme.register(name, enzyme, false);
    }

    private static void register(String name, Enzyme enzyme, boolean notifyNewEnzyme) {
        if (enzymeTable.put(name, enzyme) == null) {
            registeredEnzymeList.add(enzyme);
            if (notifyNewEnzyme) {
                customEnzymeMessages.add("Added new enzyme " + enzyme.name + " with target residues " + new String(enzyme.getResidues()));
            }
        } else {
            int targetIndex = -1;
            for (int enzymeIndex = 0; enzymeIndex < registeredEnzymeList.size(); ++enzymeIndex) {
                Enzyme existingEnzyme = registeredEnzymeList.get(enzymeIndex);
                if (!existingEnzyme.name.equals(enzyme.name)) continue;
                String existingResidues = new String(existingEnzyme.residues);
                String newResidues = new String(enzyme.residues);
                if (!existingResidues.equals(newResidues)) {
                    customEnzymeMessages.add("Target residues for enzyme " + enzyme.name + " changed from " + existingResidues + " to " + newResidues);
                    targetIndex = enzymeIndex;
                    break;
                }
                if (existingEnzyme.description.equalsIgnoreCase(enzyme.description)) continue;
                targetIndex = enzymeIndex;
                break;
            }
            if (targetIndex >= 0) {
                registeredEnzymeList.set(targetIndex, enzyme);
            }
        }
    }

    static {
        TRYPSIN.setNeighboringAAEfficiency(0.99999f);
        TRYPSIN.setPeptideCleavageEfficiency(0.99999f);
        CHYMOTRYPSIN = new Enzyme("Chymotrypsin", "FYWL", false, "Chymotrypsin", "MS:1001306");
        LysC = new Enzyme("LysC", "K", false, "Lys-C", "MS:1001309");
        LysC.setNeighboringAAEfficiency(0.999f);
        LysC.setPeptideCleavageEfficiency(0.999f);
        LysN = new Enzyme("LysN", "K", true, "Lys-N", null);
        LysN.setNeighboringAAEfficiency(0.79f);
        LysN.setPeptideCleavageEfficiency(0.89f);
        GluC = new Enzyme("GluC", "E", false, "glutamyl endopeptidase", "MS:1001917");
        ArgC = new Enzyme("ArgC", "R", false, "Arg-C", "MS:1001303");
        AspN = new Enzyme("AspN", "D", true, "Asp-N", "MS:1001304");
        ALP = new Enzyme("aLP", null, false, "alphaLP", null);
        NoCleavage = new Enzyme("NoCleavage", null, false, "no cleavage", "MS:1001955");
        enzymeTable = new HashMap();
        registeredEnzymeList = new ArrayList();
        registeredEnzymeList.add(UnspecificCleavage);
        Enzyme.register(Enzyme.TRYPSIN.name, TRYPSIN);
        Enzyme.register(Enzyme.CHYMOTRYPSIN.name, CHYMOTRYPSIN);
        Enzyme.register(Enzyme.LysC.name, LysC);
        Enzyme.register(Enzyme.LysN.name, LysN);
        Enzyme.register(Enzyme.GluC.name, GluC);
        Enzyme.register(Enzyme.ArgC.name, ArgC);
        Enzyme.register(Enzyme.AspN.name, AspN);
        Enzyme.register(Enzyme.ALP.name, ALP);
        Enzyme.register(Enzyme.NoCleavage.name, NoCleavage);
        customEnzymeFilePath = "";
        customEnzymeMessages = new ArrayList();
        File enzymeFile = Paths.get("params", "enzymes.txt").toFile();
        if (enzymeFile.exists()) {
            Enzyme.loadCustomEnzymeFile(enzymeFile);
        }
    }
}

