/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msgf.NominalMass;
import edu.ucsd.msjava.msutil.Composition;
import java.util.Comparator;
import java.util.HashMap;

public class Modification {
    public static final double MOD_MASS_COMPARISON_THRESHOLD = 0.01;
    private final String name;
    private final double mass;
    private final int nominalMass;
    private String modId = "";
    private Composition composition;
    public static final Modification Carbamidomethyl = new Modification("Carbamidomethyl", new Composition(2, 3, 1, 1, 0));
    public static final Modification Carboxymethyl = new Modification("Carboxymethyl", new Composition(2, 2, 2, 0, 0));
    public static final Modification NIPCAM = new Modification("NIPCAM", new Composition(5, 9, 1, 1, 0));
    public static final Modification Oxidation = new Modification("Oxidation", new Composition(0, 0, 0, 1, 0));
    public static final Modification Phospho = new Modification("Phospho", Composition.getMass("HO3P"));
    public static final Modification Methyl = new Modification("Methyl", new Composition(1, 2, 0, 0, 0));
    public static final Modification PyroGluQ = new Modification("Gln->pyro-Glu", Composition.getMass("H-3N-1"));
    public static final Modification PyroGluE = new Modification("Glu->pyro-Glu", Composition.getMass("H-2O-1"));
    public static final Modification Carbamyl = new Modification("Carbamyl", new Composition(1, 1, 1, 1, 0));
    public static final Modification Acetyl = new Modification("Acetyl", new Composition(2, 2, 0, 1, 0));
    public static final Modification PyroCarbamidomethyl = new Modification("Pyro-carbamidomethyl", Composition.getMass("H-3N-1"));
    private static final Modification[] defaultModList = new Modification[]{Carbamidomethyl, Carboxymethyl, NIPCAM, Oxidation, Phospho, Methyl, PyroGluQ, PyroGluE, Carbamyl, Acetyl, PyroCarbamidomethyl};
    private static final HashMap<String, Modification> modTable = new HashMap();

    private Modification(String name, Composition composition) {
        this.name = name;
        this.mass = composition.getAccurateMass();
        this.nominalMass = composition.getNominalMass();
        this.composition = composition;
    }

    private Modification(String name, double mass) {
        this.name = name;
        this.mass = mass;
        this.nominalMass = NominalMass.toNominalMass((float)mass);
    }

    public String getName() {
        return this.name;
    }

    public float getMass() {
        return (float)this.mass;
    }

    public double getAccurateMass() {
        return this.mass;
    }

    public int getNominalMass() {
        return this.nominalMass;
    }

    public String getModId() {
        return this.modId;
    }

    public Composition getComposition() {
        if (this.composition == null) {
            return null;
        }
        return this.composition;
    }

    public static Modification[] getDefaultModList() {
        return defaultModList;
    }

    public static boolean isModConflict(String name, double mass) {
        return Modification.isModConflict(name, mass, 0.01);
    }

    public static boolean isModConflict(String name, double mass, double massTolerance) {
        Modification existingMod = modTable.get(name);
        if (existingMod == null) {
            return false;
        }
        return Math.abs(existingMod.mass - mass) > massTolerance;
    }

    public static boolean isModConflict(String name, Composition composition) {
        return Modification.isModConflict(name, composition.getAccurateMass(), 0.01);
    }

    public static boolean isModConflict(String name, Composition composition, double massTolerance) {
        return Modification.isModConflict(name, composition.getAccurateMass(), massTolerance);
    }

    public static Modification register(String modName, double mass) {
        Modification mod = new Modification(modName, mass);
        Modification.setModIdentifier(mod);
        modTable.put(modName, mod);
        return mod;
    }

    public static Modification register(String name, Composition composition) {
        Modification mod = new Modification(name, composition);
        Modification.setModIdentifier(mod);
        modTable.put(name, mod);
        return mod;
    }

    public static void setModIdentifiers() {
        for (Modification mod : modTable.values()) {
            if (!mod.getModId().equals("")) continue;
            Modification.setModIdentifier(mod);
        }
    }

    private static void setModIdentifier(Modification mod) {
        double mass = mod.getAccurateMass();
        String baseId = "";
        if (mass >= 0.0) {
            baseId = baseId + "+";
        }
        String id = baseId = baseId + Math.round(mod.getAccurateMass());
        int count = 0;
        while (true) {
            boolean foundConflict = false;
            for (Modification existing : modTable.values()) {
                boolean isFullMassMatch;
                if (!existing.modId.equals(id)) continue;
                boolean massMatch = Composition.equals(existing.composition, mod.composition);
                if (existing.composition == null) {
                    massMatch = existing.mass == mod.mass;
                }
                if (isFullMassMatch = existing.name.equals(mod.name) && massMatch) continue;
                foundConflict = true;
                break;
            }
            if (!foundConflict) break;
            id = baseId + "#" + ++count;
        }
        mod.modId = id;
    }

    public static Modification getModByName(String name) {
        return modTable.get(name);
    }

    static {
        for (Modification mod : defaultModList) {
            modTable.put(mod.getName(), mod);
        }
    }

    public static class MassComparator
    implements Comparator<Modification> {
        @Override
        public int compare(Modification a, Modification b) {
            return Double.compare(a.getAccurateMass(), b.getAccurateMass());
        }
    }

    public static class Instance {
        private final Modification mod;
        private final char residue;
        private Location location;
        private boolean isFixedModification = false;

        public Instance(Modification mod, char residue, Location location) {
            this.mod = mod;
            this.residue = residue;
            this.location = location;
        }

        public Instance(Modification mod, char residue) {
            this(mod, residue, Location.Anywhere);
        }

        public Instance fixedModification() {
            this.isFixedModification = true;
            return this;
        }

        public Modification getModification() {
            return this.mod;
        }

        public char getResidue() {
            return this.residue;
        }

        public Location getLocation() {
            return this.location;
        }

        public boolean isFixedModification() {
            return this.isFixedModification;
        }

        public String toString() {
            return this.mod.getName() + " " + this.residue + " " + (Object)((Object)this.location) + ", " + (this.isFixedModification ? "Fixed (static)" : "Variable (dynamic)");
        }

        public boolean equals(Object obj) {
            if (obj instanceof Instance) {
                Instance other = (Instance)obj;
                return this.mod == other.mod && this.residue == other.residue && this.location == other.location && this.isFixedModification == other.isFixedModification;
            }
            return false;
        }

        public int hashCode() {
            return this.mod.getName().hashCode() + new Character(this.residue).hashCode() + this.location.hashCode() + new Boolean(this.isFixedModification).hashCode();
        }
    }

    public static enum Location {
        Anywhere,
        N_Term,
        C_Term,
        Protein_N_Term,
        Protein_C_Term;

    }
}

