/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msutil.Composition;
import java.util.Comparator;

public class Peak
implements Comparable<Peak> {
    private int charge = 1;
    private float mz;
    private float intensity;
    private int index = -1;
    private int rank = 151;

    public Peak(float mz, float intensity, int charge) {
        this.mz = mz;
        this.intensity = intensity;
        this.charge = charge;
    }

    public int getIndex() {
        return this.index;
    }

    public float getMz() {
        return this.mz;
    }

    public float getMass() {
        Float monoMass = Float.valueOf((this.mz - (float)Composition.ChargeCarrierMass()) * (float)this.charge);
        if (monoMass.floatValue() > 0.0f) {
            return monoMass.floatValue();
        }
        return 0.0f;
    }

    public float getIntensity() {
        return this.intensity;
    }

    public int getCharge() {
        return this.charge;
    }

    public Peak getShiftedPeak(float mz) {
        Peak newPeak = new Peak(mz, this.intensity, this.charge);
        newPeak.rank = this.rank;
        newPeak.index = this.index;
        return newPeak;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public int getRank() {
        return this.rank;
    }

    public float getComplementMass(float parentMass) {
        return parentMass - this.getMass();
    }

    public void setIntensity(float intensity) {
        this.intensity = intensity;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setMz(float mz) {
        this.mz = mz;
    }

    public void setCharge(int charge) {
        this.charge = charge;
    }

    public float toUnitTolerance(float ppmTolerance) {
        return this.getMass() * ppmTolerance / 1000000.0f;
    }

    @Override
    public int compareTo(Peak p) {
        if (this.mz > p.mz) {
            return 1;
        }
        if (p.mz > this.mz) {
            return -1;
        }
        if (this.intensity > p.intensity) {
            return 1;
        }
        if (p.intensity > this.intensity) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        return (int)(this.mz + this.intensity + (float)this.charge);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Peak) {
            return this.equals((Peak)obj);
        }
        return false;
    }

    public boolean equals(Peak p) {
        return this.mz == p.mz && this.intensity == p.intensity && this.charge == p.charge;
    }

    public static float getAbsoluteMassDiff(Peak p1, Peak p2) {
        return Math.abs(p1.mz - p2.mz);
    }

    public String toString() {
        return this.mz + " " + this.intensity;
    }

    public Peak clone() {
        Peak p = new Peak(this.mz, this.intensity, this.charge);
        p.index = this.index;
        p.rank = this.rank;
        return p;
    }

    public Peak duplicate(float offset) {
        float mzOffset = offset / (float)this.charge;
        return new Peak(this.mz + mzOffset, this.intensity, this.charge);
    }

    public static class MassComparator
    implements Comparator<Peak> {
        @Override
        public int compare(Peak p1, Peak p2) {
            return p1.compareTo(p2);
        }

        public boolean equals(Peak p1, Peak p2) {
            return p1.equals(p2);
        }
    }

    public static class IntensityComparator
    implements Comparator<Peak> {
        @Override
        public int compare(Peak p1, Peak p2) {
            if (p1.intensity > p2.intensity) {
                return 1;
            }
            if (p2.intensity > p1.intensity) {
                return -1;
            }
            if (p1.mz > p2.mz) {
                return 1;
            }
            if (p2.mz > p1.mz) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Peak p1, Peak p2) {
            return p1.mz == p2.mz && p1.intensity == p2.intensity;
        }
    }
}

