/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.params.ParamObject;
import edu.ucsd.msjava.params.UserParam;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;

public class Protocol
implements ParamObject {
    private String name;
    private String description;
    public static final Protocol AUTOMATIC = new Protocol("Automatic", "Automatic");
    public static final Protocol PHOSPHORYLATION = new Protocol("Phosphorylation", "Phospho-enriched");
    public static final Protocol ITRAQ = new Protocol("iTRAQ", "iTRAQ");
    public static final Protocol ITRAQPHOSPHO = new Protocol("iTRAQPhospho", "iTRAQPhospho");
    public static final Protocol TMT = new Protocol("TMT", "TMT");
    public static final Protocol STANDARD = new Protocol("Standard", "Standard");
    private static HashMap<String, Protocol> table = new HashMap();
    private static ArrayList<Protocol> protocolList = new ArrayList();

    private Protocol(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String getParamDescription() {
        return this.name;
    }

    public static Protocol get(String name) {
        return table.get(name);
    }

    public static Protocol[] getAllRegisteredProtocols() {
        return protocolList.toArray(new Protocol[0]);
    }

    private static void add(Protocol prot) {
        if (table.put(prot.name, prot) == null) {
            protocolList.add(prot);
        }
    }

    static {
        protocolList.add(AUTOMATIC);
        Protocol.add(PHOSPHORYLATION);
        Protocol.add(ITRAQ);
        Protocol.add(ITRAQPHOSPHO);
        Protocol.add(TMT);
        Protocol.add(STANDARD);
        File protocolFile = Paths.get("params", "protocols.txt").toFile();
        if (protocolFile.exists()) {
            ArrayList<String> paramLines = UserParam.parseFromFile(protocolFile.getPath(), 2);
            for (String paramLine : paramLines) {
                String[] token = paramLine.split(",");
                String shortName = token[0];
                String description = token[1];
                Protocol newProt = new Protocol(shortName, description);
                Protocol.add(newProt);
            }
        }
    }
}

