/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msutil.FileFormat;
import java.util.ArrayList;

public class SpecFileFormat
extends FileFormat {
    private final String psiAccession;
    private final String psiName;
    public static final SpecFileFormat MGF = new SpecFileFormat(".mgf", "MS:1001062", "Mascot MGF file");
    public static final SpecFileFormat MZXML = new SpecFileFormat(".mzXML", "MS:1000566", "ISB mzXML file");
    public static final SpecFileFormat MZML = new SpecFileFormat(".mzML", "MS:1000584", "mzML file");
    public static final SpecFileFormat MS2 = new SpecFileFormat(".ms2", "MS:1001466", "MS2 file");
    public static final SpecFileFormat PKL = new SpecFileFormat(".pkl", "MS:1000565", "Micromass PKL file");
    public static final SpecFileFormat MZDATA = new SpecFileFormat(".mzData", "MS:1000564", "PSI mzData file");
    public static final SpecFileFormat DTA_TXT = new SpecFileFormat("_dta.txt", "MS:XXXXXXX", "PNNL dta.txt file");
    private static ArrayList<SpecFileFormat> specFileFormatList = new ArrayList();

    private SpecFileFormat(String suffix, String psiAccession, String psiName) {
        super(suffix);
        this.psiAccession = psiAccession;
        this.psiName = psiName;
    }

    public String getPSIAccession() {
        return this.psiAccession;
    }

    public String getPSIName() {
        return this.psiName;
    }

    public static SpecFileFormat getSpecFileFormat(String specFileName) {
        String lowerCaseFileName = specFileName.toLowerCase();
        for (SpecFileFormat f : specFileFormatList) {
            for (String suffix : f.getSuffixes()) {
                if (!lowerCaseFileName.endsWith(suffix.toLowerCase())) continue;
                return f;
            }
        }
        return null;
    }

    static {
        specFileFormatList.add(MGF);
        specFileFormatList.add(MZXML);
        specFileFormatList.add(MZML);
        specFileFormatList.add(MS2);
        specFileFormatList.add(PKL);
        specFileFormatList.add(MZDATA);
        specFileFormatList.add(DTA_TXT);
    }
}

