/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.Pair;
import edu.ucsd.msjava.msutil.Peak;
import edu.ucsd.msjava.msutil.SpectraAccessor;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.parser.MzXMLSpectraIterator;
import edu.ucsd.msjava.parser.SpectrumParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SpecKey
extends Pair<Integer, Integer> {
    private ArrayList<Integer> specIndexList;
    private float precursorMz;

    public SpecKey(int specIndex, int charge) {
        super(specIndex, charge);
    }

    public void setPrecursorMz(float precursorMz) {
        this.precursorMz = precursorMz;
    }

    public int getSpecIndex() {
        return (Integer)super.getFirst();
    }

    public int getCharge() {
        return (Integer)super.getSecond();
    }

    public float getPrecursorMz() {
        return this.precursorMz;
    }

    public String getSpecKeyString() {
        return this.getSpecIndex() + ":" + this.getCharge();
    }

    public static SpecKey getSpecKey(String specKeyString) {
        String[] token = specKeyString.split(":");
        return new SpecKey(Integer.parseInt(token[0]), Integer.parseInt(token[1]));
    }

    public void addSpecIndex(int scanNum) {
        if (this.specIndexList == null) {
            this.specIndexList = new ArrayList();
        }
        this.specIndexList.add(scanNum);
    }

    @Override
    public String toString() {
        return this.getSpecKeyString();
    }

    public ArrayList<Integer> getSpecIndexList() {
        return this.specIndexList;
    }

    public static ArrayList<SpecKey> getSpecKeyList(SpectraAccessor specAcc, int startSpecIndex, int endSpecIndex, int minCharge, int maxCharge, ActivationMethod activationMethod, int minNumPeaksPerSpectrum, boolean allowDenseCentroidedData) {
        long scanMissingWarningCount;
        Iterator<Spectrum> itr = specAcc.getSpecItr();
        ArrayList<SpecKey> specKeyList = SpecKey.getSpecKeyList(itr, startSpecIndex, endSpecIndex, minCharge, maxCharge, activationMethod, minNumPeaksPerSpectrum, allowDenseCentroidedData);
        SpectrumParser parser = specAcc.getSpectrumParser();
        if (parser != null && (scanMissingWarningCount = parser.getScanMissingWarningCount()) > 1L) {
            System.out.println("Unable to extract the scan number from " + scanMissingWarningCount + " spectra");
        }
        return specKeyList;
    }

    public static ArrayList<SpecKey> getSpecKeyList(Iterator<Spectrum> itr, int startSpecIndex, int endSpecIndex, int minCharge, int maxCharge, ActivationMethod activationMethod, int minNumPeaksPerSpectrum, boolean allowDenseCentroidedData) {
        if (activationMethod == ActivationMethod.FUSION) {
            return SpecKey.getFusedSpecKeyList(itr, startSpecIndex, endSpecIndex, minCharge, maxCharge);
        }
        ArrayList<SpecKey> specKeyList = new ArrayList<SpecKey>();
        int numProfileSpectra = 0;
        int numDenseCentroidedSpectra = 0;
        int numSpectraWithTooFewPeaks = 0;
        int MAX_INFORMATIVE_MESSAGES = 10;
        int informativeMessageCount = 0;
        while (itr.hasNext()) {
            Spectrum spec = itr.next();
            int specIndex = spec.getSpecIndex();
            if (specIndex < startSpecIndex || specIndex >= endSpecIndex) continue;
            spec.setChargeIfSinglyCharged();
            int charge = spec.getCharge();
            ActivationMethod specActivationMethod = spec.getActivationMethod();
            if (activationMethod != ActivationMethod.ASWRITTEN) {
                if (specActivationMethod != null) {
                    if (activationMethod == ActivationMethod.UVPD && specActivationMethod == ActivationMethod.HCD) {
                        if (informativeMessageCount < 10) {
                            System.out.println("Use spectrum " + spec.getID() + " since Thermo currently labels UVPD spectra as HCD");
                            ++informativeMessageCount;
                        } else if (informativeMessageCount == 10) {
                            System.out.println(" ...");
                            ++informativeMessageCount;
                        }
                    } else if (specActivationMethod != activationMethod) {
                        if (informativeMessageCount < 10) {
                            System.out.println("Skip spectrum " + spec.getID() + " since activationMethod is " + specActivationMethod.toString() + ", not " + activationMethod.toString());
                            ++informativeMessageCount;
                            continue;
                        }
                        if (informativeMessageCount != 10) continue;
                        System.out.println(" ...");
                        ++informativeMessageCount;
                        continue;
                    }
                } else if (informativeMessageCount < 10) {
                    System.out.println("Spectrum " + spec.getID() + " activationMethod is unknown; Using " + activationMethod.toString() + " as specified in parameters.");
                    ++informativeMessageCount;
                } else if (informativeMessageCount == 10) {
                    System.out.println(" ...");
                    ++informativeMessageCount;
                }
            }
            if (!(spec.isCentroided() || spec.isCentroidedWithDensePeaks() && allowDenseCentroidedData)) {
                String message = "Skip spectrum " + spec.getID() + " since ";
                if (spec.isCentroidedWithDensePeaks()) {
                    message = message + "peaks are too dense";
                    ++numDenseCentroidedSpectra;
                } else {
                    message = message + "it is not centroided";
                    ++numProfileSpectra;
                }
                if (informativeMessageCount < 10) {
                    System.out.println(message);
                    ++informativeMessageCount;
                    continue;
                }
                if (informativeMessageCount != 10) continue;
                System.out.println(" ...");
                ++informativeMessageCount;
                continue;
            }
            if (spec.size() < minNumPeaksPerSpectrum) {
                ++numSpectraWithTooFewPeaks;
                continue;
            }
            if (charge == 0) {
                for (int c = minCharge; c <= maxCharge; ++c) {
                    specKeyList.add(new SpecKey(specIndex, c));
                }
                continue;
            }
            if (charge <= 0) continue;
            specKeyList.add(new SpecKey(specIndex, charge));
        }
        System.out.println("Ignoring " + numProfileSpectra + " profile spectra.");
        System.out.println("Ignoring " + numSpectraWithTooFewPeaks + " spectra having less than " + minNumPeaksPerSpectrum + " peaks.");
        if (numDenseCentroidedSpectra > 0) {
            System.out.println("Ignoring " + numDenseCentroidedSpectra + " spectra marked as centroid with dense peaks (<50ppm median distance).\n    Re-run search with parameter '-allowDenseCentroidedPeaks 1' to include these spectra in the search");
        }
        return specKeyList;
    }

    public static ArrayList<SpecKey> getFusedSpecKeyList(Iterator<Spectrum> itr, int startSpecIndex, int endSpecIndex, int minCharge, int maxCharge) {
        HashMap<Peak, ArrayList<Integer>> precursorSpecIndexMap = new HashMap<Peak, ArrayList<Integer>>();
        while (itr.hasNext()) {
            ArrayList<Integer> list;
            Spectrum spec = itr.next();
            int specIndex = spec.getSpecIndex();
            if (specIndex < startSpecIndex || specIndex >= endSpecIndex) continue;
            Peak precursor = spec.getPrecursorPeak();
            if (spec.getActivationMethod() == null) {
                System.out.println("Error: activation method is not available: Scan=" + spec.getSpecIndex() + ", PrecursorMz=" + spec.getPrecursorPeak().getMz());
                System.exit(-1);
            }
            if ((list = (ArrayList<Integer>)precursorSpecIndexMap.get(precursor)) == null) {
                list = new ArrayList<Integer>();
                precursorSpecIndexMap.put(precursor, list);
            }
            list.add(specIndex);
        }
        Iterator mapItr = precursorSpecIndexMap.entrySet().iterator();
        ArrayList<SpecKey> specKeyList = new ArrayList<SpecKey>();
        while (mapItr.hasNext()) {
            Map.Entry entry = mapItr.next();
            Peak precursor = (Peak)entry.getKey();
            ArrayList list = (ArrayList)entry.getValue();
            Collections.sort(list);
            int charge = precursor.getCharge();
            if (charge == 0) {
                for (int c = minCharge; c <= maxCharge; ++c) {
                    SpecKey specKey = new SpecKey((Integer)list.get(0), c);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        int specIndex = (Integer)iterator.next();
                        specKey.addSpecIndex(specIndex);
                    }
                    specKeyList.add(specKey);
                }
                continue;
            }
            if (charge > 0) {
                SpecKey specKey = new SpecKey((Integer)list.get(0), charge);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    int specIndex = (Integer)iterator.next();
                    specKey.addSpecIndex(specIndex);
                }
                specKeyList.add(specKey);
                continue;
            }
            System.out.println("Error: negative precursor charge: " + precursor);
            System.exit(-1);
        }
        return specKeyList;
    }

    public static void main(String[] argv) throws Exception {
        SpecKey.test();
    }

    public static void test() throws Exception {
        String fileName = "/home/sangtaekim/Research/Data/HeckRevision/CIDETDPairs/mzXML/090121_NM_Trypsin_20.mzXML";
        int minCharge = 2;
        int maxCharge = 3;
        MzXMLSpectraIterator itr = new MzXMLSpectraIterator(fileName);
        ArrayList<SpecKey> list = SpecKey.getFusedSpecKeyList(itr, 0, Integer.MAX_VALUE, minCharge, maxCharge);
        for (SpecKey specKey : list) {
            if (specKey.getSpecIndexList() != null && specKey.getSpecIndexList().size() == 2) continue;
            System.out.println(specKey.getSpecKeyString() + "\t" + specKey.getSpecIndexList());
        }
        System.out.println("Size: " + list.size());
    }
}

