/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msutil.SpecFileFormat;
import edu.ucsd.msjava.msutil.SpectraIterator;
import edu.ucsd.msjava.msutil.SpectraMap;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.msutil.SpectrumAccessorBySpecIndex;
import edu.ucsd.msjava.mzid.Constants;
import edu.ucsd.msjava.mzml.MzMLAdapter;
import edu.ucsd.msjava.mzml.MzMLSpectraIterator;
import edu.ucsd.msjava.mzml.MzMLSpectraMap;
import edu.ucsd.msjava.parser.MS2SpectrumParser;
import edu.ucsd.msjava.parser.MgfSpectrumParser;
import edu.ucsd.msjava.parser.MzXMLSpectraIterator;
import edu.ucsd.msjava.parser.MzXMLSpectraMap;
import edu.ucsd.msjava.parser.PNNLSpectraIterator;
import edu.ucsd.msjava.parser.PNNLSpectraMap;
import edu.ucsd.msjava.parser.PklSpectrumParser;
import edu.ucsd.msjava.parser.SpectrumParser;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import uk.ac.ebi.jmzidml.model.mzidml.CvParam;

public class SpectraAccessor {
    private final File specFile;
    private final SpecFileFormat specFormat;
    private SpectrumParser spectrumParser;
    private MzMLAdapter mzmlAdapter = null;
    SpectrumAccessorBySpecIndex specMap = null;
    Iterator<Spectrum> specItr = null;

    public SpectraAccessor(File specFile) {
        this(specFile, SpecFileFormat.getSpecFileFormat(specFile.getName()));
    }

    public SpectraAccessor(File specFile, SpecFileFormat specFormat) {
        this.specFile = specFile;
        this.specFormat = specFormat;
        this.spectrumParser = null;
    }

    public SpectrumAccessorBySpecIndex getSpecMap() {
        if (this.specMap == null) {
            if (this.specFormat == SpecFileFormat.MZXML) {
                this.specMap = new MzXMLSpectraMap(this.specFile.getPath());
            } else if (this.specFormat == SpecFileFormat.MZML) {
                if (this.mzmlAdapter == null) {
                    this.mzmlAdapter = new MzMLAdapter(this.specFile);
                }
                this.specMap = new MzMLSpectraMap(this.mzmlAdapter);
            } else if (this.specFormat == SpecFileFormat.DTA_TXT) {
                this.specMap = new PNNLSpectraMap(this.specFile.getPath());
            } else {
                SpectrumParser parser = null;
                if (this.specFormat == SpecFileFormat.MGF) {
                    parser = new MgfSpectrumParser();
                } else if (this.specFormat == SpecFileFormat.MS2) {
                    parser = new MS2SpectrumParser();
                } else if (this.specFormat == SpecFileFormat.PKL) {
                    parser = new PklSpectrumParser();
                } else {
                    return null;
                }
                this.spectrumParser = parser;
                this.specMap = new SpectraMap(this.specFile.getPath(), parser);
            }
        }
        if (this.specMap == null) {
            System.out.println("No spectra were found");
            System.out.println("File: " + this.specFile.getAbsolutePath());
            System.out.println("Format: " + this.specFormat.getPSIName());
        }
        return this.specMap;
    }

    public Iterator<Spectrum> getSpecItr() {
        if (this.specItr == null) {
            if (this.specFormat == SpecFileFormat.MZXML) {
                this.specItr = new MzXMLSpectraIterator(this.specFile.getPath());
            } else if (this.specFormat == SpecFileFormat.MZML) {
                if (this.mzmlAdapter == null) {
                    this.mzmlAdapter = new MzMLAdapter(this.specFile);
                }
                this.specItr = new MzMLSpectraIterator(this.mzmlAdapter);
            } else if (this.specFormat == SpecFileFormat.DTA_TXT) {
                try {
                    this.specItr = new PNNLSpectraIterator(this.specFile.getPath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                SpectrumParser parser = null;
                if (this.specFormat == SpecFileFormat.MGF) {
                    parser = new MgfSpectrumParser();
                } else if (this.specFormat == SpecFileFormat.MS2) {
                    parser = new MS2SpectrumParser();
                } else if (this.specFormat == SpecFileFormat.PKL) {
                    parser = new PklSpectrumParser();
                } else {
                    return null;
                }
                this.spectrumParser = parser;
                try {
                    this.specItr = new SpectraIterator(this.specFile.getPath(), parser);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.specItr;
    }

    public Spectrum getSpectrumBySpecIndex(int specIndex) {
        return this.getSpecMap().getSpectrumBySpecIndex(specIndex);
    }

    public Spectrum getSpectrumById(String specId) {
        return this.getSpecMap().getSpectrumById(specId);
    }

    public SpectrumParser getSpectrumParser() {
        return this.spectrumParser;
    }

    public String getID(int specIndex) {
        return this.getSpecMap().getID(specIndex);
    }

    public float getPrecursorMz(int specIndex) {
        return this.getSpecMap().getPrecursorMz(specIndex).floatValue();
    }

    public String getTitle(int specIndex) {
        return this.getSpecMap().getTitle(specIndex);
    }

    public CvParam getSpectrumIDFormatCvParam() {
        CvParam cvParam = null;
        if (this.specFormat == SpecFileFormat.DTA_TXT || this.specFormat == SpecFileFormat.MGF || this.specFormat == SpecFileFormat.PKL || this.specFormat == SpecFileFormat.MS2) {
            cvParam = Constants.makeCvParam("MS:1000774", "multiple peak list nativeID format");
        } else if (this.specFormat == SpecFileFormat.MZXML) {
            cvParam = Constants.makeCvParam("MS:1000776", "scan number only nativeID format");
        } else if (this.specFormat == SpecFileFormat.MZDATA) {
            cvParam = Constants.makeCvParam("MS:1000777", "spectrum identifier nativeID format");
        } else if (this.specFormat == SpecFileFormat.MZML) {
            if (this.mzmlAdapter == null) {
                this.mzmlAdapter = new MzMLAdapter(this.specFile);
            }
            cvParam = this.mzmlAdapter.getSpectrumIDFormatCvParam();
        }
        return cvParam;
    }
}

