/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.Composition;
import edu.ucsd.msjava.msutil.CvParamInfo;
import edu.ucsd.msjava.msutil.Peak;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.msutil.SpecFileFormat;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class Spectrum
extends ArrayList<Peak>
implements Comparable<Spectrum> {
    private static final long serialVersionUID = 1L;
    private Peak precursor = null;
    private String id;
    private int startScanNum = -1;
    private int endScanNum = -1;
    private int specIndex = -1;
    private String title = null;
    private Peptide annotation = null;
    private ArrayList<String> seqList = null;
    private float rt = -1.0f;
    private boolean rtIsSeconds = true;
    private ActivationMethod activationMethod = null;
    private int msLevel = 2;
    private Polarity scanPolarity = Polarity.POSITIVE;
    private Boolean isCentroided = true;
    private Boolean externalSetIsCentroided = false;
    private Boolean isCentroidedWithDensePeaks = false;
    private boolean isHighPrecision = false;
    private ArrayList<CvParamInfo> addlCvParams;
    private Float isolationWindowTargetMz = null;

    public Spectrum() {
    }

    public Spectrum(Peak precursorPeak) {
        this.precursor = precursorPeak;
    }

    public Spectrum(float precursorMz, int charge, float precursorIntensity) {
        this.precursor = new Peak(precursorMz, precursorIntensity, charge);
    }

    public String getID() {
        return this.id;
    }

    public Peptide getAnnotation() {
        return this.annotation;
    }

    public String getAnnotationStr() {
        if (this.annotation != null) {
            return this.annotation.toString();
        }
        return null;
    }

    public ArrayList<String> getSeqList() {
        return this.seqList;
    }

    public int getCharge() {
        return this.precursor.getCharge();
    }

    public int getEndScanNum() {
        return this.endScanNum;
    }

    @Deprecated
    public float getParentMass() {
        return this.getPrecursorMass();
    }

    public float getPrecursorMass() {
        return this.precursor.getMass();
    }

    public float getPeptideMass() {
        Float peptideMass = Float.valueOf(this.precursor.getMass());
        if (peptideMass.floatValue() > 0.0f) {
            return peptideMass.floatValue() - 18.010565f;
        }
        return 0.0f;
    }

    public Peak getPrecursorPeak() {
        return this.precursor;
    }

    public int getScanNum() {
        return this.getStartScanNum();
    }

    public int getSpecIndex() {
        return this.specIndex;
    }

    public int getStartScanNum() {
        return this.startScanNum;
    }

    public String getTitle() {
        return this.title;
    }

    public float getRt() {
        return this.rt;
    }

    public boolean getRtIsSeconds() {
        return this.rtIsSeconds;
    }

    public ActivationMethod getActivationMethod() {
        return this.activationMethod;
    }

    public Polarity getScanPolarity() {
        return this.scanPolarity;
    }

    public boolean isCentroided() {
        return this.isCentroided;
    }

    public boolean isCentroidedWithDensePeaks() {
        return this.isCentroidedWithDensePeaks;
    }

    public boolean isHighPrecision() {
        return this.isHighPrecision;
    }

    public int getMSLevel() {
        return this.msLevel;
    }

    public ArrayList<CvParamInfo> getAddlCvParams() {
        return this.addlCvParams;
    }

    public void setID(String id) {
        this.id = id;
    }

    public void setAnnotation(Peptide annotation) {
        this.annotation = annotation;
    }

    public void addSEQ(String seq) {
        if (this.seqList == null) {
            this.seqList = new ArrayList();
        }
        this.seqList.add(seq);
    }

    public void setPrecursor(Peak precursor) {
        this.precursor = precursor;
    }

    public void setStartScanNum(int startScanNum) {
        this.startScanNum = startScanNum;
    }

    public void setEndScanNum(int endScanNum) {
        this.endScanNum = endScanNum;
    }

    public void setScanNum(int scanNum) {
        this.startScanNum = scanNum;
    }

    public void setSpecIndex(int specIndex) {
        this.specIndex = specIndex;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setRt(float rt) {
        this.rt = rt;
    }

    public void setRtIsSeconds(boolean isSeconds) {
        this.rtIsSeconds = isSeconds;
    }

    public void setActivationMethod(ActivationMethod fragMethod) {
        this.activationMethod = fragMethod;
    }

    public void setMsLevel(int msLevel) {
        this.msLevel = msLevel;
    }

    public void setScanPolarity(Polarity scanPolarity) {
        this.scanPolarity = scanPolarity;
    }

    public void setIsCentroided(boolean isCentroided) {
        this.isCentroided = isCentroided;
        this.externalSetIsCentroided = true;
    }

    public void setIsHighPrecision(boolean isHighPrecision) {
        this.isHighPrecision = isHighPrecision;
    }

    public void setIsolationWindowTargetMz(Float isolationWindowTargetMz) {
        this.isolationWindowTargetMz = isolationWindowTargetMz;
    }

    public Float getIsolationWindowTargetMz() {
        return this.isolationWindowTargetMz;
    }

    public void determineIsCentroided() {
        boolean centroidedCheckPass = true;
        if (this.size() > 0) {
            ArrayList<Float> diff = new ArrayList<Float>();
            float prevMz = ((Peak)this.get(0)).getMz();
            for (int i = 1; i < this.size(); ++i) {
                if (((Peak)this.get(i)).getIntensity() == 0.0f) continue;
                float curMz = ((Peak)this.get(i)).getMz();
                diff.add(Float.valueOf((curMz - prevMz) / curMz * 1000000.0f));
                prevMz = curMz;
            }
            Collections.sort(diff);
            if (diff.size() > 0 && ((Float)diff.get(diff.size() / 2)).floatValue() < 50.0f) {
                centroidedCheckPass = false;
            }
        }
        if (centroidedCheckPass) {
            this.isCentroided = true;
        } else {
            if (this.isCentroided.booleanValue() && this.externalSetIsCentroided.booleanValue()) {
                this.isCentroidedWithDensePeaks = true;
            }
            this.isCentroided = false;
        }
    }

    public void setChargeIfSinglyCharged() {
        if (this.precursor == null || this.precursor.getCharge() != 0) {
            return;
        }
        float tic = 0.0f;
        float ticBelowPrecursor = 0.0f;
        float precursorMz = this.precursor.getMz();
        for (Peak p : this) {
            tic += p.getIntensity();
            if (!(p.getMz() < precursorMz)) continue;
            ticBelowPrecursor += p.getIntensity();
        }
        if (ticBelowPrecursor / tic > 0.9f) {
            this.precursor.setCharge(1);
        }
    }

    public void addAddlCvParam(CvParamInfo cvParam) {
        if (this.addlCvParams == null) {
            this.addlCvParams = new ArrayList();
        }
        this.addlCvParams.add(cvParam);
    }

    @Override
    public String toString() {
        return "Spectrum - mz: " + this.getPrecursorPeak().getMz() + ", peaks: " + this.size();
    }

    public Spectrum getCloneWithoutPeakList() {
        Spectrum newSpec = new Spectrum();
        newSpec.precursor = this.precursor.clone();
        newSpec.startScanNum = this.startScanNum;
        newSpec.endScanNum = this.endScanNum;
        newSpec.title = this.title;
        newSpec.seqList = this.seqList;
        newSpec.annotation = this.annotation;
        newSpec.seqList = this.seqList;
        return newSpec;
    }

    public Spectrum getDeconvolutedSpectrum(float toleranceBetweenIsotopes) {
        int charge = this.getCharge();
        if (charge == 0) {
            return null;
        }
        Spectrum deconvSpec = this.getCloneWithoutPeakList();
        boolean[] ignore = new boolean[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            if (ignore[i]) continue;
            Peak p = (Peak)this.get(i);
            float pMz = p.getMz();
            for (int ionCharge = 2; ionCharge < charge && ionCharge < 4; ++ionCharge) {
                boolean isDeconvoluted = false;
                for (int j = i + 1; j < this.size(); ++j) {
                    Peak p2 = (Peak)this.get(j);
                    float diff = p2.getMz() - pMz - 1.0033548f / (float)ionCharge;
                    if (diff > -toleranceBetweenIsotopes && diff < toleranceBetweenIsotopes) {
                        ignore[j] = true;
                        p.setMz((float)ionCharge * p.getMz() - (float)(ionCharge - 1) * (float)Composition.ChargeCarrierMass());
                        isDeconvoluted = true;
                        float p2Mz = p2.getMz();
                        for (int k = j + 1; k < this.size(); ++k) {
                            Peak p3 = (Peak)this.get(k);
                            float diff2 = p3.getMz() - p2Mz - 0.99988616f / (float)ionCharge;
                            if (diff2 > -toleranceBetweenIsotopes && diff2 < toleranceBetweenIsotopes) {
                                ignore[k] = true;
                                p3.setMz((float)ionCharge * p3.getMz() - (float)(ionCharge - 1) * (float)Composition.ChargeCarrierMass());
                                deconvSpec.add(p3);
                                break;
                            }
                            if (diff2 > toleranceBetweenIsotopes) break;
                        }
                        p2.setMz((float)ionCharge * p2.getMz() - (float)(ionCharge - 1) * (float)Composition.ChargeCarrierMass());
                        deconvSpec.add(p2);
                        break;
                    }
                    if (diff > toleranceBetweenIsotopes) break;
                }
                if (isDeconvoluted) break;
            }
            deconvSpec.add(p);
        }
        Collections.sort(deconvSpec, new Peak.MassComparator());
        return deconvSpec;
    }

    public void addPeak(Peak peak) {
        this.add(peak);
    }

    public void correctParentMass() {
        if (this.annotation == null || this.getCharge() <= 0) {
            return;
        }
        this.precursor.setMz((this.annotation.getParentMass() + (float)this.precursor.getCharge() * (float)Composition.ChargeCarrierMass()) / (float)this.precursor.getCharge());
    }

    public void correctParentMass(float parentMass) {
        this.precursor.setMz((parentMass + (float)this.precursor.getCharge() * (float)Composition.ChargeCarrierMass()) / (float)this.precursor.getCharge());
    }

    public void correctParentMass(Peptide pep) {
        if (this.getCharge() <= 0) {
            return;
        }
        this.precursor.setMz((pep.getParentMass() + (float)this.precursor.getCharge() * (float)Composition.ChargeCarrierMass()) / (float)this.precursor.getCharge());
    }

    public void setCharge(int charge) {
        this.precursor.setCharge(charge);
    }

    public void setPrecursorCharge(int charge) {
        this.precursor.setCharge(charge);
    }

    public ArrayList<Peak> getPeakListByMass(float mass, Tolerance tolerance) {
        float toleranceDa = tolerance.getToleranceAsDa(mass, this.getCharge());
        return this.getPeakListByMassRange(mass - toleranceDa, mass + toleranceDa);
    }

    public ArrayList<Peak> getPeakListByMz(float mz, Tolerance tolerance) {
        float toleranceDa = tolerance.getToleranceAsDa(mz);
        return this.getPeakListByMassRange(mz - toleranceDa, mz + toleranceDa);
    }

    public Peak getPeakByMass(float mass, Tolerance tolerance) {
        ArrayList<Peak> matchList = this.getPeakListByMass(mass, tolerance);
        if (matchList == null || matchList.size() == 0) {
            return null;
        }
        return Collections.max(matchList, new IntensityComparator());
    }

    public ArrayList<Peak> getPeakListByMassRange(float minMass, float maxMass) {
        Peak p;
        ArrayList<Peak> matchList = new ArrayList<Peak>();
        int start = Collections.binarySearch(this, new Peak(minMass, 0.0f, 0));
        if (start < 0) {
            start = -start - 1;
        }
        for (int i = start; i < this.size() && !((p = (Peak)this.get(i)).getMz() > maxMass); ++i) {
            matchList.add(p);
        }
        return matchList;
    }

    public void setRanksOfPeaks() {
        ArrayList<Peak> intensitySorted = new ArrayList<Peak>(this);
        Collections.sort(intensitySorted, Collections.reverseOrder(new IntensityComparator()));
        for (int i = 0; i < intensitySorted.size(); ++i) {
            intensitySorted.get(i).setRank(i + 1);
        }
    }

    @Deprecated
    public void filterPrecursorPeaks(Tolerance tolerance) {
        this.filterPrecursorPeaks(tolerance, 0, 0.0f);
    }

    public void filterPrecursorPeaks(Tolerance tolerance, int reducedCharge, float offset) {
        int c = this.getCharge() - reducedCharge;
        float mass = (this.getPrecursorMass() + (float)c * (float)Composition.ChargeCarrierMass()) / (float)c + offset;
        for (Peak p : this.getPeakListByMass(mass, tolerance)) {
            p.setIntensity(0.0f);
        }
    }

    public void filterPrecursorPeaksAroundPM() {
        float m;
        int nominalMass;
        for (int i = 0; i < this.size(); ++i) {
            float m2 = ((Peak)this.get(i)).getMass();
            int nominalMass2 = Math.round(m2 * 0.999497f);
            if (nominalMass2 >= 38) continue;
            ((Peak)this.get(i)).setIntensity(0.0f);
        }
        int nominalPM = Math.round((this.getPrecursorMass() - 18.010565f) * 0.999497f);
        for (int i = this.size() - 1; i >= 0 && nominalPM - (nominalMass = Math.round((m = ((Peak)this.get(i)).getMass()) * 0.999497f)) < 38; --i) {
            ((Peak)this.get(i)).setIntensity(0.0f);
        }
    }

    @Override
    public int compareTo(Spectrum s) {
        if (this.getPrecursorMass() > s.getPrecursorMass()) {
            return 1;
        }
        if (this.getPrecursorMass() < s.getPrecursorMass()) {
            return -1;
        }
        return 0;
    }

    public void outputMgf(PrintStream out) {
        this.outputMgf(out, true);
    }

    public void outputMgf(PrintStream out, boolean writeActivationMethod) {
        out.println("BEGIN IONS");
        if (this.title != null) {
            out.println("TITLE=" + this.getTitle());
        } else {
            out.println("TITLE=" + this.id);
        }
        if (this.annotation != null) {
            out.println("SEQ=" + this.getAnnotationStr());
        }
        if (this.getActivationMethod() != null && writeActivationMethod) {
            out.println("ACTIVATION=" + this.getActivationMethod().getName());
        }
        float precursorMz = this.precursor.getMz();
        out.println("PEPMASS=" + precursorMz);
        if (this.startScanNum > 0) {
            out.println("SCANS=" + this.startScanNum);
        }
        int charge = this.getCharge();
        out.println("CHARGE=" + charge + (charge > 0 ? "+" : ""));
        for (Peak p : this) {
            if (!(p.getIntensity() > 0.0f)) continue;
            out.println(p.getMz() + "\t" + p.getIntensity());
        }
        out.println("END IONS");
    }

    public void outputDta(String fileName) {
        PrintStream out = null;
        try {
            out = new PrintStream(new BufferedOutputStream(new FileOutputStream(fileName)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        out.println((double)this.getPrecursorMass() + Composition.ChargeCarrierMass() + "\t" + this.getPrecursorPeak().getCharge());
        for (Peak p : this) {
            out.println(p.getMz() + "\t" + p.getIntensity());
        }
        out.close();
    }

    public String toDta() {
        StringBuffer sb = new StringBuffer();
        sb.append((double)this.getPrecursorMass() + Composition.ChargeCarrierMass() + "\t" + this.getPrecursorPeak().getCharge() + "\n");
        for (Peak p : this) {
            sb.append(p.getMz() + "\t" + p.getIntensity() + "\n");
        }
        return sb.toString();
    }

    public static SpecFileFormat getSpectrumFileFormat(String specFileName) {
        String suffix;
        SpecFileFormat specFormat = null;
        int posDot = specFileName.lastIndexOf(46);
        if (posDot >= 0) {
            String extension = specFileName.substring(posDot);
            if (extension.equalsIgnoreCase(".mzXML") || extension.equalsIgnoreCase(".mzML")) {
                specFormat = SpecFileFormat.MZXML;
            } else if (extension.equalsIgnoreCase(".mgf")) {
                specFormat = SpecFileFormat.MGF;
            } else if (extension.equalsIgnoreCase(".ms2")) {
                specFormat = SpecFileFormat.MS2;
            } else if (extension.equalsIgnoreCase(".pkl")) {
                specFormat = SpecFileFormat.PKL;
            }
        }
        if (specFormat == null && specFileName.length() > 8 && (suffix = specFileName.substring(specFileName.length() - 8)).equalsIgnoreCase("_dta.txt")) {
            specFormat = SpecFileFormat.DTA_TXT;
        }
        return specFormat;
    }

    class IntensityComparator
    implements Comparator<Peak> {
        IntensityComparator() {
        }

        @Override
        public int compare(Peak o1, Peak o2) {
            if (o1.getIntensity() > o2.getIntensity()) {
                return 1;
            }
            if (o2.getIntensity() > o1.getIntensity()) {
                return -1;
            }
            if (o1.getMz() > o2.getMz()) {
                return 1;
            }
            if (o2.getMz() > o1.getMz()) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Peak o1, Peak o2) {
            return this.compare(o1, o2) == 0;
        }
    }

    public static enum Polarity {
        POSITIVE,
        NEGATIVE;

    }
}

