/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.IonType;
import edu.ucsd.msjava.msutil.Peak;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.msutil.Spectrum;
import java.util.ArrayList;

public class SpectrumAnnotator {
    Spectrum spec;
    Peptide peptide;

    public SpectrumAnnotator(Spectrum spec, Peptide peptide) {
        this.spec = spec;
        this.peptide = peptide;
    }

    public ArrayList<Peak> getPeakListOfIon(IonType ionType, Tolerance tolerance) {
        ArrayList<Peak> peakList = new ArrayList<Peak>();
        float prm = 0.0f;
        float prmSum = this.peptide.getMass();
        for (AminoAcid aa : this.peptide) {
            float mass = ionType instanceof IonType.PrefixIon ? ionType.getMz(prm) : ionType.getMz(prmSum - (prm += aa.getMass()));
            Peak p = this.spec.getPeakByMass(mass, tolerance);
            if (p == null) continue;
            peakList.add(p);
        }
        return peakList;
    }

    public ArrayList<Float> getPeakErrorPPMOfIon(IonType ionType, Tolerance tolerance) {
        ArrayList<Float> errorList = new ArrayList<Float>();
        float prm = 0.0f;
        float prmSum = this.peptide.getMass();
        for (AminoAcid aa : this.peptide) {
            float mass = ionType instanceof IonType.PrefixIon ? ionType.getMz(prm) : ionType.getMz(prmSum - (prm += aa.getMass()));
            Peak p = this.spec.getPeakByMass(mass, tolerance);
            if (p == null) continue;
            errorList.add(Float.valueOf((p.getMz() - mass) * 1000000.0f / mass));
        }
        return errorList;
    }

    public ArrayList<Float> getPeakErrorOfIon(IonType ionType, Tolerance tolerance) {
        ArrayList<Float> errorList = new ArrayList<Float>();
        float prm = 0.0f;
        float prmSum = this.peptide.getMass();
        for (AminoAcid aa : this.peptide) {
            float mass = ionType instanceof IonType.PrefixIon ? ionType.getMz(prm) : ionType.getMz(prmSum - (prm += aa.getMass()));
            Peak p = this.spec.getPeakByMass(mass, tolerance);
            if (p == null) continue;
            errorList.add(Float.valueOf(p.getMz() - mass));
        }
        return errorList;
    }

    public ArrayList<Integer> getCoveredCleavages(IonType[] ionTypes, Tolerance tolerance) {
        float prm = 0.0f;
        float prmSum = this.peptide.getMass();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        block0: for (int i = 0; i < this.peptide.size() - 1; ++i) {
            prm += this.peptide.get(i).getMass();
            for (IonType ionType : ionTypes) {
                float mass = ionType instanceof IonType.PrefixIon ? ionType.getMz(prm) : ionType.getMz(prmSum - prm);
                Peak p = this.spec.getPeakByMass(mass, tolerance);
                if (p == null) continue;
                indices.add(i + 1);
                continue block0;
            }
        }
        return indices;
    }

    public float getCoverage(IonType[] ionTypes, Tolerance tolerance) {
        return (float)this.getCoveredCleavages(ionTypes, tolerance).size() / (float)(this.peptide.size() - 1);
    }
}

