/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.mzid;

import uk.ac.ebi.jmzidml.model.mzidml.AnalysisSoftware;
import uk.ac.ebi.jmzidml.model.mzidml.Cv;
import uk.ac.ebi.jmzidml.model.mzidml.CvParam;
import uk.ac.ebi.jmzidml.model.mzidml.Param;
import uk.ac.ebi.jmzidml.model.mzidml.UserParam;

public class Constants {
    static String analysisSoftID = "ID_software";
    static String providerID = "ID_provider";
    static String siListID = "SI_LIST_1";
    static String sirID = "SIR_";
    static String siiID = "SII_";
    static String spectraDataID = "SID_1";
    static String psiCvID = "PSI-MS";
    static String siProtocolID = "SearchProtocol_1";
    static String massTableID = "MassTable_1";
    static String searchDBID = "SearchDB_1";
    static String pepEvidenceListID = "PepEvidList_1";
    static String specIdentID = "SpecIdent_1";
    static String unimodID = "UNIMOD";
    static String unitCvID = "UO";
    static String measureMzID = "Measure_MZ";
    static String measureIntID = "Measure_Int";
    static String measureErrorID = "Measure_Error";
    static String sourceFileID = "SourceFile_1";
    static String pepIDPrefix = "Pep_";
    static String pepEvIDPrefix = "PepEv_";
    static final String UNIMOD_RESOURCE_PATH = "unimod.obo";
    static Cv psiCV = new Cv();
    static Cv unimodCV;
    static Cv unitCV;
    static AnalysisSoftware msgfPlus;

    public static CvParam makeCvParam(String accession, String name) {
        return Constants.makeCvParam(accession, name, psiCV);
    }

    public static CvParam makeCvParam(String accession, String name, Cv cv) {
        CvParam cvParam = new CvParam();
        cvParam.setAccession(accession);
        cvParam.setName(name);
        cvParam.setCv(cv);
        return cvParam;
    }

    public static CvParam makeCvParam(String accession, String name, Cv cv, String unitAccession, String unitName, Cv alternateUnitCV) {
        CvParam cvParam = Constants.makeCvParam(accession, name, cv);
        cvParam.setUnitAccession(unitAccession);
        cvParam.setUnitCv(alternateUnitCV);
        cvParam.setUnitName(unitName);
        return cvParam;
    }

    public static UserParam makeUserParam(String name) {
        UserParam userParam = new UserParam();
        userParam.setName(name);
        return userParam;
    }

    public static UserParam makeUserParam(String name, String value) {
        UserParam userParam = new UserParam();
        userParam.setName(name);
        userParam.setValue(value);
        return userParam;
    }

    public static CvParam getCvParamWithMassUnits(Boolean isDaltonUnit) {
        CvParam cvParam = new CvParam();
        cvParam.setCv(psiCV);
        cvParam.setUnitCv(unitCV);
        if (isDaltonUnit.booleanValue()) {
            cvParam.setUnitAccession("UO:0000221");
            cvParam.setUnitName("dalton");
        } else {
            cvParam.setUnitAccession("UO:0000169");
            cvParam.setUnitName("parts per million");
        }
        return cvParam;
    }

    static {
        psiCV.setUri("https://raw.githubusercontent.com/HUPO-PSI/psi-ms-CV/master/psi-ms.obo");
        psiCV.setId(psiCvID);
        psiCV.setVersion("3.30.0");
        psiCV.setFullName("PSI-MS");
        unimodCV = new Cv();
        unimodCV.setUri("http://www.unimod.org/obo/unimod.obo");
        unimodCV.setId(unimodID);
        unimodCV.setFullName("UNIMOD");
        unitCV = new Cv();
        unitCV.setUri("https://raw.githubusercontent.com/bio-ontology-research-group/unit-ontology/master/unit.obo");
        unitCV.setId(unitCvID);
        unitCV.setFullName("UNIT-ONTOLOGY");
        msgfPlus = new AnalysisSoftware();
        msgfPlus.setName("MS-GF+");
        Param tempParam = new Param();
        tempParam.setParam(Constants.makeCvParam("MS:1002048", "MS-GF+"));
        msgfPlus.setSoftwareName(tempParam);
        msgfPlus.setId(analysisSoftID);
        msgfPlus.setVersion("Release (v2023.01.12)");
    }
}

