/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.mzid;

import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.mzid.Unimod;
import edu.ucsd.msjava.mzid.UnimodComposition;
import edu.ucsd.msjava.mzml.MzMLAdapter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.jmzidml.model.mzidml.AnalysisData;
import uk.ac.ebi.jmzidml.model.mzidml.AnalysisProtocolCollection;
import uk.ac.ebi.jmzidml.model.mzidml.CvParam;
import uk.ac.ebi.jmzidml.model.mzidml.DBSequence;
import uk.ac.ebi.jmzidml.model.mzidml.DataCollection;
import uk.ac.ebi.jmzidml.model.mzidml.FileFormat;
import uk.ac.ebi.jmzidml.model.mzidml.Inputs;
import uk.ac.ebi.jmzidml.model.mzidml.Modification;
import uk.ac.ebi.jmzidml.model.mzidml.Peptide;
import uk.ac.ebi.jmzidml.model.mzidml.PeptideEvidence;
import uk.ac.ebi.jmzidml.model.mzidml.PeptideEvidenceRef;
import uk.ac.ebi.jmzidml.model.mzidml.SequenceCollection;
import uk.ac.ebi.jmzidml.model.mzidml.SpectraData;
import uk.ac.ebi.jmzidml.model.mzidml.SpectrumIdentificationItem;
import uk.ac.ebi.jmzidml.model.mzidml.SpectrumIdentificationList;
import uk.ac.ebi.jmzidml.model.mzidml.SpectrumIdentificationProtocol;
import uk.ac.ebi.jmzidml.model.mzidml.SpectrumIdentificationResult;
import uk.ac.ebi.jmzidml.model.mzidml.Tolerance;
import uk.ac.ebi.jmzidml.model.mzidml.UserParam;
import uk.ac.ebi.jmzidml.xml.io.MzIdentMLUnmarshaller;

public class MzIDParser {
    private final MzIdentMLUnmarshaller unmarshaller;
    private final boolean showDecoy;
    private boolean doNotShowQValue;
    private final boolean unrollResults;
    private final boolean showMolecularFormula;
    private boolean isPrecursorTolerancePPM;
    private Map<String, Peptide> pepMap;
    private Map<String, DBSequence> dbSeqMap;
    private Map<String, PeptideEvidence> pepEvMap;

    public MzIDParser(File mzIDFile) {
        this(mzIDFile, false, false, false, false);
    }

    public MzIDParser(File mzIDFile, boolean showDecoy, boolean doNotShowQValue, boolean unrollResults, boolean showMolecularFormula) {
        this.unmarshaller = new MzIdentMLUnmarshaller(mzIDFile);
        this.showDecoy = showDecoy;
        this.doNotShowQValue = doNotShowQValue;
        this.unrollResults = unrollResults;
        this.showMolecularFormula = showMolecularFormula;
    }

    public void writeToTSVFile(File outputFile) {
        PrintStream out = null;
        if (outputFile != null) {
            try {
                out = new PrintStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            out = System.out;
        }
        this.writeToTSVFile(out);
        if (out != System.out) {
            out.close();
        }
    }

    public void writeToTSVFile(PrintStream out) {
        this.unmarshallSequenceCollection();
        this.unmarshallAnalysisProtocolCollection();
        DataCollection dc = this.unmarshaller.unmarshal(DataCollection.class);
        boolean isMgf = false;
        HashMap<String, String> specFileNameMap = new HashMap<String, String>();
        Inputs inputs = dc.getInputs();
        for (SpectraData sd : inputs.getSpectraData()) {
            String specFileName = new File(sd.getLocation()).getName();
            specFileNameMap.put(sd.getId(), specFileName);
            FileFormat ff = sd.getFileFormat();
            if (!ff.getCvParam().getAccession().equals("MS:1001062")) continue;
            isMgf = true;
        }
        String header = "#SpecFile\tSpecID\tScanNum" + (isMgf ? "\tTitle" : "") + "\tFragMethod\tPrecursor\tIsotopeError\tPrecursorError(" + (this.isPrecursorTolerancePPM ? "ppm" : "Da") + ")\tCharge\tPeptide" + (this.showMolecularFormula ? "\tFormula" : "") + "\tProtein\tDeNovoScore\tMSGFScore\tSpecEValue\tEValue" + (!this.doNotShowQValue ? "\tQValue\tPepQValue" : "");
        out.println(header);
        AnalysisData ad = dc.getAnalysisData();
        List<SpectrumIdentificationList> sil = ad.getSpectrumIdentificationList();
        for (SpectrumIdentificationList sIdentList : sil) {
            for (SpectrumIdentificationResult sir : sIdentList.getSpectrumIdentificationResult()) {
                String specFileName = (String)specFileNameMap.get(sir.getSpectraDataRef());
                String specID = sir.getSpectrumID();
                Map<String, CvParam> sirCvParamMap = this.getCvParamMap(sir.getCvParam());
                String scanNum = "-1";
                CvParam scanNumParam = sirCvParamMap.get("MS:1001115");
                if (scanNumParam != null) {
                    scanNum = scanNumParam.getValue();
                }
                String title = "N/A";
                CvParam titleParam = sirCvParamMap.get("MS:1000796");
                if (titleParam != null) {
                    title = titleParam.getValue();
                }
                for (SpectrumIdentificationItem sii : sir.getSpectrumIdentificationItem()) {
                    Double calculatedMassToCharge = sii.getCalculatedMassToCharge();
                    Double experimentalMassToCharge = sii.getExperimentalMassToCharge();
                    int charge = sii.getChargeState();
                    Map<String, CvParam> cvParamMap = this.getCvParamMap(sii.getCvParam());
                    CvParam cvParam = cvParamMap.get("MS:1002050");
                    String deNovoScore = cvParam == null ? "" : cvParam.getValue();
                    cvParam = cvParamMap.get("MS:1002049");
                    String rawScore = cvParam == null ? "" : cvParam.getValue();
                    cvParam = cvParamMap.get("MS:1002052");
                    String specEValue = cvParam == null ? "" : cvParam.getValue();
                    cvParam = cvParamMap.get("MS:1002053");
                    String eValue = cvParam == null ? "" : cvParam.getValue();
                    cvParam = cvParamMap.get("MS:1002054");
                    String psmQValue = cvParam == null ? "" : cvParam.getValue();
                    cvParam = cvParamMap.get("MS:1002055");
                    String pepQValue = cvParam == null ? "" : cvParam.getValue();
                    Map<String, UserParam> userParamMap = this.getUserParamMap(sii.getUserParam());
                    UserParam userParam = userParamMap.get("AssumedDissociationMethod");
                    String fragMethod = userParam == null ? null : userParam.getValue();
                    userParam = userParamMap.get("IsotopeError");
                    Integer isotopeError = userParam == null ? null : Integer.valueOf(Integer.parseInt(userParam.getValue()));
                    double adjustedExpMz = experimentalMassToCharge - 1.0033548299999993 * (double)isotopeError.intValue() / (double)charge;
                    double precursorError = adjustedExpMz - calculatedMassToCharge;
                    if (this.isPrecursorTolerancePPM) {
                        precursorError = precursorError / calculatedMassToCharge * 1000000.0;
                    }
                    Peptide peptide = this.pepMap.get(sii.getPeptideRef());
                    String peptideSeq = MzIDParser.getPeptideSeq(peptide);
                    String molecularFormula = null;
                    if (this.showMolecularFormula) {
                        molecularFormula = MzIDParser.getMolecularFormula(peptide);
                    }
                    HashSet<String> proteinSet = new HashSet<String>();
                    if (this.unrollResults) {
                        for (PeptideEvidenceRef pepEvRef : sii.getPeptideEvidenceRef()) {
                            PeptideEvidence pepEv = this.pepEvMap.get(pepEvRef.getPeptideEvidenceRef());
                            boolean isDecoy = pepEv.isIsDecoy();
                            if (isDecoy && !this.showDecoy) continue;
                            String pre = pepEv.getPre();
                            String post = pepEv.getPost();
                            DBSequence dbSeq = this.dbSeqMap.get(pepEv.getDBSequenceRef());
                            String protein = dbSeq.getAccession();
                            if (!proteinSet.add(pre + protein + post)) continue;
                            out.print(specFileName + "\t" + specID + "\t" + scanNum + (!isMgf ? "" : "\t" + title) + "\t" + fragMethod + "\t" + experimentalMassToCharge.floatValue() + "\t" + isotopeError + "\t" + (float)precursorError + "\t" + charge + "\t" + pre + "." + peptideSeq + "." + post + (molecularFormula == null ? "" : "\t" + molecularFormula) + "\t" + protein + "\t" + deNovoScore + "\t" + rawScore + "\t" + specEValue + "\t" + eValue);
                            if (!this.doNotShowQValue) {
                                out.print("\t" + psmQValue + "\t" + pepQValue);
                            }
                            out.println();
                        }
                        continue;
                    }
                    StringBuffer proteinBuf = new StringBuffer();
                    boolean isAllDecoy = true;
                    for (PeptideEvidenceRef pepEvRef : sii.getPeptideEvidenceRef()) {
                        PeptideEvidence pepEv = this.pepEvMap.get(pepEvRef.getPeptideEvidenceRef());
                        boolean isDecoy = pepEv.isIsDecoy();
                        if (isDecoy && !this.showDecoy) continue;
                        isAllDecoy = false;
                        String pre = pepEv.getPre();
                        String post = pepEv.getPost();
                        DBSequence dbSeq = this.dbSeqMap.get(pepEv.getDBSequenceRef());
                        String protein = dbSeq.getAccession();
                        if (!proteinSet.add(pre + protein + post)) continue;
                        if (proteinBuf.length() != 0) {
                            proteinBuf.append(";");
                        }
                        proteinBuf.append(protein + "(pre=" + pre + ",post=" + post + ")");
                    }
                    if (isAllDecoy) continue;
                    out.print(specFileName + "\t" + specID + "\t" + scanNum + (!isMgf ? "" : "\t" + title) + "\t" + fragMethod + "\t" + experimentalMassToCharge.floatValue() + "\t" + isotopeError + "\t" + (float)precursorError + "\t" + charge + "\t" + peptideSeq + (molecularFormula == null ? "" : "\t" + molecularFormula) + "\t" + proteinBuf.toString() + "\t" + deNovoScore + "\t" + rawScore + "\t" + specEValue + "\t" + eValue);
                    if (!this.doNotShowQValue) {
                        out.print("\t" + psmQValue + "\t" + pepQValue);
                    }
                    out.println();
                }
            }
        }
    }

    private Map<String, CvParam> getCvParamMap(List<CvParam> paramList) {
        HashMap<String, CvParam> paramMap = new HashMap<String, CvParam>();
        for (CvParam param : paramList) {
            paramMap.put(param.getAccession(), param);
        }
        return paramMap;
    }

    private Map<String, UserParam> getUserParamMap(List<UserParam> paramList) {
        HashMap<String, UserParam> paramMap = new HashMap<String, UserParam>();
        for (UserParam param : paramList) {
            paramMap.put(param.getName(), param);
        }
        return paramMap;
    }

    private void unmarshallSequenceCollection() {
        SequenceCollection sc = this.unmarshaller.unmarshal(SequenceCollection.class);
        this.dbSeqMap = new HashMap<String, DBSequence>();
        for (DBSequence dbSeq : sc.getDBSequence()) {
            this.dbSeqMap.put(dbSeq.getId(), dbSeq);
        }
        this.pepMap = new HashMap<String, Peptide>();
        for (Peptide peptide : sc.getPeptide()) {
            this.pepMap.put(peptide.getId(), peptide);
        }
        this.pepEvMap = new HashMap<String, PeptideEvidence>();
        for (PeptideEvidence pepEv : sc.getPeptideEvidence()) {
            this.pepEvMap.put(pepEv.getId(), pepEv);
        }
    }

    private void unmarshallAnalysisProtocolCollection() {
        AnalysisProtocolCollection apc = this.unmarshaller.unmarshal(AnalysisProtocolCollection.class);
        SpectrumIdentificationProtocol sip = apc.getSpectrumIdentificationProtocol().get(0);
        this.isPrecursorTolerancePPM = false;
        Tolerance parentTolerance = sip.getParentTolerance();
        for (CvParam cvParam : parentTolerance.getCvParam()) {
            if (!cvParam.getAccession().equals("MS:1001412") || !cvParam.getUnitName().equals("parts per million")) continue;
            this.isPrecursorTolerancePPM = true;
            break;
        }
        if (!this.doNotShowQValue) {
            for (UserParam userParam : sip.getAdditionalSearchParams().getUserParam()) {
                if (!userParam.getName().equals("TargetDecoyApproach")) continue;
                if (!userParam.getValue().equals("false")) break;
                this.doNotShowQValue = true;
                break;
            }
        }
    }

    private static String getPeptideSeq(Peptide peptide) {
        String unmodPepSeq = peptide.getPeptideSequence();
        String[] modArr = new String[unmodPepSeq.length() + 2];
        for (Modification mod : peptide.getModification()) {
            double modMass = mod.getMonoisotopicMassDelta();
            String massStr = modMass >= 0.0 ? "+" + String.format("%.3f", modMass) : String.format("%.3f", modMass);
            if (modArr[mod.getLocation()] == null) {
                modArr[mod.getLocation().intValue()] = massStr;
                continue;
            }
            int n = mod.getLocation();
            modArr[n] = modArr[n] + massStr;
        }
        StringBuffer buf = new StringBuffer();
        if (modArr[0] != null) {
            buf.append(modArr[0]);
        }
        for (int i = 0; i < unmodPepSeq.length(); ++i) {
            buf.append(unmodPepSeq.charAt(i));
            if (modArr[i + 1] == null) continue;
            buf.append(modArr[i + 1]);
        }
        if (modArr[modArr.length - 1] != null) {
            buf.append(modArr[modArr.length - 1]);
        }
        return buf.toString();
    }

    private static String getMolecularFormula(Peptide peptide) {
        AminoAcidSet stdAASet = AminoAcidSet.getStandardAminoAcidSet();
        String unmodPepSeq = peptide.getPeptideSequence();
        UnimodComposition composition = new UnimodComposition();
        for (int i = 0; i < unmodPepSeq.length(); ++i) {
            char residue = unmodPepSeq.charAt(i);
            composition.add(stdAASet.getAminoAcid(residue).getComposition());
        }
        for (Modification mod : peptide.getModification()) {
            boolean hasComposition = false;
            for (CvParam cvParam : mod.getCvParam()) {
                String accession = cvParam.getAccession();
                String deltaComposition = Unimod.getUnimod().getDeltaComposition(accession);
                if (deltaComposition == null) continue;
                composition.add(deltaComposition);
                hasComposition = true;
                break;
            }
            if (hasComposition) continue;
            composition.add(mod.getMonoisotopicMassDelta());
        }
        composition.add("H", 2);
        composition.add("O", 1);
        return composition.toString();
    }

    public static void main(String[] argv) throws Exception {
        long time = System.currentTimeMillis();
        MzMLAdapter.turnOffLogs();
        File mzidFile = new File(System.getProperty("user.home") + "/Research/Data/QCShew/test.mzid");
        File outputFile = new File(System.getProperty("user.home") + "/Research/Data/QCShew/test.tsv");
        MzIDParser parser = new MzIDParser(mzidFile);
        parser.writeToTSVFile(outputFile);
        System.out.println("Elapsed time: " + (float)(System.currentTimeMillis() - time) / 1000.0f);
    }
}

