/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.mzml;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import edu.ucsd.msjava.mzid.Constants;
import java.io.File;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.jmzidml.model.mzidml.CvParam;
import uk.ac.ebi.jmzml.model.mzml.CVParam;
import uk.ac.ebi.jmzml.model.mzml.SourceFile;
import uk.ac.ebi.jmzml.xml.io.MzMLObjectIterator;
import uk.ac.ebi.jmzml.xml.io.MzMLUnmarshaller;

public class MzMLAdapter {
    private final File specFile;
    private MzMLUnmarshaller unmarshaller;
    private int minMSLevel = 2;
    private int maxMSLevel = Integer.MAX_VALUE;
    private CvParam spectrumIDFormatCvParam = null;
    private static boolean logOff = false;

    public MzMLAdapter(File specFile) {
        MzMLAdapter.turnOffLogs();
        this.specFile = specFile;
        this.unmarshaller = new MzMLUnmarshaller(specFile);
    }

    public MzMLAdapter msLevel(int minMSLevel, int maxMSLevel) {
        this.minMSLevel = minMSLevel;
        this.maxMSLevel = maxMSLevel;
        return this;
    }

    public MzMLUnmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public int getMinMSLevel() {
        return this.minMSLevel;
    }

    public int getMaxMSLevel() {
        return this.maxMSLevel;
    }

    public CvParam getSpectrumIDFormatCvParam() {
        if (this.spectrumIDFormatCvParam != null) {
            return this.spectrumIDFormatCvParam;
        }
        MzMLObjectIterator itr = this.unmarshaller.unmarshalCollectionFromXpath("/fileDescription/sourceFileList/sourceFile", SourceFile.class);
        while (itr.hasNext()) {
            SourceFile sourceFile = (SourceFile)itr.next();
            for (CVParam param : sourceFile.getCvParam()) {
                String tempAcc = param.getAccession();
                long accNum = Long.parseLong(tempAcc.substring(tempAcc.lastIndexOf(58) + 1));
                if ((accNum < 1000768L || accNum > 1000777L) && accNum != 1000823L && accNum != 1000824L && accNum != 1000929L && accNum != 1001508L && accNum != 1001526L && accNum != 1001528L && accNum != 1001531L && accNum != 1001532L && accNum != 1001559L && accNum != 1001562L && accNum != 1002818L && accNum != 1001480L && accNum != 1002303L && accNum != 1002532L && accNum != 1002898L) continue;
                this.spectrumIDFormatCvParam = Constants.makeCvParam(param.getAccession(), param.getName());
                return this.spectrumIDFormatCvParam;
            }
        }
        System.err.println("Unsupported mzML format: " + this.specFile.getAbsolutePath() + " does not contain a child term of MS:1000767 (native spectrum identifier format)");
        System.err.println("Unsupported mzML format: " + this.specFile.getAbsolutePath());
        System.exit(-1);
        return null;
    }

    public static void turnOffLogs() {
        if (!logOff) {
            LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
            context.reset();
            Logger rootLogger = context.getLogger("ROOT");
            rootLogger.detachAndStopAllAppenders();
        }
    }

    public static void main(String[] argv) throws Exception {
        MzMLAdapter.test();
    }

    public static void test() throws Exception {
        long time = System.currentTimeMillis();
        File specFile = new File(System.getProperty("user.home") + "/Research/Data/QCShew/QC_Shew_12_02_2_1Aug12_Cougar_12-06-11.mzML");
        MzMLAdapter adapter = new MzMLAdapter(specFile);
        System.out.println("Unmarshaller: " + (System.currentTimeMillis() - time) / 1000L);
        System.out.println(adapter.getSpectrumIDFormatCvParam().getAccession() + " " + adapter.getSpectrumIDFormatCvParam().getName());
    }
}

