/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.mzml;

import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.mzml.MzMLAdapter;
import edu.ucsd.msjava.mzml.SpectrumConverter;
import java.io.File;
import java.util.Iterator;
import uk.ac.ebi.jmzml.model.mzml.Spectrum;
import uk.ac.ebi.jmzml.xml.io.MzMLObjectIterator;
import uk.ac.ebi.jmzml.xml.io.MzMLUnmarshaller;

public class MzMLSpectraIterator
implements Iterator<edu.ucsd.msjava.msutil.Spectrum>,
Iterable<edu.ucsd.msjava.msutil.Spectrum> {
    private final MzMLUnmarshaller unmarshaller;
    private final int minMSLevel;
    private final int maxMSLevel;
    private MzMLObjectIterator<Spectrum> itr;
    private boolean hasNext;
    private edu.ucsd.msjava.msutil.Spectrum currentSpectrum = null;
    private long negativePolarityWarningCount;

    public MzMLSpectraIterator(MzMLAdapter mzmlAdapter) {
        this.unmarshaller = mzmlAdapter.getUnmarshaller();
        this.minMSLevel = mzmlAdapter.getMinMSLevel();
        this.maxMSLevel = mzmlAdapter.getMaxMSLevel();
        this.negativePolarityWarningCount = 0L;
        this.itr = this.unmarshaller.unmarshalCollectionFromXpath("/run/spectrumList/spectrum", Spectrum.class);
        this.currentSpectrum = this.parseNextSpectrum();
        this.hasNext = this.currentSpectrum != null;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public edu.ucsd.msjava.msutil.Spectrum next() {
        edu.ucsd.msjava.msutil.Spectrum curSpecCopy = this.currentSpectrum;
        this.currentSpectrum = this.parseNextSpectrum();
        if (this.currentSpectrum == null) {
            this.hasNext = false;
        }
        if (curSpecCopy.getScanPolarity() == Spectrum.Polarity.NEGATIVE) {
            this.warnNegativePolarity(curSpecCopy);
        }
        return curSpecCopy;
    }

    public edu.ucsd.msjava.msutil.Spectrum parseNextSpectrum() {
        edu.ucsd.msjava.msutil.Spectrum spec = null;
        Spectrum jmzSpec = null;
        while (this.itr.hasNext()) {
            jmzSpec = (Spectrum)this.itr.next();
            spec = SpectrumConverter.getSpectrumFromJMzMLSpec(jmzSpec);
            if (spec.getMSLevel() < this.minMSLevel || spec.getMSLevel() > this.maxMSLevel) continue;
            return spec;
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("SpectraIterator.remove() not implemented");
    }

    @Override
    public Iterator<edu.ucsd.msjava.msutil.Spectrum> iterator() {
        return this;
    }

    public static void main(String[] argv) throws Exception {
        MzMLSpectraIterator.test();
    }

    public static void test() throws Exception {
        File xmlFile = new File("/cygwin/home/kims336/Research/Data/JMzReader/example.mzML");
        xmlFile = new File("/cygwin/home/kims336/Research/Data/JMzReader/small.pwiz.1.1.mzML");
        MzMLAdapter adapter = new MzMLAdapter(xmlFile);
        MzMLSpectraIterator itr = new MzMLSpectraIterator(adapter);
        while (itr.hasNext()) {
            edu.ucsd.msjava.msutil.Spectrum spec = itr.next();
            System.out.println("-----------");
            System.out.println(spec.getID());
            System.out.println(spec.getSpecIndex());
            System.out.println(spec.getMSLevel());
            if (spec.getMSLevel() != 2) continue;
            System.out.println(spec.getPrecursorPeak().getMz());
            System.out.println(spec.getPrecursorPeak().getCharge());
            System.out.println(spec.getActivationMethod().getName());
        }
    }

    private void warnNegativePolarity(edu.ucsd.msjava.msutil.Spectrum currentSpectrum) {
        ++this.negativePolarityWarningCount;
        if (this.negativePolarityWarningCount > 10L) {
            return;
        }
        if (this.negativePolarityWarningCount == 1L) {
            System.out.println("Warning: negative polarity spectrum found; you likely need to use a negative charge carrier");
        }
        System.out.println("Negative polarity spectrum found, scan " + Long.toString(currentSpectrum.getScanNum()));
        if (this.negativePolarityWarningCount == 10L) {
            System.out.println("Additional warnings regarding negative polarity will not be shown");
        }
    }
}

