/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.mzml;

import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.CvParamInfo;
import edu.ucsd.msjava.msutil.Peak;
import edu.ucsd.msjava.msutil.Spectrum;
import java.util.Collections;
import uk.ac.ebi.jmzml.model.mzml.BinaryDataArray;
import uk.ac.ebi.jmzml.model.mzml.CVParam;
import uk.ac.ebi.jmzml.model.mzml.ParamGroup;
import uk.ac.ebi.jmzml.model.mzml.Precursor;
import uk.ac.ebi.jmzml.model.mzml.PrecursorList;
import uk.ac.ebi.jmzml.model.mzml.ScanList;
import uk.ac.ebi.jmzml.model.mzml.Spectrum;
import uk.ac.ebi.jmzml.model.mzml.UserParam;

public class SpectrumConverter {
    public static edu.ucsd.msjava.msutil.Spectrum getSpectrumFromJMzMLSpec(Spectrum jmzMLSpec) {
        edu.ucsd.msjava.msutil.Spectrum spec = new edu.ucsd.msjava.msutil.Spectrum();
        String id = jmzMLSpec.getId();
        spec.setID(id);
        String[] idToken = id.split("\\s+");
        if (idToken.length > 0 && idToken[idToken.length - 1].matches("scan=\\d+")) {
            int scanNum = Integer.parseInt(idToken[idToken.length - 1].substring(5));
            spec.setScanNum(scanNum);
        }
        CVParam msLevelParam = null;
        Boolean isCentroided = false;
        Spectrum.Polarity scanPolarity = Spectrum.Polarity.POSITIVE;
        for (CVParam cvParam : jmzMLSpec.getCvParam()) {
            if (cvParam.getAccession().equals("MS:1000511")) {
                msLevelParam = cvParam;
                continue;
            }
            if (cvParam.getAccession().equals("MS:1000127")) {
                isCentroided = true;
                continue;
            }
            if (cvParam.getAccession().equals("MS:1000128")) {
                isCentroided = false;
                continue;
            }
            if (cvParam.getAccession().equals("MS:1000129")) {
                scanPolarity = Spectrum.Polarity.NEGATIVE;
                continue;
            }
            if (!cvParam.getAccession().equals("MS:1000130")) continue;
            scanPolarity = Spectrum.Polarity.POSITIVE;
        }
        spec.setIsCentroided(isCentroided);
        spec.setScanPolarity(scanPolarity);
        float precursorMz = -1.0f;
        float scanStartTime = -1.0f;
        boolean scanStartTimeIsSeconds = true;
        ScanList scanList = jmzMLSpec.getScanList();
        if (scanList != null && scanList.getCount() > 0 && scanList.getScan().size() > 0) {
            for (CVParam cvParam : scanList.getScan().get(0).getCvParam()) {
                if (cvParam.getAccession().equals("MS:1000016")) {
                    scanStartTime = Float.parseFloat(cvParam.getValue());
                    if (cvParam.getUnitAccession().equals("UO:0000031")) {
                        scanStartTimeIsSeconds = false;
                        continue;
                    }
                    if (!cvParam.getUnitAccession().equals("UO:0000010")) continue;
                    scanStartTimeIsSeconds = true;
                    continue;
                }
                if (!cvParam.getAccession().equals("MS:1001581") && !cvParam.getAccession().equals("MS:1002476") && !cvParam.getAccession().equals("MS:1002815")) continue;
                CvParamInfo cvParamInfo = cvParam.getUnitAccession() != null && !cvParam.getUnitAccession().isEmpty() ? new CvParamInfo(cvParam.getAccession(), cvParam.getName(), cvParam.getValue(), cvParam.getUnitAccession(), cvParam.getUnitName()) : new CvParamInfo(cvParam.getAccession(), cvParam.getName(), cvParam.getValue());
                spec.addAddlCvParam(cvParamInfo);
            }
            for (UserParam param : scanList.getScan().get(0).getUserParam()) {
                if (!param.getName().equals("[Thermo Trailer Extra]Monoisotopic M/Z:")) continue;
                precursorMz = Float.parseFloat(param.getValue());
                break;
            }
        }
        spec.setRt(scanStartTime);
        spec.setRtIsSeconds(scanStartTimeIsSeconds);
        int msLevel = msLevelParam != null ? Integer.parseInt(msLevelParam.getValue()) : 0;
        spec.setMsLevel(msLevel);
        PrecursorList precursorList = jmzMLSpec.getPrecursorList();
        if (precursorList != null && precursorList.getCount() > 0 && precursorList.getPrecursor().get(0).getSelectedIonList() != null) {
            Precursor precursor = precursorList.getPrecursor().get(0);
            ParamGroup isolationWindowParams = precursor.getIsolationWindow();
            if (isolationWindowParams != null && isolationWindowParams.getCvParam() != null) {
                Float isolationWindowTargetMz = null;
                for (CVParam param : isolationWindowParams.getCvParam()) {
                    if (!param.getAccession().equals("MS:1000827")) continue;
                    isolationWindowTargetMz = Float.valueOf(Float.parseFloat(param.getValue()));
                }
                spec.setIsolationWindowTargetMz(isolationWindowTargetMz);
            }
            int precursorCharge = 0;
            float precursorIntensity = 0.0f;
            ParamGroup paramGroup = precursor.getSelectedIonList().getSelectedIon().get(0);
            for (CVParam param : paramGroup.getCvParam()) {
                if ((double)precursorMz < 0.01 && param.getAccession().equals("MS:1000744")) {
                    precursorMz = Float.parseFloat(param.getValue());
                    continue;
                }
                if (param.getAccession().equals("MS:1000041")) {
                    precursorCharge = Integer.parseInt(param.getValue());
                    continue;
                }
                if (!param.getAccession().equals("MS:1000042")) continue;
                precursorIntensity = Float.parseFloat(param.getValue());
            }
            spec.setPrecursor(new Peak(precursorMz, precursorIntensity, precursorCharge));
            ParamGroup actMethodParams = precursor.getActivation();
            boolean isETD = false;
            for (CVParam param : actMethodParams.getCvParam()) {
                ActivationMethod am = ActivationMethod.getByCV(param.getAccession());
                if (am == null) continue;
                if (am == ActivationMethod.ETD) {
                    isETD = true;
                    break;
                }
                if (spec.getActivationMethod() != null) continue;
                spec.setActivationMethod(am);
            }
            if (isETD) {
                spec.setActivationMethod(ActivationMethod.ETD);
            }
        }
        BinaryDataArray mzArray = null;
        BinaryDataArray intenArray = null;
        if (jmzMLSpec.getBinaryDataArrayList() != null && jmzMLSpec.getBinaryDataArrayList().getBinaryDataArray() != null) {
            for (BinaryDataArray array : jmzMLSpec.getBinaryDataArrayList().getBinaryDataArray()) {
                if (array.getEncodedLength() == 0) continue;
                for (CVParam param : array.getCvParam()) {
                    if (param.getAccession().equals("MS:1000514")) {
                        mzArray = array;
                        break;
                    }
                    if (!param.getAccession().equals("MS:1000515")) continue;
                    intenArray = array;
                    break;
                }
                if (mzArray == null || intenArray == null) continue;
                break;
            }
        }
        if (mzArray != null && intenArray != null) {
            Number[] intenNumbers;
            Number[] mzNumbers = mzArray.getBinaryDataAsNumberArray();
            if (mzNumbers.length != (intenNumbers = intenArray.getBinaryDataAsNumberArray()).length) {
                System.err.println("Different sizes for m/z and intensity value arrays for spectrum" + jmzMLSpec.getId());
                System.exit(-1);
            }
            for (int i = 0; i < mzNumbers.length; ++i) {
                spec.add(new Peak(mzNumbers[i].floatValue(), intenNumbers[i].floatValue(), 1));
            }
        }
        spec.setSpecIndex(jmzMLSpec.getIndex() + 1);
        Collections.sort(spec);
        spec.determineIsCentroided();
        return spec;
    }

    public static Float getPrecursorMzFromJMzMLSpec(Spectrum jmzMLSpec) {
        PrecursorList precursorList = jmzMLSpec.getPrecursorList();
        if (precursorList != null && precursorList.getCount() > 0 && precursorList.getPrecursor().get(0).getSelectedIonList() != null) {
            Precursor precursor = precursorList.getPrecursor().get(0);
            float precursorMz = 0.0f;
            ParamGroup paramGroup = precursor.getSelectedIonList().getSelectedIon().get(0);
            for (CVParam param : paramGroup.getCvParam()) {
                if (!param.getAccession().equals("MS:1000744")) continue;
                precursorMz = Float.parseFloat(param.getValue());
                return Float.valueOf(precursorMz);
            }
        }
        return null;
    }
}

