/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.params;

import edu.ucsd.msjava.msutil.FileFormat;
import edu.ucsd.msjava.params.ParamManager;
import edu.ucsd.msjava.params.Parameter;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class FileParameter
extends Parameter {
    private boolean mustExist = false;
    private boolean mustNotExist = false;
    private boolean mustBeADirectory = false;
    private boolean mustBeAFile = false;
    private ArrayList<FileFormat> fileFormats = new ArrayList();
    private File file;
    private FileFormat fileFormat;

    public FileParameter(ParamManager.ParamNameEnum paramInfo) {
        super(paramInfo.getKey(), paramInfo.getName(), paramInfo.getDescription());
        this.setAdditionalDescription(paramInfo.getAdditionalDescription());
    }

    public FileParameter(String key, String name, String description) {
        super(key, name, description);
    }

    public FileParameter setAsOptional() {
        super.setOptional();
        return this;
    }

    public FileParameter fileMustExist() {
        this.mustExist = true;
        return this;
    }

    public FileParameter fileMustNotExist() {
        this.mustNotExist = true;
        return this;
    }

    public FileParameter mustBeADirectory() {
        this.mustBeADirectory = true;
        return this;
    }

    public FileParameter mustBeAFile() {
        this.mustBeAFile = true;
        return this;
    }

    public FileParameter addFileFormat(FileFormat fileFormat) {
        this.fileFormats.add(fileFormat);
        return this;
    }

    public boolean isSupported(FileFormat fileFormat) {
        if (this.fileFormats == null) {
            return false;
        }
        return this.fileFormats.contains(fileFormat);
    }

    @Override
    public String parse(String value) {
        File path = new File(value);
        if (path.isDirectory()) {
            if (this.mustBeAFile) {
                return "must not be a directory";
            }
        } else if (this.mustBeADirectory) {
            return "must be a directory";
        }
        if (!this.fileFormats.isEmpty()) {
            if (path.isDirectory() && this.fileFormats.contains(FileFormat.DIRECTORY)) {
                this.fileFormat = FileFormat.DIRECTORY;
            } else {
                this.fileFormat = null;
                String fileName = path.getName();
                block0: for (FileFormat format : this.fileFormats) {
                    if (!format.isCaseSensitive()) {
                        fileName = fileName.toLowerCase();
                    }
                    for (String suffix : format.getSuffixes()) {
                        if (!format.isCaseSensitive()) {
                            suffix = suffix.toLowerCase();
                        }
                        if (!fileName.endsWith(suffix)) continue;
                        this.fileFormat = format;
                        continue block0;
                    }
                }
            }
            if (this.fileFormat == null) {
                ArrayList<String> knownFileExtensions = new ArrayList<String>();
                for (FileFormat format : this.fileFormats) {
                    if (format == FileFormat.DIRECTORY) continue;
                    for (String suffix : format.getSuffixes()) {
                        knownFileExtensions.add(suffix);
                    }
                }
                return "extension does not match a known file type: " + StringUtils.join(knownFileExtensions, ", ");
            }
        }
        if (this.mustExist && !path.exists()) {
            return "file does not exist";
        }
        if (this.mustNotExist && path.exists()) {
            return "file already exists";
        }
        this.file = path;
        return null;
    }

    public File getFile() {
        return this.file;
    }

    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    @Override
    public String getValueAsString() {
        if (this.file == null) {
            return null;
        }
        return this.file.getPath();
    }
}

